/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbColumnsDifference;
import com.sap.dictionary.database.dbs.DbDeploymentInfo;
import com.sap.dictionary.database.dbs.DbDeploymentStatus;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbIndexesDifference;
import com.sap.dictionary.database.dbs.DbMsgHandler;
import com.sap.dictionary.database.dbs.DbObject;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbPrimaryKeyDifference;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTableDifference;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.MessageFormatter;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.util.HashSet;

public abstract class DbTable
extends DbObject
implements DbsConstants {
    private DbFactory factory = null;
    private DbSchema schema = null;
    private String name = " ";
    private boolean isCaseSensitive = false;
    private DbColumns columns = null;
    private DbPrimaryKey primaryKey = null;
    private DbIndexes indexes = null;
    private DbDeploymentInfo deploymentInfo = null;
    private DbDeploymentStatus deploymentStatus = null;
    private boolean dbSpecificIsSet = false;
    private boolean columnsAreSet = false;
    private boolean indexesAreSet = false;
    private boolean primaryKeyIsSet = false;
    private boolean commonContentIsSet = false;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$dbs$DbTable == null ? (class$com$sap$dictionary$database$dbs$DbTable = DbTable.class$("com.sap.dictionary.database.dbs.DbTable")) : class$com$sap$dictionary$database$dbs$DbTable));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbTable;

    public DbTable() {
    }

    public DbTable(DbFactory factory) {
        this.factory = factory;
    }

    public DbTable(DbFactory factory, String name) {
        this.factory = factory;
        this.name = name;
    }

    public DbTable(DbFactory factory, DbTable other) {
        this.factory = factory;
    }

    public DbTable(DbFactory factory, DbSchema schema, String name) {
        this.factory = factory;
        this.schema = schema;
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColumns(DbColumns columns) {
        if (columns != null && columns.isEmpty()) {
            columns = null;
            return;
        }
        this.columns = columns;
        if (columns != null) {
            // empty if block
        }
        columns.setTable(this);
        this.columnsAreSet = true;
    }

    public void setPrimaryKey(DbPrimaryKey primaryKey) {
        if (primaryKey != null && primaryKey.isEmpty()) {
            primaryKey = null;
            return;
        }
        this.primaryKey = primaryKey;
        if (primaryKey != null) {
            primaryKey.setTable(this);
        }
        this.primaryKeyIsSet = true;
    }

    public void setIndexes(DbIndexes indexes) {
        if (indexes != null && indexes.isEmpty()) {
            indexes = null;
            return;
        }
        this.indexes = indexes;
        if (indexes != null) {
            indexes.setTable(this);
        }
        this.indexesAreSet = true;
    }

    public void setDeploymentStatus(DbDeploymentStatus deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
    }

    public void setDbSpecificIsSet(boolean dbSpecificIsSet) {
        this.dbSpecificIsSet = dbSpecificIsSet;
    }

    public DbFactory getDbFactory() {
        return this.factory;
    }

    public DbColumns getColumns() {
        return this.columns;
    }

    public DbPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public DbIndexes getIndexes() {
        return this.indexes;
    }

    public String getName() {
        return this.name;
    }

    public DbSchema getSchema() {
        return this.schema;
    }

    public DbDeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public DbDeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public boolean DbSpecificIsSet() {
        return this.dbSpecificIsSet;
    }

    public void replaceCommonContent(DbTable origin) {
    }

    public void setCommonContentViaXml(XmlMap xmlMap) throws JddException {
        try {
            XmlMap indexesMap;
            XmlMap table = xmlMap.getXmlMap("Dbtable");
            this.name = table.getString("name");
            this.name = XmlHelper.checkAndGetName(this.name, "Table");
            this.deploymentInfo = new DbDeploymentInfo(table, this.factory);
            this.deploymentStatus = DbDeploymentStatus.getInstance(table.getString("deployment-status"));
            this.setColumns(this.factory.makeDbColumns(table.getXmlMap("columns")));
            if (this.columns.isEmpty()) {
                throw new JddException(ExType.XML_ERROR, DbMsgHandler.get(DbsConstants.RTXML_COLS_MISS));
            }
            XmlMap primaryKeyMap = table.getXmlMap("primary-key");
            if (primaryKeyMap != null && !primaryKeyMap.isEmpty()) {
                this.primaryKey = this.factory.makePrimaryKey();
                this.primaryKey.setCommonContentViaXml(primaryKeyMap);
                this.setPrimaryKey(this.primaryKey);
            }
            if ((indexesMap = table.getXmlMap("indexes")) != null) {
                this.setIndexes(new DbIndexes(this.factory, indexesMap));
            }
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public abstract void setSpecificContentViaXml(XmlMap var1) throws JddException;

    public void setCommonContentViaDb(DbFactory factory) throws JddException {
        try {
            this.setColumnsViaDb(factory);
            this.setPrimaryKeyViaDb();
            this.setIndexesViaDb();
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public void setColumnsViaDb(DbFactory factory) throws JddException {
        try {
            DbColumns cols = factory.makeDbColumns();
            cols.setTable(this);
            cols.setContentViaDb(factory);
            this.setColumns(cols);
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public abstract void setIndexesViaDb() throws JddException;

    public abstract void setPrimaryKeyViaDb() throws JddException;

    public abstract void setSpecificContentViaDb() throws JddException;

    public boolean columnsAreSet() {
        return this.columnsAreSet;
    }

    public boolean primaryKeyIsSet() {
        return this.primaryKeyIsSet;
    }

    public boolean indexesAreSet() {
        return this.indexesAreSet;
    }

    public boolean commonContentIsSet() {
        return this.columnsAreSet || this.primaryKeyIsSet || this.indexesAreSet;
    }

    public abstract boolean existsOnDb();

    public abstract boolean existsData();

    public String toString() {
        return "Table = " + this.name + "\n" + this.deploymentInfo + "deploymentStatus: " + this.deploymentStatus + "\n" + this.columns + this.primaryKey + this.indexes;
    }

    public void writeCommonContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        try {
            file.println(offset0 + "<?xml version=\"1.0\"?>");
            file.println(offset0 + "<Dbtable name=" + "\"" + this.name + "\"" + ">");
            String offset1 = offset0 + XmlHelper.tabulate();
            if (this.deploymentInfo != null) {
                this.deploymentInfo.writeContentToXmlFile(file, offset1);
            }
            String offset2 = offset1 + XmlHelper.tabulate();
            if (this.deploymentStatus != null) {
                file.println(offset1 + "<deployment-status>" + this.deploymentStatus.getName() + "</deployment-status>");
            }
            this.getColumns().writeCommonContentToXmlFile(file, offset1);
            if (this.primaryKey != null) {
                this.primaryKey.writeCommonContentToXmlFile(file, offset1);
            }
            if (this.indexes != null) {
                this.indexes.writeCommonContentToXmlFile(file, offset1);
            }
            file.println(offset0 + "</Dbtable>");
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public abstract void writeSpecificContentToXmlFile(PrintWriter var1, String var2) throws JddException;

    public DbObjectSqlStatements getDdlStatementsForCreate() throws JddException {
        DbObjectSqlStatements tableDef = new DbObjectSqlStatements(this.name);
        DbSqlStatement createLine = new DbSqlStatement();
        boolean doNotCreate = false;
        if (this.deploymentInfo != null) {
            doNotCreate = this.deploymentInfo.doNotCreate();
        }
        if (!doNotCreate) {
            try {
                createLine.addLine("CREATE TABLE \"" + this.name + "\"");
                createLine.merge(this.columns.getDdlClause());
                tableDef.add(createLine);
                if (this.indexes != null) {
                    tableDef.merge(this.indexes.getDdlStatementsForCreate());
                }
                if (this.primaryKey != null) {
                    tableDef.merge(this.primaryKey.getDdlStatementsForCreate());
                }
                return tableDef;
            }
            catch (Exception ex) {
                throw JddException.createInstance(ex);
            }
        }
        return null;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() throws JddException {
        DbObjectSqlStatements tableDef = new DbObjectSqlStatements(this.name);
        DbSqlStatement dropLine = new DbSqlStatement(true);
        try {
            dropLine.addLine("DROP TABLE \"" + this.name + "\"");
            tableDef.add(dropLine);
            return tableDef;
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public DbTableDifference compareTo(DbTable target) throws Exception {
        DbTableDifference tableDiff = this.factory.makeDbTableDifference(this, target);
        DbColumnsDifference colsDiff = null;
        DbIndexesDifference indexesDiff = null;
        DbPrimaryKeyDifference primKeyDiff = null;
        boolean positionIsRelevant = false;
        if (this.deploymentInfo != null) {
            positionIsRelevant = this.deploymentInfo.positionIsRelevant();
        }
        colsDiff = this.columns.compareTo(target.getColumns(), positionIsRelevant);
        tableDiff.setColumnsDifference(colsDiff);
        if (colsDiff != null) {
            tableDiff.setAction(colsDiff.getAction());
            if (colsDiff.getAction() == Action.CONVERT) {
                return tableDiff;
            }
        }
        DbIndexes targetIndexes = target.getIndexes();
        if (this.indexes == null) {
            if (targetIndexes != null) {
                indexesDiff = new DbIndexesDifference(this.indexes, targetIndexes);
            }
        } else {
            indexesDiff = this.indexes.compareTo(targetIndexes);
        }
        tableDiff.setIndexesDifference(indexesDiff);
        if (indexesDiff != null) {
            tableDiff.setAction(Action.ALTER);
        }
        DbPrimaryKey targetKey = target.getPrimaryKey();
        if (this.primaryKey == null && targetKey != null) {
            primKeyDiff = this.factory.makeDbPrimaryKeyDifference(null, targetKey, Action.CREATE);
        } else if (this.primaryKey != null && targetKey == null) {
            primKeyDiff = this.factory.makeDbPrimaryKeyDifference(this.primaryKey, null, Action.DROP);
        } else if (this.primaryKey != null && targetKey != null) {
            primKeyDiff = this.primaryKey.compareTo(target.getPrimaryKey());
        }
        if (primKeyDiff != null) {
            tableDiff.setPrimaryKeyDifference(primKeyDiff);
            tableDiff.setAction(Action.ALTER);
        }
        if (colsDiff == null && indexesDiff == null && primKeyDiff == null) {
            tableDiff = null;
        }
        return tableDiff;
    }

    public boolean checkWidth() {
        return true;
    }

    public boolean checkNameLength() {
        return true;
    }

    public boolean checkNameForReservedWord() {
        return true;
    }

    public final boolean check() {
        Object[] arguments = new Object[]{this.name, this.factory.getDatabaseName()};
        boolean primaryKeyIsOk = true;
        boolean indexesAreOk = true;
        if (this.primaryKey != null) {
            primaryKeyIsOk = this.primaryKey.check();
        }
        if (this.indexes != null) {
            indexesAreOk = this.indexes.check();
        }
        if (this.checkWidth() & this.checkNameLength() & this.columns.check() & primaryKeyIsOk & indexesAreOk) {
            loc.exiting();
            return true;
        }
        return false;
    }

    public static HashSet getCheckMessages() {
        return MessageFormatter.getMessages();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

