/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import java.io.PrintWriter;

public class DbIndexColumnInfo {
    private String name = " ";
    private boolean isDescending = false;

    public DbIndexColumnInfo(String name, boolean isDescending) {
        this.name = name;
        this.isDescending = isDescending;
    }

    public DbIndexColumnInfo(XmlMap xmlMap) {
        this.name = xmlMap.getString("name");
        this.isDescending = xmlMap.getBoolean("is-descending");
    }

    public String getName() {
        return this.name;
    }

    public boolean isDescending() {
        return this.isDescending;
    }

    public boolean equals(DbIndexColumnInfo other) {
        return this.name.equalsIgnoreCase(other.name) && this.isDescending == other.isDescending;
    }

    public String toString() {
        return "Columnname = " + this.name + "\n" + "isDescending:" + this.isDescending + "\n";
    }

    void writeCommonContentToXmlFile(PrintWriter file, String offset0) throws Exception {
        file.println(offset0 + "<column>");
        String offset1 = offset0 + XmlHelper.tabulate();
        file.println(offset1 + "<name>" + this.name + "</name>");
        file.println(offset1 + "<is-descending>" + this.isDescending + "</is-descending>");
        file.println(offset0 + "</column>");
    }
}

