/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class DbColumnsDifference {
    private LinkedList diffs = new LinkedList();
    private LinkedList diffsWithAdd = new LinkedList();
    private LinkedList diffsWithDrop = new LinkedList();
    private LinkedList diffsWithModify = new LinkedList();
    private LinkedList diffsWithTypeLenDecChange = new LinkedList();
    private LinkedList diffsWithNullabilityChange = new LinkedList();
    private LinkedList diffsWithDefaultValueChange = new LinkedList();
    private Action action = Action.ALTER;

    protected void add(DbColumnDifference difference) {
        DbColumnDifferencePlan plan;
        this.diffs.add(difference);
        if (difference.getOrigin() == null) {
            this.diffsWithAdd.add(difference);
        }
        if (difference.getTarget() == null) {
            this.diffsWithDrop.add(difference);
        }
        if ((plan = difference.getDifferencePlan()) != null) {
            if (plan.somethingIsChanged()) {
                this.diffsWithModify.add(difference);
            }
            if (plan.nullabilityIsChanged()) {
                this.diffsWithNullabilityChange.add(difference);
            }
            if (plan.defaultValueIsChanged()) {
                this.diffsWithDefaultValueChange.add(difference);
            }
            if (plan.typeLenDecIsChanged()) {
                this.diffsWithTypeLenDecChange.add(difference);
            }
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean isEmpty() {
        return this.diffs.isEmpty();
    }

    public MultiIterator iterator() {
        return new MultiIterator();
    }

    public abstract DbObjectSqlStatements getDdlStatementsForAlter(String var1) throws Exception;

    public String toString() {
        String s = "";
        Iterator iterator = this.diffs.iterator();
        while (iterator.hasNext()) {
            s = s + iterator.next();
        }
        return s;
    }

    public class MultiIterator {
        private Iterator diffsIterator;
        private Iterator addIterator;
        private Iterator dropIterator;
        private Iterator modifyIterator;
        private Iterator typeLenDecChangeIterator;
        private Iterator nullabilityChangeIterator;
        private Iterator defaultValueChangeIterator;

        MultiIterator() {
            this.diffsIterator = DbColumnsDifference.this.diffs.iterator();
            this.addIterator = DbColumnsDifference.this.diffsWithAdd.iterator();
            this.dropIterator = DbColumnsDifference.this.diffsWithDrop.iterator();
            this.modifyIterator = DbColumnsDifference.this.diffsWithModify.iterator();
            this.typeLenDecChangeIterator = DbColumnsDifference.this.diffsWithTypeLenDecChange.iterator();
            this.nullabilityChangeIterator = DbColumnsDifference.this.diffsWithNullabilityChange.iterator();
            this.defaultValueChangeIterator = DbColumnsDifference.this.diffsWithDefaultValueChange.iterator();
        }

        public DbColumnDifference next() {
            return (DbColumnDifference)this.diffsIterator.next();
        }

        public boolean hasNext() {
            return this.diffsIterator.hasNext();
        }

        public DbColumnDifference nextWithAdd() {
            return (DbColumnDifference)this.addIterator.next();
        }

        public boolean hasNextWithAdd() {
            return this.addIterator.hasNext();
        }

        public DbColumnDifference nextWithDrop() {
            return (DbColumnDifference)this.dropIterator.next();
        }

        public boolean hasNextWithDrop() {
            return this.dropIterator.hasNext();
        }

        public DbColumnDifference nextWithModify() {
            return (DbColumnDifference)this.modifyIterator.next();
        }

        public boolean hasNextWithModify() {
            return this.modifyIterator.hasNext();
        }

        public DbColumnDifference nextWithTypeLenDecChange() {
            return (DbColumnDifference)this.typeLenDecChangeIterator.next();
        }

        public boolean hasNextWithTypeLenDecChange() {
            return this.typeLenDecChangeIterator.hasNext();
        }

        public DbColumnDifference nextWithNullabilityChange() {
            return (DbColumnDifference)this.nullabilityChangeIterator.next();
        }

        public boolean hasNextWithNullabilityChange() {
            return this.nullabilityChangeIterator.hasNext();
        }

        public DbColumnDifference nextWithDefaultValueChange() {
            return (DbColumnDifference)this.defaultValueChangeIterator.next();
        }

        public boolean hasNextWithDefaultValueChange() {
            return this.defaultValueChangeIterator.hasNext();
        }
    }
}

