/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.JavaSqlTypeInfo;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.JddRuntimeException;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class DbColumn
implements DbsConstants {
    private DbFactory factory = null;
    private String name = null;
    private boolean isCaseSensitive = false;
    private int position = 1;
    private String srcType = null;
    private int javaSqlType = 0;
    private String javaSqlTypeName = null;
    private String dbType = null;
    private long length = 0L;
    private int decimals = 0;
    private boolean isNotNull = false;
    private String defaultValue = null;
    private DbColumn next = null;
    private DbColumn previous = null;
    private JavaSqlTypeInfo javaSqlTypeInfo = null;
    private DbColumns columns = null;
    private ArrayList addInfos = null;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$dbs$DbColumn == null ? (class$com$sap$dictionary$database$dbs$DbColumn = DbColumn.class$("com.sap.dictionary.database.dbs.DbColumn")) : class$com$sap$dictionary$database$dbs$DbColumn));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbColumn;

    public DbColumn() {
    }

    public DbColumn(DbFactory factory) {
        this.factory = factory;
    }

    public DbColumn(DbFactory factory, DbColumn other) {
        this.factory = factory;
    }

    public DbColumn(DbFactory factory, XmlMap xmlMap) {
        this.factory = factory;
        this.name = xmlMap.getString("name");
        try {
            this.name = XmlHelper.checkAndGetName(this.name, "Column");
        }
        catch (JddException ex) {
            ex.printStackTrace();
        }
        this.position = xmlMap.getInt("position");
        this.srcType = xmlMap.getString("src-type");
        this.javaSqlTypeInfo = factory.getJavaSqlTypes().getInfo(xmlMap.getString("java-sql-type"));
        this.javaSqlType = this.javaSqlTypeInfo.getIntCode();
        this.javaSqlTypeName = this.javaSqlTypeInfo.getName();
        this.dbType = xmlMap.getString("db-type");
        if (this.dbType != null && this.dbType.equalsIgnoreCase("null")) {
            this.dbType = null;
        }
        this.length = xmlMap.getInt("length");
        this.decimals = xmlMap.getInt("decimals");
        this.isNotNull = xmlMap.getBoolean("is-not-null");
        this.defaultValue = DbColumn.removeTrailingSpaces(xmlMap.getAuthenticString("default-value"));
        if (this.defaultValue != null && !this.javaSqlTypeInfo.hasDefaultValue()) {
            throw new JddRuntimeException(DbsConstants.DEV_VALUE_FORBID, new Object[]{this.name, this.javaSqlTypeName}, cat, 500, loc);
        }
    }

    public DbColumn(DbFactory factory, String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) {
        this.factory = factory;
        this.constructorPart(factory, name, position, javaSqlType, dbType, length, decimals, isNotNull, defaultValue);
    }

    public void constructorPart(DbFactory factory, String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) {
        this.name = name;
        this.position = position;
        this.javaSqlType = javaSqlType;
        this.javaSqlTypeInfo = factory.getJavaSqlTypes().getInfo(javaSqlType);
        this.javaSqlTypeName = this.javaSqlTypeInfo.getName();
        this.dbType = dbType;
        this.length = this.javaSqlTypeInfo.hasByteFactor() ? length / (long)this.javaSqlTypeInfo.getByteFactor() : length;
        this.decimals = decimals;
        this.isNotNull = isNotNull;
        this.defaultValue = defaultValue;
        if (defaultValue != null) {
            String prefix = this.javaSqlTypeInfo.getDefaultValuePrefix();
            String suffix = this.javaSqlTypeInfo.getDefaultValueSuffix();
            if (prefix != null && suffix != null && !prefix.trim().equalsIgnoreCase("") && !suffix.trim().equalsIgnoreCase("")) {
                String defaultValueTrim = defaultValue.trim();
                if (defaultValueTrim.startsWith(prefix) && defaultValueTrim.endsWith(suffix) && defaultValueTrim.length() > 1) {
                    this.defaultValue = defaultValueTrim.substring(prefix.length(), defaultValueTrim.length() - suffix.length());
                }
            } else {
                this.defaultValue = this.javaSqlTypeInfo.trimDefaultValue() ? defaultValue.trim() : defaultValue;
            }
        }
    }

    public String getDdlTypeClause() throws Exception {
        String clause = "";
        long byteLength = this.length;
        clause = this.javaSqlTypeInfo.getDdlName();
        if (this.javaSqlTypeInfo.hasLengthAttribute() && this.length > 0L) {
            if (this.javaSqlTypeInfo.hasByteFactor()) {
                byteLength = this.length * (long)this.javaSqlTypeInfo.getByteFactor();
            }
            clause = clause + "(" + byteLength;
            if (this.javaSqlTypeInfo.hasDecimals()) {
                clause = clause + "," + this.decimals;
            }
            clause = clause + ")";
        } else if (this.javaSqlTypeInfo.getDdlDefaultLength() > 0) {
            clause = clause + "(" + this.javaSqlTypeInfo.getDdlDefaultLength();
            clause = clause + ")";
        }
        clause = clause + this.javaSqlTypeInfo.getDdlSuffix();
        return clause;
    }

    public String getDdlDefaultValueClause() throws Exception {
        String clause = "";
        if (this.javaSqlTypeInfo.hasDefaultValue() && this.defaultValue != null) {
            clause = "DEFAULT " + this.javaSqlTypeInfo.getDefaultValuePrefix() + this.defaultValue + this.javaSqlTypeInfo.getDefaultValueSuffix();
        }
        return clause;
    }

    public String getDdlClause() throws Exception {
        String clause = " ";
        clause = "\"" + this.name + "\"" + " " + this.getDdlTypeClause() + " " + this.getDdlDefaultValueClause() + " ";
        if (this.isNotNull) {
            clause = clause + "NOT NULL";
        }
        return clause;
    }

    protected abstract DbColumnDifference compareTo(DbColumn var1) throws Exception;

    protected abstract boolean acceptedAdd();

    protected abstract boolean acceptedDrop();

    public boolean check() {
        return this.checkNameLength() & this.checkTypeAttributes();
    }

    public boolean checkNameLength() {
        return true;
    }

    public boolean checkTypeAttributes() {
        return true;
    }

    public boolean checkNameForReservedWord() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    public int getPosition() {
        return this.position;
    }

    public String getSrcType() {
        return this.srcType;
    }

    public int getJavaSqlType() {
        return this.javaSqlType;
    }

    public String getJavaSqlTypeName() {
        return this.javaSqlTypeName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public long getLength() {
        return this.length;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public JavaSqlTypeInfo getJavaSqlTypeInfo() {
        return this.javaSqlTypeInfo;
    }

    public DbColumn getNext() {
        return this.next;
    }

    public DbColumn getPrevious() {
        return this.previous;
    }

    public void setColumns(DbColumns dbColumns) {
        this.columns = dbColumns;
    }

    public DbColumns getColumns() {
        return this.columns;
    }

    protected void setNext(DbColumn column) {
        this.next = column;
    }

    protected void setPrevious(DbColumn column) {
        this.previous = column;
    }

    public String toString() {
        return "Column = " + this.name + "\n" + "Position      : " + this.position + "\n" + "Source Type   : " + this.srcType + "\n" + "Java SqlType  : " + this.javaSqlTypeName + "\n" + "DB Type       : " + this.dbType + "\n" + "Length        : " + this.length + "\n" + "Decimals      : " + this.decimals + "\n" + "is Not Null   : " + this.isNotNull + "\n" + "Default Value : " + this.defaultValue + "\n";
    }

    public void writeCommonContentToXmlFile(PrintWriter file, String offset0) throws Exception {
        file.println(offset0 + "<column name=" + "\"" + this.name + "\"" + ">");
        String offset = offset0 + XmlHelper.tabulate();
        file.println(offset + "<position>" + this.position + "</position>");
        file.println(offset + "<java-sql-type>" + this.javaSqlTypeName + "</java-sql-type>");
        if (this.dbType != null) {
            file.println(offset + "<db-type>" + this.dbType + "</db-type>");
        }
        file.println(offset + "<length>" + this.length + "</length>");
        file.println(offset + "<decimals>" + this.decimals + "</decimals>");
        file.println(offset + "<is-not-null>" + this.isNotNull + "</is-not-null>");
        if (this.defaultValue != null) {
            file.println(offset + "<default-value>" + this.defaultValue + "</default-value>");
        }
        file.println(offset0 + "</column>");
    }

    public static String removeTrailingSpaces(String s) {
        if (s == null) {
            return null;
        }
        int count = s.length();
        int len = s.length();
        boolean st = false;
        char[] val = new char[len];
        if (len == 0) {
            return null;
        }
        int i = count;
        while (i > 0) {
            if (s.charAt(i - 1) > ' ') break;
            --len;
            --i;
        }
        if (len > 0) {
            return s.substring(0, len);
        }
        return " ";
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String javaSqlTypeName) {
        this.javaSqlTypeName = javaSqlTypeName;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

