/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.sql.NativeSQLAccess;
import java.sql.Connection;
import java.sql.SQLException;

public class Database {
    String name = "";
    String abbr = "";
    public static final Database ORACLE = new Database("ORACLE", "Ora");
    public static final Database INFORMIX = new Database("INFORMIX", "Inf");
    public static final Database SAPDB = new Database("SAPDB", "Sap");
    public static final Database MSSQL = new Database("MSSQL", "Mss");
    public static final Database DB2 = new Database("DB2", "Db2");
    public static final Database DB4 = new Database("DB4", "Db4");
    public static final Database DB6 = new Database("DB6", "Db6");
    public static final Database ARTIFICIAL = new Database("ARTIFICIAL", "Art");
    private static final String[] dbs = new String[]{"ORACLE", "INFORMIX", "SAPDB", "MSSQL", "DB2", "DB4", "DB6"};

    private Database(String name, String abbr) {
        this.name = name;
        this.abbr = abbr;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbr;
    }

    public static Database getDatabase(Connection connection) throws SQLException {
        if (connection == null) {
            return ARTIFICIAL;
        }
        String DbProductName = NativeSQLAccess.getVendorName((Connection)connection);
        if (0 == DbProductName.compareToIgnoreCase("ORACLE")) {
            return ORACLE;
        }
        if (0 == DbProductName.compareToIgnoreCase("SAPDB")) {
            return SAPDB;
        }
        if (0 == DbProductName.compareToIgnoreCase("INFORMIX")) {
            return INFORMIX;
        }
        if (0 == DbProductName.compareToIgnoreCase("MS_SQL_SERVER")) {
            return MSSQL;
        }
        if (0 == DbProductName.compareToIgnoreCase("DB2_UDB")) {
            return DB6;
        }
        if (0 == DbProductName.compareToIgnoreCase("DB2_UDB_AS400")) {
            return DB4;
        }
        if (0 == DbProductName.compareToIgnoreCase("DB2_UDB_OS390")) {
            return DB2;
        }
        throw new SQLException();
    }

    public static Database getDatabase(String name) {
        if (0 == name.compareToIgnoreCase("ORACLE")) {
            return ORACLE;
        }
        if (0 == name.compareToIgnoreCase("SAPDB")) {
            return SAPDB;
        }
        if (0 == name.compareToIgnoreCase("INFORMIX")) {
            return INFORMIX;
        }
        if (0 == name.compareToIgnoreCase("MS_SQL_SERVER") || 0 == name.compareToIgnoreCase("MSSQL")) {
            return MSSQL;
        }
        if (0 == name.compareToIgnoreCase("DB2_UDB") || 0 == name.compareToIgnoreCase("DB6")) {
            return DB6;
        }
        if (0 == name.compareToIgnoreCase("DB2_UDB_AS400") || 0 == name.compareToIgnoreCase("DB4")) {
            return DB4;
        }
        if (0 == name.compareToIgnoreCase("DB2_UDB_OS390") || 0 == name.compareToIgnoreCase("DB2")) {
            return DB2;
        }
        return null;
    }

    public static String[] getDatabaseNames() {
        return dbs;
    }
}

