/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.ArchiveEntry;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ArchiveReader {
    String suffix = null;
    ZipFile file = null;
    ZipInputStream inputStream = null;
    Enumeration fileEntries = null;
    boolean entryStreamIsLocal = false;
    boolean entryToString = true;

    public ArchiveReader(String fileName, String suffix, boolean entryToString) throws IOException {
        this.entryStreamIsLocal = true;
        this.suffix = suffix;
        this.entryToString = entryToString;
        this.file = new ZipFile(fileName);
        this.fileEntries = this.file.entries();
    }

    public ArchiveReader(String fileStreamName, String suffix) throws IOException {
        this.entryStreamIsLocal = false;
        this.suffix = suffix;
        this.inputStream = new ZipInputStream(new FileInputStream(fileStreamName));
    }

    public ArchiveReader(ZipInputStream zipStream, String suffix) {
        this.entryStreamIsLocal = false;
        this.suffix = suffix;
        this.inputStream = zipStream;
    }

    public ArchiveEntry getNextEntry() throws IOException {
        ZipEntry entry;
        if (this.entryStreamIsLocal) {
            while (this.fileEntries.hasMoreElements()) {
                ZipEntry entry2 = (ZipEntry)this.fileEntries.nextElement();
                String ename = entry2.getName();
                if (!ename.endsWith(this.suffix)) continue;
                InputStream in = this.file.getInputStream(entry2);
                return new ArchiveEntry(ename, in, true, this.entryToString);
            }
            this.file.close();
            return null;
        }
        while ((entry = this.inputStream.getNextEntry()) != null) {
            String ename = entry.getName();
            if (!ename.endsWith(this.suffix)) continue;
            ArchiveEntry aentry = new ArchiveEntry(ename, this.inputStream, false, true);
            this.inputStream.closeEntry();
            return aentry;
        }
        this.inputStream.close();
        return null;
    }
}

