/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db6;

import com.sap.dictionary.database.db6.DbDb6Environment;
import com.sap.dictionary.database.db6.DbDb6Index;
import com.sap.dictionary.database.db6.DbDb6PartitioningKey;
import com.sap.dictionary.database.db6.DbDb6PrimaryKey;
import com.sap.dictionary.database.db6.DbDb6Tablespaces;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class DbDb6Table
extends DbTable {
    private static Location loc = Logger.getLocation("db6.DbDb6Table");
    DbDb6Tablespaces tableSpaces = null;
    DbDb6PartitioningKey partitioningKey = null;
    boolean isVolatile = false;

    public DbDb6Table() {
    }

    public DbDb6Table(DbFactory factory) {
        super(factory);
    }

    public DbDb6Table(DbFactory factory, String name) {
        super(factory, name);
    }

    public DbDb6Table(DbFactory factory, DbSchema schema, String name) {
        super(factory, schema, name);
    }

    public DbDb6Table(DbFactory factory, DbTable other) {
        super(factory, other);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
        XmlMap xmltableProperties;
        loc.entering("setSpecificContentViaXml");
        XmlMap xmltable = xmlMap.getXmlMap("table");
        String xmlName = xmltable.getString("name");
        if (!this.getName().equalsIgnoreCase(xmlName.trim())) {
            Object[] arguments = new Object[]{this.getName(), xmlName};
            loc.fatalT("setSpecificContentViaXml failed: table name {0} differs from XML table name {1} .", arguments);
            loc.exiting();
            throw new JddException(ExType.XML_ERROR, "table name " + this.getName() + " differs from XML table name " + xmlName);
        }
        XmlMap xmlPhysicalProperties = xmltable.getXmlMap("physical-properties");
        if (!xmlPhysicalProperties.isEmpty()) {
            this.tableSpaces = new DbDb6Tablespaces();
            this.tableSpaces.setTableSpaces(xmlPhysicalProperties.getString("data-tablespace"), xmlPhysicalProperties.getString("index-tablespace"), xmlPhysicalProperties.getString("long-tablespace"));
        }
        if (!(xmltableProperties = xmltable.getXmlMap("table-properties")).isEmpty()) {
            XmlMap xmlColumns;
            XmlMap xmlPartitioning = xmltableProperties.getXmlMap("partitioning-key");
            if (!xmlPartitioning.isEmpty() && !(xmlColumns = xmlPartitioning.getXmlMap("columns")).isEmpty()) {
                ArrayList<String> keyColumns = new ArrayList<String>();
                XmlMap xmlnextCol = xmlColumns.getXmlMap("column");
                int ii = 0;
                this.partitioningKey = new DbDb6PartitioningKey();
                while (!xmlnextCol.isEmpty()) {
                    keyColumns.add(xmlnextCol.getString("name"));
                    xmlnextCol = xmlColumns.getXmlMap("column" + ++ii);
                }
                this.partitioningKey.setPartitioningKey(keyColumns);
            }
            this.isVolatile = xmltableProperties.getBoolean("volatile");
        }
        loc.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        loc.entering("setSpecificContentViaDb");
        Connection con = this.getDbFactory().getConnection();
        boolean isPartitioned = false;
        try {
            String schemaName = "CURRENT SCHEMA";
            PreparedStatement tableSpaceStatement = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)("SELECT VOLATILE, PARTITION_MODE, TBSPACE, INDEX_TBSPACE, LONG_TBSPACE FROM SYSCAT.TABLES WHERE TABSCHEMA = " + schemaName + " AND TABNAME = ?"));
            tableSpaceStatement.setString(1, this.getName().toUpperCase());
            ResultSet rset = tableSpaceStatement.executeQuery();
            this.tableSpaces = new DbDb6Tablespaces();
            while (rset.next()) {
                this.isVolatile = rset.getString(1).equals("C");
                isPartitioned = rset.getString(2).equals("H");
                this.tableSpaces.setTableSpaces(rset.getString(3), rset.getString(4), rset.getString(5));
            }
            rset.close();
            if (isPartitioned) {
                ArrayList<String> partkeyCols = new ArrayList<String>();
                this.partitioningKey = new DbDb6PartitioningKey();
                PreparedStatement partitioningKeyStatement = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)("SELECT COLNAME FROM SYSCAT.COLUMNS WHERE TABSCHEMA = " + schemaName + " AND TABNAME = ? AND PARTKEYSEQ > 0 ORDER BY PARTKEYSEQ"));
                partitioningKeyStatement.setString(1, this.getName().toUpperCase());
                rset = partitioningKeyStatement.executeQuery();
                while (rset.next()) {
                    partkeyCols.add(rset.getString(1));
                }
                rset.close();
                this.partitioningKey.setPartitioningKey(partkeyCols);
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() throws JddException {
        loc.entering("getDdlStatementsForCreate");
        DbObjectSqlStatements tableDefStatements = new DbObjectSqlStatements(this.getName());
        DbSqlStatement createStatement = new DbSqlStatement();
        String tabName = this.getName();
        DbDb6Environment db6Env = (DbDb6Environment)this.getDbFactory().getEnvironment();
        try {
            createStatement.addLine("CREATE TABLE \"" + tabName.toUpperCase() + '\"');
            createStatement.merge(this.getColumns().getDdlClause());
            createStatement.addLine(" CCSID UNICODE ");
            if (this.tableSpaces != null) {
                if (this.tableSpaces.getDataTableSpace() != null) {
                    createStatement.addLine(" IN " + this.tableSpaces.getDataTableSpace());
                }
                if (this.tableSpaces.getIndexTableSpace() != null) {
                    createStatement.addLine(" INDEX IN " + this.tableSpaces.getIndexTableSpace());
                }
                if (this.tableSpaces.getLongTableSpace() != null) {
                    createStatement.addLine(" LONG IN " + this.tableSpaces.getLongTableSpace());
                }
            } else if (db6Env.getDefaultTablespaceClause() != null) {
                createStatement.addLine(db6Env.getDefaultTablespaceClause());
            }
            if (this.partitioningKey != null) {
                ArrayList partKeyCols = this.partitioningKey.getPartitioningKey();
                String partKeyClause = "( " + partKeyCols.get(0);
                int ii = 1;
                while (ii < partKeyCols.size()) {
                    partKeyClause = partKeyClause + ", " + partKeyCols.get(ii).toString();
                    ++ii;
                }
                partKeyClause = partKeyClause + " )";
                createStatement.addLine(" PARTITIONING KEY " + partKeyClause);
            }
            tableDefStatements.add(createStatement);
            createStatement.addLine(" VALUE COMPRESSION ");
            if (this.isVolatile) {
                DbSqlStatement volatileStatement = new DbSqlStatement();
                volatileStatement.addLine("ALTER TABLE \"" + tabName.toUpperCase() + '\"' + " VOLATILE");
                tableDefStatements.add(volatileStatement);
            }
            if (this.getPrimaryKey() != null) {
                tableDefStatements.merge(this.getPrimaryKey().getDdlStatementsForCreate());
            }
            if (this.getIndexes() != null) {
                tableDefStatements.merge(this.getIndexes().getDdlStatementsForCreate());
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.infoT("getDdlStatementsForCreate failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
        return tableDefStatements;
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) {
        file.println(offset0 + "<?xml version=\"1.0\"?>");
        file.println(offset0 + "<table name=" + "\"" + this.getName() + "\">");
        String offset1 = offset0 + XmlHelper.tabulate();
        String offset2 = offset1 + XmlHelper.tabulate();
        if (this.tableSpaces != null) {
            file.println(offset1 + "<physical-properties>");
            this.tableSpaces.writeContentToXmlFile(file, offset2);
            file.println(offset1 + "</physical-properties>");
        }
        if (this.partitioningKey != null || this.isVolatile) {
            file.println(offset1 + "<table-properties>");
            if (this.partitioningKey != null) {
                this.partitioningKey.writeContentToXmlFile(file, offset2);
            }
            if (this.isVolatile) {
                file.println(offset2 + "<volatile>true</volatile>");
            }
            file.println(offset1 + "</table-properties>");
        }
        file.println(offset0 + "</table>");
    }

    public void setPrimaryKeyViaDb() throws JddException {
        DbFactory factory = this.getDbFactory();
        DbDb6PrimaryKey primaryKey = new DbDb6PrimaryKey(factory, this.getName());
        primaryKey.setCommonContentViaDb();
        if (primaryKey.getColumnNames().isEmpty()) {
            super.setPrimaryKey(null);
        } else {
            super.setPrimaryKey(primaryKey);
        }
    }

    public void setIndexesViaDb() throws JddException {
        loc.entering("setIndexesViaDb");
        DbFactory factory = this.getDbFactory();
        Connection con = factory.getConnection();
        DbIndexes dbIndexes = new DbIndexes(factory);
        String schemaName = "CURRENT SCHEMA";
        try {
            PreparedStatement indexStatement = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)("SELECT INDNAME FROM SYSCAT.INDEXES  WHERE TABSCHEMA = " + schemaName + " AND TABNAME = ? AND UNIQUERULE <> 'P'"));
            indexStatement.setString(1, this.getName().toUpperCase());
            ResultSet rset = indexStatement.executeQuery();
            while (rset.next()) {
                DbDb6Index dbIndex = new DbDb6Index(factory, this.getSchema(), this.getName(), rset.getString(1));
                dbIndex.setCommonContentViaDb();
                dbIndexes.add(dbIndex);
            }
            rset.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setIndexesViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        super.setIndexes(dbIndexes);
        loc.exiting();
    }

    public boolean existsOnDb() {
        loc.entering("existsOnDb");
        boolean exists = false;
        Connection con = this.getDbFactory().getConnection();
        try {
            PreparedStatement existsStatement = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)"SELECT 1 FROM SYSCAT.TABLES WHERE TABSCHEMA = CURRENT SCHEMA AND TABNAME = ? AND TYPE ='T' ");
            existsStatement.setString(1, this.getName().toUpperCase());
            ResultSet rs = existsStatement.executeQuery();
            exists = rs.next();
            rs.close();
            existsStatement.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("existence check for table {0} failed: {1}", arguments);
            loc.exiting();
        }
        Object[] arguments = new Object[]{this.getName(), exists ? "exits" : "doesn't exist"};
        loc.infoT("table {0} {1} on database", arguments);
        loc.exiting();
        return exists;
    }

    public boolean existsData() {
        loc.entering("existsData");
        boolean exists = false;
        Connection con = this.getDbFactory().getConnection();
        String tabName = this.getName();
        try {
            Statement dstmt = NativeSQLAccess.createNativeStatement((Connection)con);
            ResultSet drs = dstmt.executeQuery("SELECT 1 FROM \"" + tabName.toUpperCase() + '\"' + " FETCH FIRST 1 ROWS ONLY OPTIMIZE FOR 1 ROWS");
            exists = drs.next();
            drs.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.fatalT("existsData failed for table {0} : {1}", arguments);
        }
        Object[] arguments = new Object[]{this.getName(), exists ? "" : "no"};
        loc.infoT("table {0} contains {1} data", arguments);
        loc.exiting();
        return exists;
    }

    public boolean checkNameLength() {
        int nameLen = this.getName().length();
        boolean check = nameLen > 0 && nameLen <= 128;
        loc.entering("checkNameLength");
        if (!check) {
            loc.errorT("checkNameLength: index name length must range from 0 to 128 .");
        }
        loc.exiting();
        return check;
    }

    public boolean checkNameForReservedWord() {
        boolean isReserved = DbDb6Environment.isReservedWord(this.getName());
        return !isReserved;
    }

    public boolean checkWidth() {
        loc.entering("checkWidth");
        DbColumns columns = this.getColumns();
        DbColumnIterator iter = columns.iterator();
        boolean check = true;
        int total = 0;
        int colCnt = 0;
        int varCnt = 0;
        while (iter.hasNext()) {
            DbColumn column = iter.next();
            ++colCnt;
            switch (column.getJavaSqlType()) {
                case 2004: 
                case 2005: {
                    long length = column.getLength();
                    if (column.getJavaSqlType() == 2005) {
                        length *= 3L;
                    }
                    if (length >= 1070000000L) {
                        total += 278;
                        break;
                    }
                    if (length >= 536000000L) {
                        total += 254;
                        break;
                    }
                    if (length >= 134000000L) {
                        total += 222;
                        break;
                    }
                    if (length >= 4190000L) {
                        total += 198;
                        break;
                    }
                    if (length >= 524000L) {
                        total += 166;
                        break;
                    }
                    if (length >= 65536L) {
                        total += 142;
                        break;
                    }
                    if (length >= 8192L) {
                        total += 118;
                        break;
                    }
                    if (length >= 1024L) {
                        total += 94;
                        break;
                    }
                    total += 70;
                    break;
                }
                case -5: {
                    total += 10;
                    break;
                }
                case -2: {
                    total = (int)((long)total + (column.getLength() + 2L));
                    break;
                }
                case -4: 
                case -3: {
                    total = (int)((long)total + (column.getLength() + 2L));
                    ++varCnt;
                    break;
                }
                case 1: {
                    total = (int)((long)total + (column.getLength() * 3L + 2L));
                    break;
                }
                case -1: 
                case 12: {
                    total = (int)((long)total + (column.getLength() * 3L + 2L));
                    ++varCnt;
                    break;
                }
                case 91: {
                    total += 6;
                    break;
                }
                case 92: {
                    total += 5;
                    break;
                }
                case 93: {
                    total += 12;
                    break;
                }
                case 2: 
                case 3: {
                    total = (int)((long)total + (column.getLength() / 2L + 3L));
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    total += 10;
                    break;
                }
                case 4: {
                    total += 6;
                    break;
                }
                case -6: 
                case 5: {
                    total += 4;
                }
            }
        }
        if ((total += 2) > 16293) {
            check = false;
            Object[] arguments = new Object[]{this.getName(), new Integer(total)};
            loc.errorT("checkWidth {0}: total width of table ({1}) including row overhead is greater than the allowed maximum for 16K tablespaces .", arguments);
        }
        loc.exiting();
        return check;
    }

    public String toString() {
        String superString = super.toString();
        String volatileString = "Volatile              : " + this.isVolatile;
        String tbsString = "";
        String partString = "";
        if (this.tableSpaces != null) {
            tbsString = this.tableSpaces.toString();
        }
        if (this.partitioningKey != null) {
            partString = this.partitioningKey.toString();
        }
        return superString + volatileString + "\n" + tbsString + "\n" + partString;
    }
}

