/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.db4.DbDb4Column;
import com.sap.dictionary.database.db4.DbDb4Columns;
import com.sap.dictionary.database.db4.DbDb4Environment;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbIndexDifference;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbDb4Index
extends DbIndex {
    private static Location loc = Logger.getLocation("db4.DbDb4Index");
    private static Category cat = Logger.getCategory();

    public DbDb4Index() {
    }

    public DbDb4Index(DbFactory factory) {
        super(factory);
    }

    public DbDb4Index(DbFactory factory, DbIndex other) {
        super(factory, other);
    }

    public DbDb4Index(DbFactory factory, String tableName, String name) {
        super(factory, tableName, name);
    }

    public DbDb4Index(DbFactory factory, DbSchema schema, String tabname, String name) {
        super(factory, schema, tabname, name);
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) {
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) {
        this.setDbSpecificIsSet(true);
        loc.debugT(cat, "setSpecificContentViaXml(XmlMap) entered.");
    }

    /*
     * Loose catch block
     */
    public void setCommonContentViaDb() throws JddException {
        block13: {
            String stmtStr;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                loc.entering(cat, "setCommonContentViaDb()");
                boolean isUnique = false;
                boolean isDescending = false;
                ArrayList<DbIndexColumnInfo> columnsInfo = new ArrayList<DbIndexColumnInfo>();
                Connection con = null;
                pstmt = null;
                rs = null;
                String indexName = null;
                stmtStr = "SELECT T1.IS_UNIQUE, T2.ORDERING, T2.COLUMN_NAME, T2.ORDINAL_POSITION FROM SYSKEYS AS T2 JOIN SYSINDEXES AS T1 ON T2.INDEX_NAME = T1.INDEX_NAME WHERE T1.INDEX_NAME = ? ORDER BY ORDINAL_POSITION";
                indexName = this.getName();
                if (indexName == null) {
                    loc.errorT(cat, "Empty index name.");
                    loc.exiting();
                    throw new JddException(ExType.OTHER, "Empty index name.");
                }
                indexName = indexName.trim().toUpperCase();
                if (this.getDbFactory() == null || (con = this.getDbFactory().getConnection()) == null) {
                    loc.errorT(cat, "No connection.");
                    loc.exiting();
                    throw new JddException(ExType.OTHER, "No connection.");
                }
                boolean noRow = true;
                pstmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtStr);
                pstmt.setString(1, indexName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (noRow) {
                        isUnique = rs.getString(1).trim().equalsIgnoreCase("U");
                        noRow = false;
                    }
                    isDescending = rs.getString(2).trim().equalsIgnoreCase("D");
                    columnsInfo.add(new DbIndexColumnInfo(rs.getString(3).trim().toUpperCase(), isDescending));
                }
                if (noRow) {
                    loc.warningT(cat, "Index {0} does not exist on database.", new Object[]{indexName});
                    this.setContent(false, null);
                    break block12;
                }
                this.setContent(isUnique, columnsInfo);
            }
            Object var11_11 = null;
            try {
                rs.close();
                pstmt.close();
                break block13;
            }
            catch (Exception e) {
                loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e.getMessage()});
            }
            {
                break block13;
                catch (SQLException sqlEx) {
                    loc.errorT(cat, "SQLException caught executing {0}\n: {1}", new Object[]{stmtStr, sqlEx.getMessage()});
                    loc.exiting();
                    throw JddException.createInstance(sqlEx);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e) {
                    loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e.getMessage()});
                }
                loc.exiting();
                throw throwable;
            }
        }
        loc.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        this.setDbSpecificIsSet(true);
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        loc.entering(cat, "getDdlStatementsForCreate()");
        String tableName = null;
        String indexName = null;
        tableName = this.getTableName();
        if (tableName == null) {
            loc.errorT(cat, "Empty table name.");
            loc.exiting();
            return null;
        }
        tableName = tableName.trim().toUpperCase();
        indexName = this.getName();
        if (indexName == null) {
            loc.errorT(cat, "Empty index name.");
            loc.exiting();
            return null;
        }
        indexName = indexName.trim().toUpperCase();
        DbObjectSqlStatements indexDef = new DbObjectSqlStatements(indexName);
        DbSqlStatement createStatement = new DbSqlStatement();
        String unique = this.isUnique() ? "UNIQUE " : "";
        createStatement.addLine("CREATE " + unique + "INDEX " + "\"" + indexName + "\"" + " ON " + "\"" + tableName + "\"" + " ");
        if (this.getDdlColumnsClause() == null) {
            loc.errorT(cat, "Missing field list.");
            loc.exiting();
            return null;
        }
        createStatement.merge(this.getDdlColumnsClause());
        indexDef.add(createStatement);
        loc.debugT(cat, "Generated: {0}", new Object[]{createStatement.toString()});
        loc.exiting();
        return indexDef;
    }

    public DbSqlStatement getDdlColumnsClause() {
        loc.entering(cat, "getDdlColumnsClause()");
        String line = "";
        String descClause = "";
        boolean noColumns = true;
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        DbSqlStatement colDef = new DbSqlStatement();
        colDef.addLine("(");
        while (iter.hasNext()) {
            noColumns = false;
            DbIndexColumnInfo dbIndexColumnInfo = (DbIndexColumnInfo)iter.next();
            descClause = dbIndexColumnInfo.isDescending() ? "DESC " : "ASC ";
            line = dbIndexColumnInfo.getName().trim().toUpperCase() + " " + descClause;
            if (iter.hasNext()) {
                line = line + ", ";
            }
            colDef.addLine(line);
        }
        while (iter.hasNext()) {
        }
        colDef.addLine(")");
        if (noColumns) {
            loc.errorT(cat, "Missing field list.");
            loc.exiting();
            return null;
        }
        loc.exiting();
        return colDef;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        loc.entering(cat, "getDdlStatementsForDrop()");
        String indexName = null;
        indexName = this.getName();
        if (indexName == null) {
            loc.errorT(cat, "Empty index name.");
            loc.exiting();
            return null;
        }
        indexName = indexName.trim().toUpperCase();
        DbObjectSqlStatements indexDef = new DbObjectSqlStatements(indexName);
        DbSqlStatement dropStatement = new DbSqlStatement(true);
        dropStatement.addLine("DROP INDEX \"" + indexName + "\"");
        indexDef.add(dropStatement);
        loc.debugT(cat, "Generated: {0}.", new Object[]{dropStatement.toString()});
        loc.exiting();
        return indexDef;
    }

    public DbIndexDifference compareTo(DbIndex target) throws JddException {
        loc.entering(cat, "compareTo(DbIndex)");
        DbIndexDifference indexDiff = super.compareTo(target);
        loc.exiting();
        return indexDiff;
    }

    public boolean checkWidth() {
        loc.entering(cat, "checkWidth()");
        boolean widthOk = true;
        int indexWidth = 0;
        int numberOfColumns = 0;
        boolean sqlType = false;
        boolean length = false;
        int multiplier = 1;
        DbIndexColumnInfo info = null;
        DbDb4Column col = null;
        ArrayList indexColumnNames = this.getColumnNames();
        DbDb4Columns tableColumns = (DbDb4Columns)this.getIndexes().getTable().getColumns();
        int i = 0;
        while (i < indexColumnNames.size()) {
            info = (DbIndexColumnInfo)indexColumnNames.get(i);
            col = (DbDb4Column)tableColumns.getColumn(info.getName().trim().toUpperCase());
            ++numberOfColumns;
            multiplier = 1;
            switch (col.getJavaSqlType()) {
                case -1: 
                case 12: {
                    multiplier = 2;
                }
                case -4: 
                case -3: {
                    indexWidth = (int)((long)indexWidth + ((long)multiplier * col.getLengthOrDdlDefaultLength() + 2L));
                    break;
                }
                case -2: {
                    indexWidth = (int)((long)indexWidth + (long)multiplier * col.getLengthOrDdlDefaultLength());
                    break;
                }
                case 5: {
                    indexWidth += 2;
                    break;
                }
                case 4: {
                    indexWidth += 4;
                    break;
                }
                case -5: {
                    indexWidth += 8;
                    break;
                }
                case 7: {
                    indexWidth += 4;
                    break;
                }
                case 8: {
                    indexWidth += 8;
                    break;
                }
                case 91: {
                    indexWidth += 10;
                    break;
                }
                case 92: {
                    indexWidth += 8;
                    break;
                }
                case 93: {
                    indexWidth += 26;
                    break;
                }
                case 3: {
                    indexWidth = (int)((long)indexWidth + (col.getLengthOrDdlDefaultLength() / 2L + 1L));
                    break;
                }
                default: {
                    loc.errorT(cat, "Invalid type {0}.", new Object[]{new Integer(col.getJavaSqlType())});
                    widthOk = false;
                }
            }
            ++i;
        }
        indexWidth += (numberOfColumns + 7) / 8 * 8;
        if ((indexWidth += 64) > DbDb4Environment.getMaxIndexWidthBytes()) {
            widthOk = false;
        }
        DbDb4Environment.traceCheckResult(true, widthOk, cat, loc, "Width of index {0}: {1} ({2}) - returns {3}.", new Object[]{this.getName(), new Integer(indexWidth), new Integer(DbDb4Environment.getMaxIndexWidthBytes()), new Boolean(widthOk)});
        loc.exiting();
        return widthOk;
    }

    public boolean checkNameLength() {
        boolean isOk = this.getName().trim().length() <= DbDb4Environment.getMaxIndexNameLength();
        DbDb4Environment.traceCheckResult(true, isOk, cat, loc, "checkNameLength() returns {0}.", new Object[]{new Boolean(isOk)});
        return isOk;
    }

    public boolean checkNumberOfColumns() {
        boolean isOk = this.getColumnNames().size() <= DbDb4Environment.getMaxColumnsPerIndex();
        DbDb4Environment.traceCheckResult(true, isOk, cat, loc, "checkNumberOfColumns() returns {0}.", new Object[]{new Boolean(isOk)});
        return isOk;
    }

    public boolean checkNameForReservedWord() {
        boolean isReserved = !DbDb4Environment.isReservedWord(this.getName());
        DbDb4Environment.traceCheckResult(true, isReserved, cat, loc, "checkNameForReservedWord() returns {0}.", new Object[]{new Boolean(isReserved)});
        return isReserved;
    }
}

