/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.db4.DbDb4Environment;
import com.sap.dictionary.database.db4.DbDb4HexString;
import com.sap.dictionary.database.db4.JavaDb4SqlTypeInfo;
import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbDeploymentInfo;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.text.SimpleDateFormat;

public class DbDb4Column
extends DbColumn {
    private static Location loc = Logger.getLocation("db4.DbDb4Column");
    private static Category cat = Logger.getCategory();

    public DbDb4Column() {
    }

    public DbDb4Column(DbFactory factory) {
        super(factory);
    }

    public DbDb4Column(DbFactory factory, DbColumn other) {
        super(factory, other);
    }

    public DbDb4Column(DbFactory factory, XmlMap xmlMap) {
        super(factory, xmlMap);
    }

    public DbDb4Column(DbFactory factory, String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) {
        super(factory, name, position, javaSqlType, dbType, length, decimals, isNotNull, defaultValue);
    }

    public String getDdlDefaultValueClause() throws Exception {
        String orgDefaultValue;
        loc.entering(cat, "getDdlDefaultValueClause()");
        String clause = "";
        String trgDefaultValue = orgDefaultValue = this.getDefaultValue();
        JavaDb4SqlTypeInfo javaSqlTypeInfo = (JavaDb4SqlTypeInfo)this.getJavaSqlTypeInfo();
        if (javaSqlTypeInfo.hasDefaultValue() && orgDefaultValue != null) {
            if (this.getJavaSqlType() == 92 || this.getJavaSqlType() == 93 || this.getJavaSqlType() == 91) {
                SimpleDateFormat orgFormatter = (SimpleDateFormat)javaSqlTypeInfo.getFormatterForDefaultString();
                SimpleDateFormat trgFormatter = (SimpleDateFormat)javaSqlTypeInfo.getTargetFormatterForDefaultString();
                try {
                    trgDefaultValue = trgFormatter.format(orgFormatter.parse(trgDefaultValue));
                    loc.infoT(cat, "Default value ''{0}'' reformatted to ''{1}''.", new Object[]{orgDefaultValue, trgDefaultValue});
                }
                catch (Exception e) {
                    loc.errorT(cat, "Exception caught reformatting default value from ''{0}'' to ''{1}'': ''{2}''.", new Object[]{orgDefaultValue, trgDefaultValue, e.toString()});
                    loc.exiting();
                    throw JddException.createInstance(e);
                }
            }
            if (this.getJavaSqlType() == 12 || this.getJavaSqlType() == -1 || this.getJavaSqlType() == 2005) {
                trgDefaultValue = "UX'" + new DbDb4HexString(trgDefaultValue, null).getHexString() + "'";
                loc.debugT(cat, "Default value ''{0}'' reformatted to ''{1}''.", new Object[]{orgDefaultValue, trgDefaultValue});
            }
            clause = "DEFAULT " + javaSqlTypeInfo.getDefaultValuePrefix() + trgDefaultValue + javaSqlTypeInfo.getDefaultValueSuffix();
        }
        loc.exiting();
        return clause;
    }

    public String getDdlClause() throws Exception {
        loc.entering(cat, "getDdlClause()");
        String columnName = null;
        columnName = this.getName();
        if (columnName == null) {
            loc.errorT(cat, "Empty column name.");
            loc.exiting();
            throw new JddException(ExType.OTHER, "Empty column name.");
        }
        columnName = columnName.trim().toUpperCase();
        String clause = "\"" + columnName + "\"" + " " + this.getDdlTypeClause() + " " + this.getDdlDefaultValueClause() + " ";
        if (this.isNotNull()) {
            clause = clause + "NOT NULL";
        }
        return clause;
    }

    public DbColumnDifference compareTo(DbColumn target) throws Exception {
        boolean trgHasDef;
        loc.entering(cat, "compareTo({0}) called.", new Object[]{target.getName()});
        DbDb4Column origin = this;
        DbColumnDifferencePlan plan = new DbColumnDifferencePlan();
        int action = 0;
        int originalType = origin.getJavaSqlType();
        int targetType = target.getJavaSqlType();
        if (originalType != targetType && (originalType != -1 && originalType != 12 || targetType != -1 && targetType != 12) && (originalType != -4 && originalType != -3 || targetType != -4 && targetType != -3)) {
            if (originalType == 5 && (targetType == 4 || targetType == -5) || originalType == 4 && targetType == -5 || originalType == 7 && targetType == 8) {
                action = this.raiseActionLevel(action, 1);
                plan.setTypeIsChanged(true);
            } else {
                action = this.raiseActionLevel(action, 2);
                plan.setTypeIsChanged(true);
                loc.infoT(cat, "Column {0}: incompatible type change requires conversion: Source JDBC type {1}, target JDBC type {2}.", new Object[]{this.getName(), new Integer(originalType), new Integer(targetType)});
            }
        } else {
            plan.setTypeIsChanged(false);
        }
        String orgDefault = origin.getDefaultValue();
        String trgDefault = target.getDefaultValue();
        boolean orgHasDef = origin.getJavaSqlTypeInfo().hasDefaultValue() && orgDefault != null;
        boolean bl = trgHasDef = target.getJavaSqlTypeInfo().hasDefaultValue() && trgDefault != null;
        if (!orgHasDef && !trgHasDef || orgHasDef && trgHasDef && orgDefault.equals(trgDefault)) {
            plan.setDefaultValueIsChanged(false);
        } else {
            plan.setDefaultValueIsChanged(true);
            if (!orgHasDef && trgHasDef || orgHasDef && trgHasDef && !orgDefault.equals(trgDefault)) {
                action = this.raiseActionLevel(action, 1);
            } else {
                action = this.raiseActionLevel(action, 2);
                loc.infoT(cat, "Column {0}: default value change that requires conversion: Source def.: ''{1}'' (hasDefaultValue {2}), target def.: ''{3}'' (hasDefaultValue {4}), ", new Object[]{this.getName(), orgDefault, new Boolean(orgHasDef), trgDefault, new Boolean(trgHasDef)});
            }
        }
        long orgLength = origin.getLengthOrDdlDefaultLength();
        long trgLength = ((DbDb4Column)target).getLengthOrDdlDefaultLength();
        if (orgLength == trgLength) {
            plan.setLengthIsChanged(false);
        } else {
            plan.setLengthIsChanged(true);
            if (originalType == targetType && orgLength < trgLength && (targetType == 12 || targetType == -1 || targetType == -3 || targetType == -4 || targetType == 2005 || targetType == 2004 || targetType == 3)) {
                action = this.raiseActionLevel(action, 1);
            } else {
                action = this.raiseActionLevel(action, 2);
                loc.infoT(cat, "Column {0}: target column shorter than source column, conversion required. Source length: {1}, target length: {2}", new Object[]{this.getName(), new Long(orgLength), new Long(trgLength)});
            }
        }
        int orgDec = origin.getDecimals();
        int trgDec = target.getDecimals();
        if (orgDec != trgDec) {
            plan.setDecimalsAreChanged(true);
            long orgLen = origin.getLengthOrDdlDefaultLength();
            long trgLen = ((DbDb4Column)target).getLengthOrDdlDefaultLength();
            if (orgDec < trgDec && (long)trgDec <= trgLen && orgLen - (long)orgDec <= trgLen - (long)trgDec) {
                action = this.raiseActionLevel(action, 1);
            } else {
                action = this.raiseActionLevel(action, 2);
                loc.infoT(cat, "Column {0}: length/decimal change leading to data loss requires conversion. Source: DECIMAL ({1},{2}), target: DECIMAL ({3},{4}).", new Object[]{this.getName(), new Long(orgLen), new Long(orgDec), new Long(trgLen), new Long(trgDec)});
            }
        } else {
            plan.setDecimalsAreChanged(false);
        }
        if (origin.isNotNull() ^ target.isNotNull()) {
            plan.setNullabilityIsChanged(true);
            if (origin.isNotNull() && !target.isNotNull()) {
                action = this.raiseActionLevel(action, 1);
            } else {
                action = this.raiseActionLevel(action, 2);
                loc.infoT(cat, "Column {0}: change from ''NULL allowed'' to ''NOT NULL'' requires conversion.", new Object[]{this.getName()});
            }
        } else {
            plan.setNullabilityIsChanged(false);
        }
        if (origin.getPosition() != target.getPosition()) {
            plan.setPositionIsChanged(true);
            DbDeploymentInfo info = target.getColumns().getTable().getDeploymentInfo();
            if (info == null || info.positionIsRelevant()) {
                action = this.raiseActionLevel(action, 2);
                loc.infoT(cat, "Column {0}: column position changed, while position is relevant; requires conversion. Source pos.: {1}, target pos.: {2}. DeploymentInfo: {3}", new Object[]{this.getName(), new Integer(origin.getPosition()), new Integer(target.getPosition()), info});
            }
        } else {
            plan.setPositionIsChanged(false);
        }
        String actionDescr = "";
        switch (action) {
            case 0: {
                actionDescr = "NOTHING";
                loc.debugT(cat, "{0} and {1} are the same. - Return null.", new Object[]{this.getName(), target.getName()});
                loc.exiting();
                return null;
            }
            case 1: {
                actionDescr = "ALTER";
                loc.infoT(cat, "Column {0} changed:\nactionDescr = {1}, \nsource: {2}, \ntarget: {3}, \nplan: {4}", new Object[]{this.getName(), actionDescr, this, target, plan});
                break;
            }
            case 2: {
                actionDescr = "CONVERT";
                loc.infoT(cat, "Column {0} changed:\nactionDescr = {1}, \nsource: {2}, \ntarget: {3}, \nplan: {4}", new Object[]{this.getName(), actionDescr, this, target, plan});
                break;
            }
            default: {
                loc.warningT("Unknown action: {0}", new Object[]{new Integer(action)});
            }
        }
        DbColumnDifference diff = new DbColumnDifference(origin, target, plan, Action.getInstance(actionDescr));
        loc.exiting();
        return diff;
    }

    public boolean acceptedAdd() {
        boolean addOk = true;
        DbDb4Environment.traceCheckResult(true, addOk, cat, loc, "acceptedAdd() returns {0}.", new Object[]{new Boolean(addOk)});
        return addOk;
    }

    public boolean acceptedDrop() {
        boolean dropOk = true;
        DbDb4Environment.traceCheckResult(true, dropOk, cat, loc, "acceptedDrop() returns {0}.", new Object[]{new Boolean(dropOk)});
        return dropOk;
    }

    public boolean checkNameLength() {
        boolean lengthOk = false;
        lengthOk = this.getName().trim().length() <= DbDb4Environment.getMaxColumnNameLength();
        DbDb4Environment.traceCheckResult(true, lengthOk, cat, loc, "checkNameLength() returns {0}.", new Object[]{new Boolean(lengthOk)});
        return lengthOk;
    }

    public boolean checkTypeAttributes() {
        loc.entering(cat, "checkTypeAttributes()");
        boolean attributesOk = true;
        long length = this.getLength();
        int decimals = this.getDecimals();
        switch (this.getJavaSqlType()) {
            case -1: 
            case 12: {
                if (length >= 0L && length <= DbDb4Environment.getMaxVarcharLengthBytes() / 2L) break;
                attributesOk = false;
                break;
            }
            case -4: 
            case -3: {
                if (length >= 0L && length <= DbDb4Environment.getMaxVarbinaryLength()) break;
                attributesOk = false;
                break;
            }
            case -2: {
                if (length >= 0L && length <= DbDb4Environment.getMaxBinaryLength()) break;
                attributesOk = false;
                break;
            }
            case 2005: {
                if (length >= 0L && length <= DbDb4Environment.getMaxClobLengthBytes() / 2L) break;
                attributesOk = false;
                break;
            }
            case 2004: {
                if (length >= 0L && length <= DbDb4Environment.getMaxBlobLength()) break;
                attributesOk = false;
                break;
            }
            case -5: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            case 3: {
                decimals = this.getDecimals();
                if (length >= 1L && length <= DbDb4Environment.getMaxDecimalLengthChars() && decimals >= 0 && (long)decimals <= DbDb4Environment.getMaxDecimalLengthChars() - 1L) break;
                attributesOk = false;
                break;
            }
            default: {
                loc.errorT(cat, "Unknown SQL type {0}.", new Object[]{new Integer(this.getJavaSqlType())});
                attributesOk = false;
            }
        }
        DbDb4Environment.traceCheckResult(true, attributesOk, cat, loc, "checkAttributes returns {0} for SQL type {1}.", new Object[]{new Boolean(attributesOk), new Integer(this.getJavaSqlType())});
        loc.exiting();
        return attributesOk;
    }

    public boolean checkNameForReservedWord() {
        boolean isReserved = !DbDb4Environment.isReservedWord(this.getName());
        DbDb4Environment.traceCheckResult(true, isReserved, cat, loc, "checkNameForReservedWord() returns {0}.", new Object[]{new Boolean(isReserved)});
        return isReserved;
    }

    public long getLengthOrDdlDefaultLength() {
        long length = 0L;
        if (this.getJavaSqlTypeInfo().hasLengthAttribute() && (length = this.getLength()) == 0L) {
            length = this.getJavaSqlTypeInfo().getDdlDefaultLength();
        }
        loc.debugT(cat, "getLengthOrDefaultLength() returns {0}.", new Object[]{new Long(length)});
        return length;
    }

    private int raiseActionLevel(int currentAction, int givenAction) {
        loc.debugT(cat, "raiseActionLevel({0}, {1}) called.", new Object[]{new Integer(currentAction), new Integer(givenAction)});
        int newAction = currentAction < givenAction ? givenAction : currentAction;
        return newAction;
    }
}

