/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbIndexIterator;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.JavaSqlTypeInfo;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.tc.logging.Location;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbDb2Column
extends DbColumn {
    String lobTableName = null;
    private Integer excLength = null;
    private static Location loc = Logger.getLocation("db2.DbDb2Column");

    public DbDb2Column(DbFactory factory) {
        super(factory);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2Column(DbFactory factory, DbColumn other) {
        super(factory, other);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2Column(DbFactory factory, XmlMap xmlMap) {
        super(factory, xmlMap);
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2Column(DbFactory factory, String name, int position, int javaSqlType, String dbType, long length, int decimals, boolean isNotNull, String defaultValue) {
        DbDb2Parameters.setValues(factory.getConnection());
        this.constructorPart(factory, name, position, javaSqlType, dbType, length, decimals, isNotNull, defaultValue);
    }

    public String getTypeClauseForDdl() throws Exception {
        return super.getDdlTypeClause();
    }

    public DbColumnDifference compareTo(DbColumn target) throws JddException {
        loc.entering("compareTo");
        try {
            String targetDefault;
            boolean nullabilityIsChanged;
            Object colDiff = null;
            DbDb2Column targetCol = null;
            DbColumnDifferencePlan plan = new DbColumnDifferencePlan();
            targetCol = (DbDb2Column)target;
            if (DbDb2Parameters.isV8()) {
                if (this.typeChanged(target)) {
                    plan.setTypeIsChanged(true);
                    if (!this.canChangeType(target)) {
                        Object[] arguments = new Object[]{this.getName(), this.getJavaSqlTypeName(), target.getJavaSqlTypeName()};
                        loc.infoT("compareTo ({0}): conversion necessary: original type {1} incompatible to target type {2}", arguments);
                        loc.exiting();
                        return new DbColumnDifference(this, target, plan, Action.CONVERT);
                    }
                    plan.setTypeIsChanged(true);
                }
                if (this.lengthChanged(target)) {
                    if (!this.canChangeType(target)) {
                        Object[] arguments = new Object[]{this.getName(), this.getJavaSqlTypeName(), new Long(this.getLength()), new Long(targetCol.getLength())};
                        loc.infoT("compareTo ({0}): conversion necessary for type {1}: original length {2} differs from target length {3}}", arguments);
                        loc.exiting();
                        return new DbColumnDifference(this, target, plan, Action.CONVERT);
                    }
                    plan.setLengthIsChanged(true);
                }
                if (this.scaleChanged(target)) {
                    if (!this.canChangeType(target)) {
                        Object[] arguments = new Object[]{this.getName(), this.getJavaSqlTypeName(), new Long(this.getDecimals()), new Long(targetCol.getDecimals())};
                        loc.infoT("compareTo ({0}): conversion necessary for type {1}: original precision {2} differs from target precision {3}}", arguments);
                        loc.exiting();
                        return new DbColumnDifference(this, target, plan, Action.CONVERT);
                    }
                    plan.setDecimalsAreChanged(true);
                }
            } else {
                int st = this.getJavaSqlType();
                int tt = targetCol.getJavaSqlType();
                if (st == 3 && tt == -5 && this.getLength() == (long)DbDb2Parameters.BigIntLength && this.getDecimals() == 0 && this.isNotNull() == targetCol.isNotNull() && this.compareDefault(targetCol)) {
                    loc.exiting();
                    return null;
                }
                if (st == 2005 && tt == 12 && targetCol.getLength() > (long)DbDb2Parameters.maxLongChar) {
                    loc.exiting();
                    return null;
                }
                if (!(st == tt || st == -3 && tt == -4 || st == 12 && tt == 1 || st == 12 && tt == -1 || st == 8 && tt == 6 || st == 3 && tt == 2)) {
                    plan.setTypeIsChanged(true);
                    Object[] arguments = new Object[]{this.getName(), this.getJavaSqlTypeName(), target.getJavaSqlTypeName()};
                    loc.infoT("compareTo ({0}): conversion necessary: original type {1} incompatible to target type {2}", arguments);
                    loc.exiting();
                    return new DbColumnDifference(this, target, plan, Action.CONVERT);
                }
                if (!(!this.getJavaSqlTypeInfo().hasLengthAttribute() || this.getLength() == targetCol.getLength() || DbDb2Parameters.isV7() && this.getExcLength() != null && this.getLength() == (long)this.getExcLength().intValue() || DbDb2Parameters.isV7() && this.getLength() == (long)DbDb2Parameters.maxCharLengthV7 && targetCol.getLength() > (long)DbDb2Parameters.maxCharLengthV7 && targetCol.getLength() < (long)DbDb2Parameters.longCharLengthV7)) {
                    plan.setLengthIsChanged(true);
                    if (!DbDb2Parameters.isV8() && (this.getLength() > targetCol.getLength() || this.getJavaSqlType() != -3 && this.getJavaSqlType() != -4) || DbDb2Parameters.isV8() && (this.getLength() > targetCol.getLength() || this.getJavaSqlType() != -3 && this.getJavaSqlType() != -4 && this.getJavaSqlType() != 1 && this.getJavaSqlType() != 12 && this.getJavaSqlType() != -1)) {
                        Object[] arguments = new Object[]{this.getName(), this.getJavaSqlTypeName(), new Long(this.getLength()), new Long(targetCol.getLength())};
                        loc.infoT("compareTo ({0}): conversion necessary for type {1}: original length {2} differs from target length {3}}", arguments);
                        loc.exiting();
                        return new DbColumnDifference(this, target, plan, Action.CONVERT);
                    }
                }
                if (this.getJavaSqlTypeInfo().hasDecimals() && this.getDecimals() != targetCol.getDecimals()) {
                    plan.setDecimalsAreChanged(true);
                    Object[] arguments = new Object[]{this.getName(), this.getJavaSqlTypeName(), new Long(this.getDecimals()), new Long(targetCol.getDecimals())};
                    loc.infoT("compareTo ({0}): conversion necessary for type {1}: original precision {2} differs from target precision {3}}", arguments);
                    loc.exiting();
                    return new DbColumnDifference(this, target, plan, Action.CONVERT);
                }
            }
            if (this.isNotNull() != targetCol.isNotNull() && (nullabilityIsChanged = true)) {
                plan.setNullabilityIsChanged(true);
                Object[] arguments = new Object[]{this.getName()};
                loc.infoT("compareTo ({0}): conversion necessary: nullability changed", arguments);
                loc.exiting();
                return new DbColumnDifference(this, target, plan, Action.CONVERT);
            }
            if (!(this.compareDefault(targetCol) || (targetDefault = targetCol.getDefaultValue()) == null && this.getJavaSqlTypeInfo().getDefaultDefault() != null && 0 == this.getDefaultValue().compareTo(this.getJavaSqlTypeInfo().getDefaultDefault()))) {
                JavaSqlTypeInfo javaSqlTypeInfo = this.getJavaSqlTypeInfo();
                boolean defaultValueIsChanged = false;
                switch (javaSqlTypeInfo.getIntCode()) {
                    case -1: 
                    case 1: 
                    case 12: {
                        if (DbDb2Parameters.isV8() && !DbDb2Environment.checkV8CharDefault(this.getColumns().getTable().getDbFactory().getConnection())) {
                            defaultValueIsChanged = false;
                            break;
                        }
                        defaultValueIsChanged = true;
                        break;
                    }
                    case 92: {
                        Object obj;
                        Format dateFormatter = javaSqlTypeInfo.getFormatterForDefaultString();
                        if (targetDefault != null) {
                            obj = dateFormatter.parseObject(targetDefault);
                            SimpleDateFormat db2DateFormatter = new SimpleDateFormat("HH.mm.ss");
                            String defVal = db2DateFormatter.format(obj);
                            if (0 == this.getDefaultValue().compareTo(defVal)) break;
                            defaultValueIsChanged = true;
                            break;
                        }
                        defaultValueIsChanged = true;
                        break;
                    }
                    case 93: {
                        Object obj;
                        Format dateFormatter = javaSqlTypeInfo.getFormatterForDefaultString();
                        if (targetDefault != null) {
                            obj = dateFormatter.parseObject(targetDefault);
                            SimpleDateFormat db2DateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSS");
                            String defVal = db2DateFormatter.format(obj);
                            if (0 == this.getDefaultValue().substring(0, defVal.length()).compareTo(defVal)) break;
                            defaultValueIsChanged = true;
                            break;
                        }
                        defaultValueIsChanged = true;
                        break;
                    }
                    default: {
                        if (!javaSqlTypeInfo.hasDefaultValue()) break;
                        defaultValueIsChanged = true;
                    }
                }
                if (defaultValueIsChanged) {
                    plan.setDefaultValueIsChanged(true);
                    Object[] arguments = new Object[]{this.getName(), this.getDefaultValue(), targetCol.getDefaultValue()};
                    loc.infoT("compareTo ({0}): conversion necessary: original default value {1} differs from target default value {2}}", arguments);
                    loc.exiting();
                    return new DbColumnDifference(this, target, plan, Action.CONVERT);
                }
            }
            if (plan.somethingIsChanged()) {
                Object[] arguments = new Object[]{this.getName()};
                loc.infoT("compareTo ({0}): column definition changed but can be handled by ALTER", arguments);
                loc.exiting();
                return new DbColumnDifference(this, target, plan, Action.ALTER);
            }
            loc.exiting();
            return null;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{this.getName(), ex.getMessage()};
            loc.errorT("compareTo ({0}) failed: {1}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public boolean acceptedAdd() {
        return true;
    }

    public boolean acceptedDrop() {
        return false;
    }

    public boolean compareDefault(DbDb2Column targetCol) {
        String origDefault = this.getDefaultValue();
        String targetDefault = targetCol.getDefaultValue();
        return !(origDefault == null && targetDefault != null || origDefault != null && targetDefault == null) && (origDefault == null || targetDefault == null || origDefault.equals(targetDefault));
    }

    public boolean checkNameLength() {
        loc.entering("checkNameLength");
        boolean check = true;
        if (this.getName().length() > DbDb2Parameters.maxColNameLen) {
            check = false;
            Object[] arguments = new Object[]{this.getName(), new Integer(this.getName().length()), new Integer(DbDb2Parameters.maxColNameLen)};
            loc.errorT("checkNameLength {0}: length of column name {1} not in allowed range [1,{2}]", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkTypeAttributes() {
        loc.entering("checkTypeAttributes()");
        boolean check = true;
        switch (this.getJavaSqlTypeInfo().getIntCode()) {
            case 2: 
            case 3: {
                Object[] arguments;
                long prec = this.getLength();
                long scale = this.getDecimals();
                if (prec < 1L || prec > 31L) {
                    arguments = new Object[]{this.getName(), new Long(prec), new Integer(DbDb2Parameters.maxDecimalDigits)};
                    loc.errorT("checkTypeAttributes {0}: precision {1} not in allowed range [1,{2}] for decimal-fields", arguments);
                    check = false;
                }
                if (prec >= scale) break;
                arguments = new Object[]{this.getName(), new Long(scale), new Long(prec)};
                loc.errorT("checkTypeAttributes {0}: scale of decimal ({1}) greater than precision ({2}).", arguments);
                check = false;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                long len = this.getLength();
                if (len >= 0L && len <= (long)DbDb2Parameters.maxLongRaw) break;
                check = false;
                Object[] arguments = new Object[]{this.getName(), new Long(len), new Integer(DbDb2Parameters.maxLongRaw)};
                loc.errorT("checkTypeAttributes {0}: length {1} not in allowed range [1,{2}] for binary-fields", arguments);
                break;
            }
            case 2004: {
                long len = this.getLength();
                if (len >= 0L && len <= (long)DbDb2Parameters.maxBlobLength) break;
                check = false;
                Object[] arguments = new Object[]{this.getName(), new Long(len), new Integer(DbDb2Parameters.maxBlobLength)};
                loc.errorT("checkTypeAttributes {0}: length {1} not in allowed range [1,{2}] for blob-fields", arguments);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                long len = this.getLength();
                if (len >= 0L && len <= (long)DbDb2Parameters.maxClobLength) break;
                check = false;
                Object[] arguments = new Object[]{this.getName(), new Long(len), new Integer(DbDb2Parameters.maxClobLength)};
                loc.errorT("checkTypeAttributes {0}: length {1} not in allowed range [1,{2}] for character-fields", arguments);
            }
        }
        loc.exiting();
        return check;
    }

    public boolean checkNameForReservedWord() {
        boolean check;
        loc.entering("checkNameForReservedWord");
        boolean bl = check = !DbDb2Environment.isReservedWord(this.getName());
        if (!check) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("checkNameForReservedWord {0}: reserved", arguments);
        }
        loc.exiting();
        return check;
    }

    public String getDdlDefaultValueClause() throws Exception {
        loc.entering("getDdlDefaultValueClause");
        try {
            JavaSqlTypeInfo javaSqlTypeInfo = super.getJavaSqlTypeInfo();
            String clause = "";
            switch (javaSqlTypeInfo.getIntCode()) {
                case -1: 
                case 1: 
                case 12: {
                    return super.getDdlDefaultValueClause();
                }
                case 92: {
                    Format dateFormatter = javaSqlTypeInfo.getFormatterForDefaultString();
                    String s = super.getDefaultValue();
                    if (s == null) break;
                    Object obj = dateFormatter.parseObject(s);
                    SimpleDateFormat db2DateFormatter = new SimpleDateFormat("HH.mm.ss");
                    String defVal = db2DateFormatter.format(obj);
                    clause = "DEFAULT " + javaSqlTypeInfo.getDefaultValuePrefix() + defVal + javaSqlTypeInfo.getDefaultValueSuffix();
                    break;
                }
                case 93: {
                    Format dateFormatter = javaSqlTypeInfo.getFormatterForDefaultString();
                    String s = super.getDefaultValue();
                    if (s == null) break;
                    Object obj = dateFormatter.parseObject(s);
                    SimpleDateFormat db2DateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSS");
                    String defVal = db2DateFormatter.format(obj);
                    clause = "DEFAULT " + javaSqlTypeInfo.getDefaultValuePrefix() + defVal + javaSqlTypeInfo.getDefaultValueSuffix();
                    break;
                }
                default: {
                    return super.getDdlDefaultValueClause();
                }
            }
            loc.exiting();
            return clause;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlDefaultValueClause failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setLobTableName(String lobTableName) {
        this.lobTableName = lobTableName;
    }

    public String getLobTableName() {
        return this.lobTableName;
    }

    public void setExcLength(Integer l) {
        this.excLength = l;
    }

    public Integer getExcLength() {
        return this.excLength;
    }

    private boolean isNumericAndKeyField() {
        loc.entering("isNumericAndKeyField");
        try {
            DbDb2Column source = this;
            int sourceType = this.getJavaSqlType();
            switch (sourceType) {
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    DbIndexes indexes;
                    DbTable tab = this.getColumns().getTable();
                    DbPrimaryKey pkey = tab.getPrimaryKey();
                    if (pkey != null) {
                        ArrayList cols = pkey.getColumnNames();
                        Iterator colsIter = ((AbstractList)cols).iterator();
                        while (colsIter.hasNext()) {
                            DbIndexColumnInfo dbIndexColumnInfo = (DbIndexColumnInfo)colsIter.next();
                            if (0 != this.getName().compareTo(dbIndexColumnInfo.getName())) continue;
                            Object[] arguments = new Object[]{this.getName(), new Integer(sourceType), tab.getName()};
                            loc.infoT("isNumericAndKeyField {0} type {1}: is key field of primary key to table {2}: cannot change type of numerics which are part of a primary key.", arguments);
                            loc.exiting();
                            return true;
                        }
                    }
                    if ((indexes = tab.getIndexes()) != null) {
                        DbIndexIterator iter = indexes.iterator();
                        while (iter.hasNext()) {
                            DbIndex ind = iter.next();
                            ArrayList cols = ind.getColumnNames();
                            Iterator colsIter = ((AbstractList)cols).iterator();
                            while (colsIter.hasNext()) {
                                DbIndexColumnInfo dbIndexColumnInfo = (DbIndexColumnInfo)colsIter.next();
                                if (0 != this.getName().compareTo(dbIndexColumnInfo.getName())) continue;
                                Object[] arguments = new Object[]{this.getName(), new Integer(sourceType), ind.getName()};
                                loc.infoT("isNumericAndKeyField {0} type {1}: is key field of index {2}: cannot change type of numerics which are part of an index.", arguments);
                                loc.exiting();
                                return true;
                            }
                        }
                    }
                    Object[] arguments = new Object[]{this.getName(), new Integer(sourceType)};
                    loc.infoT("isNumericAndKeyField {0} type {1}: not a key field.", arguments);
                    loc.exiting();
                    return false;
                }
            }
            loc.exiting();
            return false;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("isNumericAndKeyField: {0}", arguments);
            loc.exiting();
            return false;
        }
    }

    private boolean canChangeType(DbColumn target) {
        boolean canChangeType;
        DbDb2Column source;
        block43: {
            loc.entering("canChangeType");
            source = this;
            int sourceType = this.getJavaSqlType();
            int targetType = target.getJavaSqlType();
            canChangeType = false;
            if (this.isNumericAndKeyField()) {
                return false;
            }
            block0 : switch (sourceType) {
                case 5: {
                    switch (targetType) {
                        case -5: 
                        case 4: 
                        case 5: {
                            canChangeType = true;
                            break;
                        }
                        case 2: 
                        case 3: {
                            long q = target.getLength();
                            int t = target.getDecimals();
                            if (q - (long)t <= 4L) break;
                            canChangeType = true;
                            break;
                        }
                        case 6: 
                        case 8: {
                            canChangeType = true;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (targetType) {
                        case -5: 
                        case 4: {
                            canChangeType = true;
                            break;
                        }
                        case 2: 
                        case 3: {
                            long q = target.getLength();
                            int t = target.getDecimals();
                            if (q - (long)t <= 9L) break;
                            canChangeType = true;
                            break;
                        }
                        case 6: 
                        case 8: {
                            canChangeType = true;
                        }
                    }
                    break;
                }
                case -5: 
                case 2: 
                case 3: {
                    int s;
                    long p;
                    if (sourceType == -5) {
                        p = 19L;
                        s = 0;
                    } else {
                        p = source.getLength();
                        s = source.getDecimals();
                    }
                    switch (targetType) {
                        case 5: {
                            if (s != 0 || p >= 5L) break;
                            canChangeType = true;
                            break;
                        }
                        case 4: {
                            if (s != 0 || p >= 10L) break;
                            canChangeType = true;
                            break;
                        }
                        case -5: {
                            if (s != 0 || p > 19L) break;
                            canChangeType = true;
                            break;
                        }
                        case 2: 
                        case 3: {
                            long q = target.getLength();
                            int t = target.getDecimals();
                            if (q < p || q - (long)t < p - (long)s) break;
                            canChangeType = true;
                            break;
                        }
                        case 6: 
                        case 8: {
                            if (p >= 16L) break;
                            canChangeType = true;
                        }
                    }
                    break;
                }
                case 6: 
                case 8: {
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    long l = source.getLength();
                    switch (targetType) {
                        case -4: 
                        case -3: 
                        case -2: {
                            long m = target.getLength();
                            if (m < l) break;
                            canChangeType = true;
                        }
                    }
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    long l = source.getLength();
                    switch (targetType) {
                        case -1: 
                        case 1: 
                        case 12: {
                            if (l <= (long)DbDb2Parameters.maxLongChar) {
                                long m = target.getLength();
                                if (m < l || m > (long)DbDb2Parameters.maxLongChar) break block0;
                                canChangeType = true;
                                break;
                            }
                            break block43;
                        }
                        case 2005: {
                            if (l > (long)DbDb2Parameters.maxLongChar) {
                                canChangeType = true;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 2005: {
                    long l = source.getLength();
                    switch (targetType) {
                        case -1: 
                        case 1: 
                        case 12: {
                            long m = target.getLength();
                            if (m > (long)DbDb2Parameters.maxLongChar) {
                                canChangeType = true;
                                break block0;
                            }
                            break block43;
                        }
                        case 2005: {
                            canChangeType = true;
                        }
                    }
                }
            }
        }
        Object[] arguments = new Object[]{this.getName(), new Boolean(canChangeType), source.getJavaSqlTypeName(), new Long(source.getLength()), new Integer(source.getDecimals()), target.getJavaSqlTypeName(), new Long(target.getLength()), new Integer(target.getDecimals())};
        loc.infoT("canChangeType {0} {1}: from type {2}, length {3}, decimals {4} to type {5}, length {6}, decimals {7}", arguments);
        loc.exiting();
        return canChangeType;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean typeChanged(DbColumn target) {
        loc.entering("typeChanged");
        int sourceType = this.getJavaSqlType();
        int targetType = target.getJavaSqlType();
        boolean typeChanged = false;
        if (sourceType != targetType) {
            typeChanged = true;
            block0 : switch (sourceType) {
                case -5: 
                case 2: 
                case 3: {
                    int s;
                    long p;
                    if (sourceType == -5) {
                        p = 19L;
                        s = 0;
                    } else {
                        p = this.getLength();
                        s = this.getDecimals();
                    }
                    switch (targetType) {
                        case -5: {
                            if (s != 0 || p != 19L) break;
                            typeChanged = false;
                            break;
                        }
                        case 2: 
                        case 3: {
                            long q = target.getLength();
                            int t = target.getDecimals();
                            if (q != p || t != s) break;
                            typeChanged = false;
                            break;
                        }
                    }
                    break;
                }
                case 6: 
                case 8: {
                    switch (targetType) {
                        case 6: 
                        case 8: {
                            typeChanged = false;
                            break block0;
                        }
                    }
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    switch (targetType) {
                        case -4: 
                        case -3: 
                        case -2: {
                            typeChanged = false;
                            break block0;
                        }
                    }
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    switch (targetType) {
                        case -1: 
                        case 1: 
                        case 12: {
                            typeChanged = false;
                            break block0;
                        }
                    }
                    break;
                }
                case 2005: {
                    switch (targetType) {
                        case -1: 
                        case 1: 
                        case 12: {
                            long m = target.getLength();
                            if (m <= (long)DbDb2Parameters.maxLongChar) break;
                            typeChanged = false;
                        }
                    }
                    break;
                }
            }
        }
        loc.exiting();
        return typeChanged;
    }

    private boolean lengthChanged(DbColumn target) {
        return this.getJavaSqlTypeInfo().hasLengthAttribute() && target.getJavaSqlTypeInfo().hasLengthAttribute() && this.getLength() != target.getLength();
    }

    private boolean scaleChanged(DbColumn target) {
        return this.getJavaSqlTypeInfo().hasDecimals() && this.getDecimals() != target.getDecimals();
    }
}

