/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.util.project;

import com.tssap.j2ee.util.UtilPlugin;
import com.tssap.j2ee.util.core.filter.IJavaProjectFilter;
import com.tssap.j2ee.util.core.filter.IProjectFilter;
import com.tssap.selena.impl.model.elements.ModelPlugin;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;

public class ProjectUtil {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$util$project$ProjectUtil == null ? (class$com$tssap$j2ee$util$project$ProjectUtil = ProjectUtil.class$("com.tssap.j2ee.util.project.ProjectUtil")) : class$com$tssap$j2ee$util$project$ProjectUtil));
    static /* synthetic */ Class class$com$tssap$j2ee$util$project$ProjectUtil;

    public static void updateProjectNatures(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        ProjectUtil.updateProjectNatures(project, new String[]{nature}, monitor);
    }

    public static void updateProjectNatures(IProject project, String[] natures, IProgressMonitor monitor) throws CoreException {
        ModelPlugin.getDefault().getPlatform();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < natures.length) {
            if (!project.hasNature(natures[i])) {
                list.add(natures[i]);
            }
            ++i;
        }
        if (list.size() == 0) {
            return;
        }
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        list.addAll(Arrays.asList(prevNatures));
        String[] newNatures = new String[list.size()];
        newNatures = list.toArray(newNatures);
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static IProject[] getProjects(IProjectFilter filter) {
        ArrayList<IProject> pListFiltered = new ArrayList<IProject>();
        IProject[] pList = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < pList.length) {
            if (pList[i].isOpen() && filter.accept(pList[i])) {
                pListFiltered.add(pList[i]);
            }
            ++i;
        }
        pList = new IProject[pListFiltered.size()];
        pList = pListFiltered.toArray(pList);
        return pList;
    }

    public static String[] getProjectNames(IJavaProject[] projects) {
        String[] pNames = new String[projects.length];
        int i = 0;
        while (i < pNames.length) {
            pNames[i] = projects[i].getProject().getName();
            ++i;
        }
        return pNames;
    }

    public static IJavaProject[] getJavaProjects(IJavaProjectFilter filter) {
        IProject[] pList = ProjectUtil.getProjects(filter);
        IJavaProject[] jpList = new IJavaProject[pList.length];
        int i = 0;
        while (i < jpList.length) {
            jpList[i] = JavaCore.create((IProject)pList[i]);
            ++i;
        }
        return jpList;
    }

    public static IJavaProject[] getJavaProjects() {
        return ProjectUtil.getJavaProjects(new IJavaProjectFilter(){

            public boolean accept(JavaProject prj) {
                return true;
            }

            public boolean accept(IProject prj) {
                try {
                    if (prj.hasNature("org.eclipse.jdt.core.javanature")) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    TRACER.error("not possible to check project nature", (Throwable)e);
                }
                return false;
            }
        });
    }

    public static Object[] getReferencedObjectsFromClasspath(IJavaProject prj, boolean iterateReferences) {
        HashSet allProjectsSet = new HashSet();
        IJavaProject[] allProjects = ProjectUtil.getReferencedProjectsFromClasspath(prj, allProjectsSet, iterateReferences);
        Object[] allLibs = ProjectUtil.getReferencedLibsFromClasspath(prj);
        if (allLibs == null) {
            allLibs = new Object[]{};
        }
        Object[] allSources = new Object[allProjects.length + allLibs.length];
        System.arraycopy(allProjects, 0, allSources, 0, allProjects.length);
        System.arraycopy(allLibs, 0, allSources, allProjects.length, allLibs.length);
        return allSources;
    }

    public static IJavaProject[] getReferencedProjectsFromClasspath(IJavaProject prj, Set allReferencedProjects, boolean iterateReferences) {
        IClasspathEntry[] entry;
        allReferencedProjects.add(prj);
        try {
            entry = prj.getResolvedClasspath(false);
        }
        catch (JavaModelException e) {
            TRACER.error("Retrieving resolved classpath for project failed", (Throwable)e);
            return null;
        }
        int i = 0;
        while (i < entry.length) {
            IJavaProject javaPrj;
            if (entry[i].getEntryKind() == 2 && !allReferencedProjects.contains(javaPrj = JavaCore.create((IWorkspaceRoot)UtilPlugin.getWorkspace().getRoot()).getJavaProject(entry[i].getPath().segment(0)))) {
                if (iterateReferences) {
                    IJavaProject[] itPrjs = ProjectUtil.getReferencedProjectsFromClasspath(javaPrj, allReferencedProjects, iterateReferences);
                    if (itPrjs != null && itPrjs.length > 0) {
                        allReferencedProjects.addAll(Arrays.asList(itPrjs));
                    }
                } else {
                    allReferencedProjects.add(javaPrj);
                }
            }
            ++i;
        }
        IJavaProject[] allSources = new IJavaProject[allReferencedProjects.size()];
        allReferencedProjects.toArray(allSources);
        return allSources;
    }

    public static File[] getReferencedLibsFromClasspath(IJavaProject prj) {
        IClasspathEntry[] entry;
        ArrayList<File> allElements = new ArrayList<File>();
        try {
            entry = prj.getRawClasspath();
        }
        catch (JavaModelException e) {
            TRACER.error("Retrieving raw classpath for project failed", (Throwable)e);
            return null;
        }
        int i = 0;
        while (i < entry.length) {
            IClasspathEntry newEntry;
            if (!(entry[i].getEntryKind() == 4 && (entry[i].getPath().segment(0).equals("TSSAP_JAVAX_HOME") || entry[i].getPath().segment(0).equals("JRE_LIB") || entry[i].getPath().segment(0).equals("SAP_USER_ADD_LIBS") || entry[i].getPath().segment(0).equals("SAP_SYSTEM_ADD_LIBS") || entry[i].getPath().segment(0).equals("SAP_ENGINE_ADD_LIBS")) || (newEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry[i])).getEntryKind() != 1)) {
                IPackageFragmentRoot[] rts = prj.findPackageFragmentRoots(newEntry);
                if (rts == null || rts.length <= 0) {
                    rts = prj.findPackageFragmentRoots(entry[i]);
                }
                int p = 0;
                while (p < rts.length) {
                    if (rts[p].isArchive()) {
                        try {
                            File lib;
                            if (!rts[p].isExternal()) {
                                IResource res = rts[p].getUnderlyingResource();
                                if (res != null && res.exists()) {
                                    lib = new File(res.getFullPath().toOSString());
                                    allElements.add(lib);
                                }
                            } else {
                                IPath path = rts[p].getPath();
                                if (path != null) {
                                    lib = new File(path.toOSString());
                                    allElements.add(lib);
                                }
                            }
                        }
                        catch (JavaModelException e) {
                            TRACER.error("Problems while retrieving resource file for archive", (Throwable)e);
                        }
                    }
                    ++p;
                }
            }
            ++i;
        }
        File[] allSources = new File[allElements.size()];
        allSources = allElements.toArray(new File[0]);
        return allSources;
    }

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                ProjectUtil.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

