/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.util.jdt;

import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.j2ee.util.core.StringUtils;
import com.tssap.j2ee.util.jdt.JDTInternals;
import com.tssap.j2ee.util.project.ProjectUtil;
import com.tssap.j2ee.util.wizard.WizardMsg;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.UIPlugin;

public class JDTUtils {
    public static final String ALL_APIS = "All_APIs";
    public static final int BUTTON_CREATE_CLASS = 0;
    public static final int BUTTON_RENAME_CLASS = 1;
    public static final int BUTTON_CANCEL_CLASS = 2;
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$util$jdt$JDTUtils == null ? (class$com$tssap$j2ee$util$jdt$JDTUtils = JDTUtils.class$("com.tssap.j2ee.util.jdt.JDTUtils")) : class$com$tssap$j2ee$util$jdt$JDTUtils));
    static /* synthetic */ Class class$com$tssap$j2ee$util$jdt$JDTUtils;

    public static String getFQN(IType context, String typeName) {
        return com.tssap.j2ee.internal.core.ejb.util.JDTUtils.getFQN((IType)context, (String)typeName);
    }

    public static IPackageFragment choosePackageFromDialog(Shell shell, IJavaProject prj, IPackageFragment currentPackage, boolean includeRequiredProjects) {
        SelectionDialog dialog = null;
        int includeRequiredProjectsFlag = includeRequiredProjects ? 32 : 0;
        try {
            dialog = JavaUI.createPackageDialog((Shell)shell, (IJavaProject)prj, (int)includeRequiredProjectsFlag);
        }
        catch (JavaModelException e) {
            TRACER.error("Couldnt create PackageDialog", (Throwable)e);
            return null;
        }
        dialog.setTitle(WizardMsg.getString("NewEjb.PackageDialog.windowTitle"));
        dialog.setMessage(WizardMsg.getString("NewEjb.PackageDialog.description"));
        if (currentPackage != null) {
            dialog.setInitialSelections(new Object[]{currentPackage});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getResult()[0];
        }
        return null;
    }

    public static IPackageFragment choosePackage(IPackageFragmentRoot[] root, IPackageFragment currentPackage, Shell shell) {
        IPackageFragmentRoot[] froot = root;
        ArrayList<Object> packagesList = null;
        Object[] packages = null;
        try {
            if (froot != null) {
                packagesList = new ArrayList<Object>();
                int i = 0;
                while (i < froot.length) {
                    IJavaElement[] allChilds = froot[i].getChildren();
                    List<Object> listOf = Arrays.asList((Object[])allChilds);
                    packagesList.addAll(listOf);
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            TRACER.log(4, "No PackageFragments available", (Throwable)e);
        }
        if (packagesList == null) {
            packages = new IJavaElement[]{};
        } else {
            packages = new IJavaElement[packagesList.size()];
            packagesList.toArray(packages);
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(WizardMsg.getString("NewEjb.PackageDialog.windowTitle"));
        dialog.setMessage(WizardMsg.getString("NewEjb.PackageDialog.description"));
        dialog.setEmptyListMessage(WizardMsg.getString("empty List"));
        dialog.setElements(packages);
        if (currentPackage != null) {
            dialog.setInitialSelections(new Object[]{currentPackage});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    public static IType chooseEnclosingType(IPackageFragmentRoot[] root, String[] jdkTypes, Shell shell, IRunnableContext container, int type, IJavaElement currentSelection) {
        return JDTUtils.chooseEnclosingType(root, jdkTypes, shell, container, type, JDTUtils.getFQN(currentSelection));
    }

    private static String getFQN(IJavaElement currentSelection) {
        String fqName = null;
        try {
            if (currentSelection instanceof IType) {
                fqName = ((IType)currentSelection).getFullyQualifiedName();
            }
            if (currentSelection instanceof ICompilationUnit) {
                fqName = ((ICompilationUnit)currentSelection).findPrimaryType().getFullyQualifiedName();
            }
            if (currentSelection instanceof IClassFile) {
                fqName = ((IClassFile)currentSelection).getType().getFullyQualifiedName();
            }
            return fqName;
        }
        catch (JavaModelException e) {
            TRACER.error("Retrieving type for classfile failed", (Throwable)e);
            return null;
        }
    }

    public static IType chooseEnclosingType(IPackageFragmentRoot[] root, String[] jdkTypes, Shell shell, IRunnableContext container, int type, String currentSelection) {
        IType ret = null;
        String currSelection = "";
        IJavaSearchScope scope = JDTUtils.buildJavaSearchScope(root, jdkTypes);
        if (currentSelection != null && !currentSelection.equals("")) {
            currSelection = currentSelection;
        }
        SelectionDialog dialog = null;
        try {
            Object[] obj;
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)container, (IJavaSearchScope)scope, (int)type, (boolean)false, (String)currSelection);
            dialog.setTitle(WizardMsg.getString("NewEjb.ClassDialog.windowTitle"));
            dialog.setMessage(WizardMsg.getString("NewEjb.ClassDialog.description"));
            if (dialog.open() == 0 && (obj = dialog.getResult()) != null) {
                ret = (IType)obj[0];
            }
        }
        catch (JavaModelException e) {
            TRACER.error("Creation of TypeDialog failed", (Throwable)e);
        }
        return ret;
    }

    public static IJavaProject[] getAllJavaProjects() {
        return ProjectUtil.getJavaProjects();
    }

    private static IWorkbench getWorkbench() {
        return UIPlugin.getDefault().getWorkbench();
    }

    public static IPackageFragment[] getAllPackages(IJavaProject prj) {
        try {
            ArrayList<IJavaElement> tempChilds = new ArrayList<IJavaElement>();
            IPackageFragmentRoot[] roots = JDTUtils.getSrcPackageFragmentRoots(prj);
            int i = 0;
            while (roots != null && i < roots.length) {
                try {
                    IJavaElement[] fragments = roots[i].getChildren();
                    int j = 0;
                    while (j < fragments.length) {
                        if (fragments[j] instanceof IPackageFragment) {
                            tempChilds.add(fragments[j]);
                            JDTUtils.iterateThroughPackage((IPackageFragment)fragments[j], tempChilds);
                        }
                        ++j;
                    }
                }
                catch (RuntimeException e) {
                    TRACER.log(4, "No subpackages available", (Throwable)e);
                }
                ++i;
            }
            IPackageFragment[] packages = new IPackageFragment[tempChilds.size()];
            tempChilds.toArray(packages);
            return packages;
        }
        catch (Exception exp) {
            TRACER.error("getAllPackages", "No valid SrcPackageRoot in Project", (Throwable)exp);
            return null;
        }
    }

    public static IPackageFragment getPackageFragmentByName(IJavaProject javprj, String name) {
        if (javprj == null || !javprj.exists()) {
            return null;
        }
        IPackageFragmentRoot[] srcRoots = JDTUtils.getSrcPackageFragmentRoots(javprj);
        IPackageFragment pkg = null;
        int i = 0;
        while (i < srcRoots.length) {
            IPackageFragmentRoot root = srcRoots[i];
            pkg = root.getPackageFragment(name);
            if (pkg != null && pkg.exists()) {
                return pkg;
            }
            ++i;
        }
        return null;
    }

    public static IPackageFragmentRoot[] getSrcPackageFragmentRoots(IJavaProject project) {
        return com.tssap.util.jdt.JDTUtils.getSrcPackageFragmentRoots((IJavaProject)project);
    }

    private static void iterateThroughPackage(IPackageFragment fragment, List list) {
        IJavaElement[] childs;
        try {
            childs = fragment.getChildren();
        }
        catch (Exception e) {
            TRACER.log(4, "No subpackages available", (Throwable)e);
            return;
        }
        int i = 0;
        while (i < childs.length) {
            if (childs[i] instanceof IPackageFragment) {
                list.add(childs[i]);
                JDTUtils.iterateThroughPackage((IPackageFragment)childs[i], list);
            }
            ++i;
        }
    }

    private static IJavaSearchScope buildJavaSearchScope(IPackageFragmentRoot[] root, String[] jdkTypes) {
        IJavaProject project = null;
        ArrayList<IPackageFragmentRoot> pkgRoots = new ArrayList<IPackageFragmentRoot>();
        if (root != null) {
            if (root.length == 1 && root[0] != null) {
                project = root[0].getJavaProject();
                pkgRoots.add(root[0]);
            } else {
                pkgRoots.addAll(Arrays.asList(root));
            }
        }
        if (jdkTypes != null) {
            IJavaProject[] prjs = new IJavaProject[]{project};
            if (project == null) {
                prjs = JDTUtils.getAllJavaProjects();
            }
            int i = 0;
            while (prjs != null && i < prjs.length) {
                try {
                    pkgRoots.addAll(Arrays.asList(prjs[i].getAllPackageFragmentRoots()));
                }
                catch (JavaModelException e) {
                    TRACER.error("Problems fetching package fragments for project", (Throwable)e);
                }
                ++i;
            }
        }
        IPackageFragmentRoot[] roots = new IPackageFragmentRoot[pkgRoots.size()];
        try {
            pkgRoots.toArray(roots);
        }
        catch (ArrayStoreException e) {
            TRACER.error("Problems converting List to Array", (Throwable)e);
            return null;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])roots);
    }

    public static IJavaElement renameClass(String oldFQClassName, IJavaProject oldClassProject, String newFQClassName, IPackageFragment newPackageFragment, Shell shell) {
        IType classC = null;
        classC = JDTUtils.findJavaClass(oldFQClassName, oldClassProject, true, true);
        if (classC != null) {
            try {
                classC.move((IJavaElement)newPackageFragment, null, newFQClassName, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                TRACER.error("renameClass", "rename failed", (Throwable)e);
                ErrorDialog.openError((Shell)shell, (String)"ERROR", (String)"rename failed", (IStatus)new StatusWrapper().getStatusInfo());
                return null;
            }
            return newPackageFragment.getCompilationUnit(newFQClassName);
        }
        return null;
    }

    public static IJavaElement createClass(String newFQClassName, IPackageFragment pkg, IJavaProject project, Shell shell) {
        return JDTInternals.newTypeWizard(JDTUtils.getWorkbench(), null, shell, 1, pkg, newFQClassName);
    }

    public static IJavaElement createInterface(String newFQInterfaceName, IPackageFragment pkg, IJavaProject project, Shell shell) {
        return JDTInternals.newTypeWizard(JDTUtils.getWorkbench(), null, shell, 0, pkg, newFQInterfaceName);
    }

    public static IPackageFragment createPackageByDialog(String FQPackageName, IJavaProject project, Shell shell) {
        return JDTInternals.newPackageWizard(JDTUtils.getWorkbench(), null, shell, FQPackageName);
    }

    public static IPackageFragment createPackage(String FQPackageName, IPackageFragmentRoot srcRoot) {
        IJavaElement elem;
        String path = srcRoot.getElementName() + "/" + FQPackageName.replace('.', '/');
        IFolder folder = srcRoot.getJavaProject().getProject().getFolder(path);
        if (!folder.exists()) {
            try {
                ProjectUtil.createFolder(folder, true, true, (IProgressMonitor)new NullProgressMonitor());
                if (!folder.exists()) {
                    return null;
                }
            }
            catch (CoreException e) {
                TRACER.error("Not possible to create Folder", (Throwable)e);
                return null;
            }
        }
        if ((elem = JavaCore.create((IFolder)folder)) instanceof IPackageFragment) {
            return (IPackageFragment)elem;
        }
        return null;
    }

    public static IType findJavaClass(String fqClassName, IJavaProject prj, boolean onlySourceRoots, boolean iterateReferencedProjects) {
        ArrayList<IPackageFragmentRoot> allPkgRoots = null;
        IJavaProject[] javaPrjs = null;
        if (iterateReferencedProjects) {
            IJavaProject[] refPrjs = ProjectUtil.getReferencedProjectsFromClasspath(prj, new HashSet(), iterateReferencedProjects);
            javaPrjs = new IJavaProject[refPrjs.length];
            System.arraycopy(refPrjs, 0, javaPrjs, 0, refPrjs.length);
        } else {
            javaPrjs = new IJavaProject[]{prj};
        }
        if (javaPrjs == null || javaPrjs.length <= 0) {
            return null;
        }
        try {
            allPkgRoots = new ArrayList<IPackageFragmentRoot>();
            int i = 0;
            while (i < javaPrjs.length) {
                IPackageFragmentRoot[] tmpRoots = null;
                tmpRoots = onlySourceRoots ? JDTUtils.getSrcPackageFragmentRoots(javaPrjs[i]) : javaPrjs[i].getAllPackageFragmentRoots();
                if (tmpRoots != null) {
                    allPkgRoots.addAll(Arrays.asList(tmpRoots));
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            TRACER.error("No valid PackageFragmentRoots", (Throwable)e);
            return null;
        }
        IType classC = JDTUtils.findJavaType(allPkgRoots.toArray(new IPackageFragmentRoot[0]), fqClassName);
        if (classC != null) {
            return classC;
        }
        return null;
    }

    public static IType check_and_getClassExistence(String fqClassName, IJavaProject[] javaPrjs, boolean onlySourceRoots) {
        ArrayList<IPackageFragmentRoot> allPkgRoots;
        try {
            allPkgRoots = new ArrayList<IPackageFragmentRoot>();
            int i = 0;
            while (i < javaPrjs.length) {
                IPackageFragmentRoot[] tmpRoots = null;
                tmpRoots = onlySourceRoots ? JDTUtils.getSrcPackageFragmentRoots(javaPrjs[i]) : javaPrjs[i].getAllPackageFragmentRoots();
                if (tmpRoots != null) {
                    allPkgRoots.addAll(Arrays.asList(tmpRoots));
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            TRACER.error("No valid PackageFragmentRoots", (Throwable)e);
            return null;
        }
        IType classC = JDTUtils.findJavaType(allPkgRoots.toArray(new IPackageFragmentRoot[0]), fqClassName);
        if (classC != null) {
            return classC;
        }
        return null;
    }

    public static boolean checkClassExistence(String fqClassName, IJavaProject[] javaPrjs, boolean onlySourceRoots) throws Exception {
        return JDTUtils.check_and_getClassExistence(fqClassName, javaPrjs, onlySourceRoots) != null;
    }

    public static boolean checkClassExistence(String fqClassName, boolean onlySourceRoots) throws Exception {
        IJavaProject[] javaPrjs = JDTUtils.getAllJavaProjects();
        return JDTUtils.checkClassExistence(fqClassName, javaPrjs, onlySourceRoots);
    }

    public static IFile[] getFilesFromITypes(IType[] types) {
        ArrayList<IFile> files = new ArrayList<IFile>(types.length);
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            try {
                IResource res = null;
                if (type != null && (res = type.getUnderlyingResource()) != null && res instanceof IFile) {
                    files.add((IFile)res);
                }
            }
            catch (JavaModelException e) {
                TRACER.error("Problems getting IFile to IType", (Throwable)e);
                return new IFile[0];
            }
            ++i;
        }
        return files.toArray(new IFile[0]);
    }

    private static IType findJavaType(IPackageFragmentRoot[] pkgRoots, String fqClassName) {
        IType newClass = null;
        int i = 0;
        while (i < pkgRoots.length) {
            IPackageFragmentRoot root = pkgRoots[i];
            IJavaElement prj = root.getParent();
            if (prj instanceof IJavaProject) {
                try {
                    newClass = ((IJavaProject)prj).findType(StringUtils.removeExtension(fqClassName, true));
                    if (newClass != null && newClass.exists()) {
                        return newClass;
                    }
                }
                catch (JavaModelException e) {
                    TRACER.log(4, "Problem while searching for java type", (Throwable)e);
                }
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

