/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.util.jdt;

import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public abstract class JDTClasspathUtil {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$util$jdt$JDTClasspathUtil == null ? (class$com$tssap$j2ee$util$jdt$JDTClasspathUtil = JDTClasspathUtil.class$("com.tssap.j2ee.util.jdt.JDTClasspathUtil")) : class$com$tssap$j2ee$util$jdt$JDTClasspathUtil));
    static /* synthetic */ Class class$com$tssap$j2ee$util$jdt$JDTClasspathUtil;

    public static boolean setLibraryClassPathEntry(IJavaProject prj, IPath libPath) {
        try {
            IClasspathEntry[] prevCp = prj.getRawClasspath();
            IClasspathEntry newCpe = JavaCore.newLibraryEntry((IPath)libPath, null, null);
            if (!JDTClasspathUtil.isInClasspath(prevCp, newCpe)) {
                IClasspathEntry[] newCp = new IClasspathEntry[prevCp.length + 1];
                System.arraycopy(prevCp, 0, newCp, 0, prevCp.length);
                newCp[prevCp.length] = newCpe;
                prj.setRawClasspath(newCp, null);
            }
        }
        catch (JavaModelException e) {
            TRACER.error("Not possible to set library claspath entry", (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean isInClasspath(IClasspathEntry[] prevCp, IClasspathEntry newCpe) {
        int i = 0;
        while (i < prevCp.length) {
            if (prevCp[i].equals(newCpe)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean removeCpEntry(IJavaProject javaProject, String entryName) {
        try {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] cpEntries = javaProject.getRawClasspath();
            int i = 0;
            while (i < cpEntries.length) {
                if (cpEntries[i].getEntryKind() != 4 || cpEntries[i].getPath().toString().indexOf(entryName) < 0) {
                    newEntries.add(cpEntries[i]);
                }
                ++i;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
        catch (JavaModelException e) {
            TRACER.error("Not possible to remove entry from classpath", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean removeSourceFolderEntries(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return false;
        }
        try {
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] cpEntries = javaProject.getRawClasspath();
            int i = 0;
            while (i < cpEntries.length) {
                if (cpEntries[i].getEntryKind() != 3) {
                    newEntries.add(cpEntries[i]);
                }
                ++i;
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
        }
        catch (JavaModelException e) {
            TRACER.error("Not possible to remove source folder entry", (Throwable)e);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

