/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.util.file;

import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.util.UtilPlugin;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class FileUtil {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$util$file$FileUtil == null ? (class$com$tssap$j2ee$util$file$FileUtil = FileUtil.class$("com.tssap.j2ee.util.file.FileUtil")) : class$com$tssap$j2ee$util$file$FileUtil));
    static /* synthetic */ Class class$com$tssap$j2ee$util$file$FileUtil;

    public static File getFile(String filePath) {
        URL base_url = UtilPlugin.getDefault().getDescriptor().getInstallURL();
        URL url = null;
        File template = null;
        try {
            url = new URL(base_url, filePath);
        }
        catch (MalformedURLException e) {
            tracer.error("getFile", "No valid URL", (Throwable)e);
            return null;
        }
        try {
            url = Platform.asLocalURL((URL)url);
            template = new File(url.getPath());
            if (!template.exists()) {
                tracer.error("getFile", "File don`t exist");
                throw new FileNotFoundException("File dont exist");
            }
            if (!template.canRead()) {
                tracer.error("getFile", "File not readable");
                throw new FileNotFoundException("File not readable");
            }
        }
        catch (FileNotFoundException fnfe) {
            tracer.error("getFile", "File not found", (Throwable)fnfe);
            return null;
        }
        catch (IOException e) {
            tracer.error("getFileStream", "", (Throwable)e);
            return null;
        }
        return template;
    }

    public static URL getURLForRelativePath(Plugin plugin, String relativePath) throws MalformedURLException {
        String METHOD = "getURLForRelativePath(relativePath)";
        if (tracer.debug()) {
            tracer.debug(METHOD, "relativePath = " + relativePath);
        }
        URL url = new URL(plugin.getDescriptor().getInstallURL(), relativePath);
        return url;
    }

    public static void createDirectories(IContainer container, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        if (container != null && container instanceof IFolder && !(folder = (IFolder)container).exists()) {
            IContainer parent = folder.getParent();
            FileUtil.createDirectories(parent, force, local, null);
            folder.create(force, local, monitor);
        }
    }

    public static void copyFile(URL source, IFile destination, boolean overwrite) {
        String METHOD = "copyTemplate(source, destination, overwrite)";
        if (tracer.debug()) {
            tracer.debug(METHOD, "source = " + source + ", destination = " + destination);
        }
        try {
            if (tracer.path()) {
                tracer.path(METHOD, "start to copy file '" + source + "' to '" + destination + "'");
            }
            InputStream in = source.openStream();
            if (!destination.exists()) {
                FileUtil.createDirectories(destination.getParent(), true, true, null);
                destination.create(in, true, null);
            } else if (overwrite) {
                destination.setContents(in, true, true, null);
            } else {
                tracer.warning(METHOD, "Will not overwrite existing file: " + destination);
            }
            if (tracer.path()) {
                tracer.path(METHOD, "successfully copied file '" + source + "' to '" + destination + "'");
            }
        }
        catch (Exception e) {
            tracer.error(METHOD, "Not able to copy file '" + source + "' to '" + destination + "': " + e.toString(), (Throwable)e);
        }
    }

    public static void copyTemplate(Plugin plugin, String templateName, IFile destination, String[] placeholder, String[] placeholderValue) {
        String METHOD = "copyTemplate(templateName, destination)";
        if (tracer.debug()) {
            tracer.debug(METHOD, "templateName = " + templateName + ", destination = " + destination);
        }
        try {
            String templateContents = FileUtils.getFileContents((String)templateName, null, (Plugin)plugin);
            int i = 0;
            while (i < placeholder.length) {
                templateContents = FileUtil.replaceString(templateContents, placeholder[i], placeholderValue[i]);
                ++i;
            }
            ByteArrayInputStream templateContentsStream = new ByteArrayInputStream(templateContents.getBytes());
            FileUtil.createDirectories(destination.getParent(), true, true, null);
            destination.create((InputStream)templateContentsStream, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            tracer.error(METHOD, "Not able to copy template '" + templateName + "' to '" + destination + "': " + e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceString(String source, String placeholder, String placeholderValue) {
        int index;
        StringBuffer result = new StringBuffer(source.length() + 128);
        while ((index = source.indexOf(placeholder)) >= 0) {
            void var4_4;
            result.append(source.substring(0, (int)var4_4));
            result.append(placeholderValue);
            source = source.substring((int)(var4_4 + placeholder.length()));
        }
        result.append(source);
        return result.toString();
    }

    public static void getIterativFilesToFolder(IFolder folder, List allRelatedFiles) throws Exception {
        IResource[] files;
        try {
            files = folder.members();
        }
        catch (CoreException e) {
            tracer.error("getFilesToFolder", "Not able to get Files for Folder", (Throwable)e);
            throw e;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i] instanceof IFile) {
                allRelatedFiles.add(files[i]);
            } else if (files[i] instanceof IFolder) {
                FileUtil.getIterativFilesToFolder((IFolder)files[i], allRelatedFiles);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

