/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.util.core;

public class CompConstants {
    public static final String PURPOSE_COMPILATION = "compilation";
    public static final String PURPOSE_ASSEMBLY = "assembly";
    public static final String PURPOSE_INFRASTRUCTURE = "infrastructure";
    public static final String CPP_LIBRARY = "defLib";
    public static final String CPP_SERVICE = "defServ";
    public static final String APP_EJBMODULE = "ejbjar";
    public static final String CPP_EJBMODULE = "client";
    public static final String APP_WEBMODULE = "war";
    private static String PP_FOLDER = "/def/";
    private static String PP_EXTENSION = ".pp";
    public static final String APP_EJBMODULE_FILE = PP_FOLDER + "ejbjar" + PP_EXTENSION;
    public static final String CPP_EJBMODULE_FILE = PP_FOLDER + "client" + PP_EXTENSION;
    public static final String APP_WEBMODULE_FILE = PP_FOLDER + "war" + PP_EXTENSION;
    public static final String DCDEF_FILE = "/.dcdef";
    public static final String PPET_FOLDER_TREE = "Folder Tree";
    public static final String PPET_PACKAGE_TREE = "Java Package Tree";
    public static final String PPET_PACKAGE = "Java Package";
    public static final String PPET_CLASS = "Java Class";
    public static final String PPET_SUB_CLASS = "Class";
    public static final String PPET_SUB_SOURCE = "Source";
    public static final String PPET_WAR = "WAR";
    public static final String PPET_EJBJAR = "EJB-JAR";
    public static final String PPET_EJB_CLIENT_JAR = "EJB-Client-JAR";
    public static final String PPET_SERVER_COMP_JAR = "SERVER_COMPONENTS";
    public static final String PPET_PACKAGEROOT_PREFIX = "PR";
    private static final String DC_GEN_FOLDER = "/gen";
    private static final String DC_LOCATION_EAR = "/deploy/";
    private static final String DC_LOCATION_LIBRARY = "/deploy/";
    private static final String DC_LOCATION_EJBJAR = "/public/ejbjar/lib/java/";
    private static final String DC_LOCATION_CLIENT_JAR = "/public/client/lib/java/";
    private static final String DC_LOCATION_CLIENT_SRC = "/public/client/src/java/";
    private static final String DC_LOCATION_WAR = "/public/war/lib/java/";

    public static String getDcLocationEar(String buildVariant) {
        return CompConstants.createFullLocation(buildVariant, "/deploy/");
    }

    public static String getDcLocationLibrary(String buildVariant) {
        return CompConstants.createFullLocation(buildVariant, "/deploy/");
    }

    public static String getDcLocationEjbJar(String buildVariant) {
        return CompConstants.createFullLocation(buildVariant, DC_LOCATION_EJBJAR);
    }

    public static String getDcLocationClientCPPJar(String buildVariant) {
        return CompConstants.createFullLocation(buildVariant, DC_LOCATION_CLIENT_JAR);
    }

    public static String getDcLocationWar(String buildVariant) {
        return CompConstants.createFullLocation(buildVariant, DC_LOCATION_WAR);
    }

    private static String createFullLocation(String buildVariant, String location) {
        if (buildVariant == null) {
            buildVariant = "";
        }
        if (buildVariant.length() > 0) {
            buildVariant = "/" + buildVariant;
        }
        return DC_GEN_FOLDER + buildVariant + location;
    }
}

