/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.trackers;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gef.tools.ToolUtilities;

public class SplitTracker
extends SimpleDragTracker {
    public static final String REQ_SPLITMOVE = "move split";
    private int myDirection;

    public SplitTracker(int direction) {
        this.myDirection = direction;
    }

    protected List createOperationSet() {
        List list = super.createOperationSet();
        ToolUtilities.filterEditPartsUnderstanding((List)list, (Request)this.getSourceRequest());
        return list;
    }

    protected Request createSourceRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)this.getCommandName());
        return request;
    }

    protected String getCommandName() {
        return REQ_SPLITMOVE;
    }

    protected String getDebugName() {
        return this.getCommandName() + " tracker";
    }

    protected Command getCommand() {
        List editparts = this.getOperationSet();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel(this.getCommandName() + " Tracker");
        int i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            command.add(part.getCommand(this.getSourceRequest()));
            ++i;
        }
        return command.unwrap();
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point corner = new Point(0, 0);
        if (this.myDirection == 24) {
            corner.x += d.width;
        } else if (this.myDirection == 5) {
            corner.y += d.height;
        } else {
            corner.x += d.width;
            corner.y += d.height;
        }
        request.setMoveDelta(corner);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
    }
}

