/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.locators;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.GenericGridLayoutManager;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class GridLocator
implements Locator {
    public static final int NO_ORIENTATION_HANDLE = -1;
    public static final int VERTICAL_HANDLE = 0;
    public static final int HORIZONTAL_HANDLE = 1;
    private static final int TAR_SIZE = 5;
    private static final int SQUARE_SIZE = 7;
    private IFigure myReference;
    private int myOrientation;
    private int myPosition;
    private int myOrtogonalPosition;

    public GridLocator(IFigure container, int orientation, int position) {
        this.myReference = container;
        this.myOrientation = orientation;
        this.myPosition = position;
    }

    public GridLocator(IFigure container, int orientation, int x, int y) {
        this(container, orientation, x);
        this.myOrtogonalPosition = y;
    }

    public void relocate(IFigure target) {
        GenericGridLayoutManager layoutManager = (GenericGridLayoutManager)this.myReference.getLayoutManager();
        Rectangle refBounds = this.myReference.getBounds();
        Rectangle relSplitterCoordinates = layoutManager.getSplitterCoordinates(this.myOrientation, this.myPosition, this.myOrtogonalPosition, refBounds.getSize());
        Rectangle tarBounds = new Rectangle(relSplitterCoordinates.getTopLeft().getTranslated(refBounds.getTopLeft()), relSplitterCoordinates.getBottomRight().getTranslated(refBounds.getTopLeft()));
        tarBounds.translate(-1, -1);
        int lineWidth = 5;
        if (relSplitterCoordinates.height <= 1 && relSplitterCoordinates.width <= 1) {
            lineWidth = 7;
        }
        if (relSplitterCoordinates.height <= 1) {
            tarBounds.y -= lineWidth / 2 + lineWidth % 2;
            tarBounds.height = lineWidth;
        }
        if (relSplitterCoordinates.width <= 1) {
            tarBounds.x -= lineWidth / 2 + lineWidth % 2;
            tarBounds.width = lineWidth;
        }
        this.myReference.translateToAbsolute((Translatable)tarBounds);
        target.translateToRelative((Translatable)tarBounds);
        target.setBounds(tarBounds);
    }
}

