/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.locators;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.ExtendedGridLayoutManager;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ExtendedGridLocator
implements Locator {
    protected IFigure mContainer;
    protected int mOrientation;
    protected Point mCell;
    protected static final int TAR_SIZE = 5;
    protected static final int SQUARE_SIZE = 7;

    public ExtendedGridLocator(IFigure container, int orientation, Point cell) {
        this.mContainer = container;
        this.mOrientation = orientation;
        this.mCell = cell;
    }

    public void relocate(IFigure target) {
        ExtendedGridLayoutManager layoutManager = (ExtendedGridLayoutManager)this.mContainer.getLayoutManager();
        Rectangle containerBounds = this.mContainer.getBounds();
        Rectangle relSplitterCoordinates = layoutManager.getSplitterCoordinates(this.mOrientation, this.mCell);
        Rectangle tarBounds = relSplitterCoordinates.getCopy();
        tarBounds.translate(-1, -1);
        int lineWidth = 5;
        if (relSplitterCoordinates.height <= 1 && relSplitterCoordinates.width <= 1) {
            lineWidth = 7;
        }
        if (relSplitterCoordinates.height <= 1) {
            tarBounds.y -= lineWidth / 2 + lineWidth % 2;
            tarBounds.height = lineWidth;
        }
        if (relSplitterCoordinates.width <= 1) {
            tarBounds.x -= lineWidth / 2 + lineWidth % 2;
            tarBounds.width = lineWidth;
        }
        this.mContainer.translateToAbsolute((Translatable)tarBounds);
        target.translateToRelative((Translatable)tarBounds);
        target.setBounds(tarBounds);
    }
}

