/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts;

import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ViewLayoutManager
implements LayoutManager {
    public static final int LEFT_TOP = 0;
    public static final int TOP = 1;
    public static final int RIGHT_TOP = 2;
    public static final int LEFT = 3;
    public static final int CENTER = 4;
    public static final int RIGHT = 5;
    public static final int LEFT_BOTTOM = 6;
    public static final int BOTTOM = 7;
    public static final int RIGHT_BOTTOM = 8;
    private HashMap myConstraints = new HashMap();

    public Object getConstraint(IFigure figure) {
        return this.myConstraints.get(figure);
    }

    public Dimension getMinimumSize(IFigure parent) {
        return new Dimension(10, 10);
    }

    public Dimension getPreferredSize(IFigure parent) {
        return this.getMinimumSize(parent);
    }

    public Dimension getPreferredSize(IFigure parent, int wHint, int hHint) {
        return new Dimension(wHint, hHint);
    }

    public void invalidate() {
    }

    public void invalidate(IFigure child) {
    }

    public void layout(IFigure container) {
        Dimension parentSize = container.getClientArea().getSize();
        Rectangle pbounds = container.getClientArea();
        List children = container.getChildren();
        IFigure left = (IFigure)children.get(3);
        IFigure right = (IFigure)children.get(5);
        IFigure top = (IFigure)children.get(1);
        IFigure bottom = (IFigure)children.get(7);
        IFigure center = (IFigure)children.get(4);
        IFigure leftTop = (IFigure)children.get(0);
        IFigure rightTop = (IFigure)children.get(2);
        IFigure leftBottom = (IFigure)children.get(6);
        IFigure rightBottom = (IFigure)children.get(8);
        int widthOfCenter = pbounds.width - left.getMinimumSize().width - right.getMinimumSize().width;
        int heightOfCenter = pbounds.height - top.getMinimumSize().height - bottom.getMinimumSize().height;
        Rectangle leftTopBounds = new Rectangle(pbounds.getLocation(), new Dimension(left.getMinimumSize().width, top.getMinimumSize().height));
        Rectangle rightTopBounds = new Rectangle(pbounds.getLocation().translate(left.getMinimumSize().width + widthOfCenter, 0), new Dimension(right.getMinimumSize().width, top.getMinimumSize().height));
        Rectangle leftBottomBounds = new Rectangle(pbounds.getLocation().translate(0, top.getMinimumSize().height + heightOfCenter), new Dimension(left.getMinimumSize().width, bottom.getMinimumSize().height));
        Rectangle rightBottomBounds = new Rectangle(pbounds.getLocation().translate(left.getMinimumSize().width + widthOfCenter, top.getMinimumSize().height + heightOfCenter), new Dimension(right.getMinimumSize().width, bottom.getMinimumSize().height));
        Rectangle topBounds = new Rectangle(pbounds.getLocation().translate(left.getMinimumSize().width, 0), new Dimension(widthOfCenter, top.getMinimumSize().height));
        Rectangle leftBounds = new Rectangle(pbounds.getLocation().translate(0, top.getMinimumSize().height), new Dimension(left.getMinimumSize().width, heightOfCenter));
        Rectangle centerBounds = new Rectangle(pbounds.getLocation().translate(left.getMinimumSize().width, top.getMinimumSize().height), new Dimension(widthOfCenter, heightOfCenter));
        Rectangle rightBounds = new Rectangle(centerBounds.getTopRight(), new Dimension(right.getMinimumSize().width, heightOfCenter));
        Rectangle bottomBounds = new Rectangle(centerBounds.getBottomLeft(), new Dimension(widthOfCenter, bottom.getMinimumSize().height));
        leftTop.setBounds(leftTopBounds);
        rightTop.setBounds(rightTopBounds);
        leftBottom.setBounds(leftBottomBounds);
        rightBottom.setBounds(rightBottomBounds);
        left.setBounds(leftBounds);
        right.setBounds(rightBounds);
        top.setBounds(topBounds);
        bottom.setBounds(bottomBounds);
        center.setBounds(centerBounds);
    }

    public void remove(IFigure figure) {
        this.myConstraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object constraint) {
        this.myConstraints.put(figure, constraint);
    }
}

