/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.SplitLayoutManager;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class TLayoutManager
extends SplitLayoutManager {
    public static final String TOP_CONSTR = "TOP";
    public static final String BOTTOM_CONSTR = "BOTTOM";

    public TLayoutManager() {
    }

    public TLayoutManager(int orientation) {
        super(orientation);
    }

    public Object getConstraint(IFigure figure) {
        String result = (String)this.myConstraints.get(figure);
        if (result == null) {
            if (this.myConstraints.containsValue(TOP_CONSTR)) {
                return super.getConstraint(figure);
            }
            result = TOP_CONSTR;
            this.myConstraints.put(figure, result);
        }
        return result;
    }

    public void layout(IFigure container) {
        Dimension parentSize = container.getClientArea().getSize();
        parentSize.shrink(1, 1);
        Point offset = container.getClientArea().getLocation();
        if (this.mySashPoint.x == 0 && this.mySashPoint.y == 0) {
            this.mySashPoint = new Point(parentSize.width / 2, parentSize.height / 2);
        }
        Rectangle[] quarters = new Rectangle[]{new Rectangle(new Point(0, 0), this.mySashPoint), new Rectangle(new Point(this.mySashPoint.x, 0), new Point(parentSize.width, this.mySashPoint.y)), new Rectangle(this.mySashPoint, new Point(parentSize.width, parentSize.height)), new Rectangle(new Point(0, this.mySashPoint.y), new Point(this.mySashPoint.x, parentSize.height))};
        Iterator children = container.getChildren().iterator();
        while (children.hasNext()) {
            Rectangle bounds;
            IFigure f;
            block18: {
                String constr;
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                f = (IFigure)children.next();
                                constr = (String)this.getConstraint(f);
                                bounds = null;
                                if (!"LEFT".equals(constr)) break block17;
                                switch (this.myOrientation) {
                                    case 0: {
                                        bounds = quarters[3];
                                        break block18;
                                    }
                                    case 1: 
                                    case 2: {
                                        bounds = quarters[0];
                                        break block18;
                                    }
                                    case 3: {
                                        bounds = quarters[0].getUnion(quarters[3]);
                                        break block18;
                                    }
                                    default: {
                                        System.err.println("TLayout Unknown orientation: " + this.myOrientation);
                                        break;
                                    }
                                }
                                continue;
                            }
                            if (!"RIGHT".equals(constr)) break block19;
                            switch (this.myOrientation) {
                                case 0: {
                                    bounds = quarters[2];
                                    break block18;
                                }
                                case 2: 
                                case 3: {
                                    bounds = quarters[1];
                                    break block18;
                                }
                                case 1: {
                                    bounds = quarters[1].getUnion(quarters[2]);
                                    break block18;
                                }
                                default: {
                                    System.err.println("TLayout Unknown orientation: " + this.myOrientation);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (!TOP_CONSTR.equals(constr)) break block20;
                        bounds = quarters[0].getUnion(quarters[1]);
                        break block18;
                    }
                    if (!BOTTOM_CONSTR.equals(constr)) break block21;
                    switch (this.myOrientation) {
                        case 3: {
                            bounds = quarters[2];
                            break block18;
                        }
                        case 1: {
                            bounds = quarters[3];
                            break block18;
                        }
                        case 2: {
                            bounds = quarters[2].getUnion(quarters[3]);
                            break block18;
                        }
                        default: {
                            System.err.println("TLayout Unknown orientation: " + this.myOrientation);
                            break;
                        }
                    }
                    continue;
                }
                System.err.println("TLayout Unknown constraint: " + constr);
            }
            bounds.translate(offset);
            f.setBounds(bounds);
        }
    }

    public Rectangle getSplitterCoordinates(int orientation, Dimension dim) {
        if (orientation != this.myOrientation) {
            return super.getSplitterCoordinates(orientation, dim);
        }
        switch (orientation) {
            case 0: {
                return new Rectangle(this.mySashPoint.x, this.mySashPoint.y, 0, dim.height - this.mySashPoint.y);
            }
            case 3: {
                return new Rectangle(this.mySashPoint.x, this.mySashPoint.y, dim.width - this.mySashPoint.x, 0);
            }
            case 2: {
                return new Rectangle(this.mySashPoint.x, 0, 0, this.mySashPoint.y);
            }
            case 1: {
                return new Rectangle(0, this.mySashPoint.y, this.mySashPoint.x, 0);
            }
        }
        throw new IllegalStateException("Unknown orientation for TLayoutManager");
    }
}

