/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class SplitLayoutManager
implements LayoutManager {
    public static final int TOP_ORIENTATION = 0;
    public static final int RIGHT_ORIENTATION = 1;
    public static final int BOTTOM_ORIENTATION = 2;
    public static final int LEFT_ORIENTATION = 3;
    public static final String SASH_POINT_PROPERTY = "SashPoint";
    public static final String LEFT_CONSTR = "LEFT";
    public static final String RIGHT_CONSTR = "RIGHT";
    private static final int MIN_WIDTH = 5;
    private static final int MIN_HEIGHT = 5;
    protected Point mySashPoint = new Point(0, 0);
    protected int myOrientation;
    protected Map myConstraints = new HashMap();

    public SplitLayoutManager() {
        this(0);
    }

    public SplitLayoutManager(int orientation) {
        this.setOrientation(orientation);
    }

    public void setOrientation(int orientation) {
        this.myOrientation = orientation;
    }

    public int getOrientation() {
        return this.myOrientation;
    }

    public void setSashPoint(Point newSash) {
        this.mySashPoint = newSash;
        if (this.mySashPoint.x < 5) {
            this.mySashPoint.x = 5;
        }
        if (this.mySashPoint.y < 5) {
            this.mySashPoint.y = 5;
        }
    }

    public Point getSashPoint() {
        return this.mySashPoint;
    }

    public Object getConstraint(IFigure figure) {
        String result = (String)this.myConstraints.get(figure);
        if (result == null) {
            if (!this.myConstraints.containsValue(LEFT_CONSTR)) {
                result = LEFT_CONSTR;
            } else if (!this.myConstraints.containsValue(RIGHT_CONSTR)) {
                result = RIGHT_CONSTR;
            } else {
                throw new IllegalStateException("SplitLayoutManager got more than 2 figures");
            }
            this.myConstraints.put(figure, result);
        }
        return result;
    }

    public Dimension getMinimumSize(IFigure figure) {
        return new Dimension(5, 5);
    }

    public Dimension getPreferredSize(IFigure figure) {
        return this.getMinimumSize(figure);
    }

    public Dimension getPreferredSize(IFigure figure, int wHint, int hHint) {
        if (wHint > 5 && hHint > 5) {
            return new Dimension(wHint, hHint);
        }
        return this.getPreferredSize(figure);
    }

    public void invalidate() {
    }

    public void invalidate(IFigure figure) {
    }

    public void layout(IFigure container) {
        Dimension parentSize = container.getClientArea().getSize();
        parentSize.shrink(1, 1);
        Point offset = container.getClientArea().getLocation();
        if (this.mySashPoint.x == 0 && this.mySashPoint.y == 0) {
            this.mySashPoint = new Point(parentSize.width / 2, parentSize.height / 2);
        }
        Rectangle[] quarters = new Rectangle[]{new Rectangle(new Point(0, 0), this.mySashPoint), new Rectangle(new Point(this.mySashPoint.x, 0), new Point(parentSize.width, this.mySashPoint.y)), new Rectangle(this.mySashPoint, new Point(parentSize.width, parentSize.height)), new Rectangle(new Point(0, this.mySashPoint.y), new Point(this.mySashPoint.x, parentSize.height))};
        Iterator children = container.getChildren().iterator();
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            String constr = (String)this.getConstraint(f);
            Rectangle bounds = null;
            if (LEFT_CONSTR.equals(constr)) {
                bounds = quarters[this.myOrientation].getUnion(quarters[(this.myOrientation + 3) % 4]);
            } else if (RIGHT_CONSTR.equals(constr)) {
                bounds = quarters[(this.myOrientation + 1) % 4].getUnion(quarters[(this.myOrientation + 2) % 4]);
            } else {
                System.err.println("SplitLayoutManager<layout>: unknown constraint [" + constr + "]");
                continue;
            }
            bounds.translate(offset);
            f.setBounds(bounds);
        }
    }

    public void remove(IFigure figure) {
        this.myConstraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object constraint) {
        if (constraint instanceof String) {
            if (constraint.equals(this.myConstraints.get(figure))) {
                return;
            }
            if (this.myConstraints.containsValue(constraint)) {
                this.removeConstraintRegistration(constraint);
            }
            this.myConstraints.put(figure, constraint);
        }
    }

    private void removeConstraintRegistration(Object constraint) {
        Set keys = this.myConstraints.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Object figure = i.next();
            if (!this.myConstraints.get(figure).equals(constraint)) continue;
            this.myConstraints.remove(figure);
        }
    }

    public Rectangle getSplitterCoordinates(int orientation, Dimension dim) {
        if (orientation == 3 || orientation == 1) {
            return new Rectangle(0, this.mySashPoint.y, dim.width, 0);
        }
        if (orientation == 0 || orientation == 2) {
            return new Rectangle(this.mySashPoint.x, 0, 0, dim.height);
        }
        return new Rectangle(this.mySashPoint.x, this.mySashPoint.y, 0, 0);
    }
}

