/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class PlugLinearLayoutManager
implements LayoutManager {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    public static final int WIDTH_OF_PLUG = 15;
    public static final int HEIGHT_OF_PLUG = 8;
    public static final int SPACING = 2;
    private HashMap myConstraints = new HashMap();
    private boolean isVertical;

    public PlugLinearLayoutManager(int orientation) {
        this.isVertical = orientation == 1;
    }

    public Object getConstraint(IFigure figure) {
        Object result = this.myConstraints.get(figure);
        if (result == null || !(result instanceof String)) {
            int i = 0;
            while (this.myConstraints.containsValue(Integer.toString(++i))) {
            }
            result = Integer.toString(i);
            this.myConstraints.put(figure, result);
        }
        return result;
    }

    public Dimension getMinimumSize(IFigure parent) {
        if (this.isVertical) {
            return new Dimension(15, 8);
        }
        return new Dimension(8, 15);
    }

    public Dimension getPreferredSize(IFigure parent, int wHint, int hHint) {
        return new Dimension(wHint, hHint);
    }

    public Dimension getPreferredSize(IFigure parent) {
        return this.getMinimumSize(parent);
    }

    public void invalidate() {
    }

    public void invalidate(IFigure child) {
    }

    public void layout(IFigure container) {
        Dimension parentSize = container.getClientArea().getSize();
        Point offset = container.getClientArea().getLocation();
        Iterator children = container.getChildren().iterator();
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            String constr = (String)this.getConstraint(f);
            int intIndex = Integer.parseInt(constr);
            Rectangle bounds = this.calculateBoundsFor(intIndex);
            bounds.translate(offset);
            f.setBounds(bounds);
        }
    }

    public void remove(IFigure figure) {
        this.myConstraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object constraint) {
        if (constraint instanceof String) {
            this.myConstraints.put(figure, constraint);
        }
    }

    public Rectangle calculateBoundsFor(int index) {
        Rectangle bounds = new Rectangle(0, 0, 15, 15);
        if (this.isVertical) {
            bounds.y = index * 10;
            bounds.height = 8;
        } else {
            bounds.x = index * 10;
            bounds.width = 8;
        }
        return bounds;
    }

    public int calculateIndexFor(Point point) {
        if (this.isVertical) {
            return point.y / 10;
        }
        return point.x / 10;
    }

    public boolean isOccupied(int index) {
        return this.myConstraints.containsValue(Integer.toString(index));
    }
}

