/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class OrderedXYLayout
extends XYLayout {
    private int mDirection;
    public static final int DIRECTION_VERTICAL = 1;
    public static final int DIRECTION_HORIZONTAL = 2;

    public OrderedXYLayout(int direction) {
        this.mDirection = direction;
    }

    protected Dimension calculatePreferredSize(IFigure f) {
        return super.calculatePreferredSize(f);
    }

    public void layout(IFigure parent) {
        List children = parent.getChildren();
        int numberOfChildren = parent.getChildren().size();
        Point offset = this.getOrigin(parent);
        IFigure greatestChild = this.getGreatest(children);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IFigure f = (IFigure)iter.next();
            Rectangle bounds = (Rectangle)this.getConstraint(f);
            if (greatestChild != null) {
                bounds.setSize(greatestChild.getBounds().getSize());
            }
            if (bounds == null) continue;
            bounds = bounds.getTranslated(offset);
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension preferredSize = f.getPreferredSize();
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = preferredSize.height;
                }
            }
            f.setBounds(bounds);
        }
        if (children.size() > 1) {
            IFigure[] childrenArray = children.toArray(new IFigure[children.size()]);
            int dx = 0;
            int dy = 0;
            int j = 1;
            while (j < childrenArray.length) {
                IFigure child = childrenArray[j];
                Rectangle bounds = child.getBounds();
                IFigure previous = childrenArray[j - 1];
                Rectangle previousBounds = previous.getBounds();
                if (this.mDirection == 2) {
                    dx += previousBounds.width + 20;
                } else if (this.mDirection == 1) {
                    dy += previousBounds.height + 20;
                } else {
                    throw new IllegalArgumentException("Illegal argument for direction: " + this.mDirection);
                }
                child.setBounds(this.getGreatest(children).getBounds().getCopy().translate(dx, dy));
                ++j;
            }
        }
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
    }

    private IFigure getGreatest(List children) {
        Dimension greatest = new Dimension();
        if (children.size() == 0) {
            return null;
        }
        IFigure greatestFigure = (IFigure)children.get(0);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IFigure child = (IFigure)iter.next();
            if (!child.getBounds().getSize().greaterThan(greatest)) continue;
            greatest = child.getBounds().getSize();
            greatestFigure = child;
        }
        return greatestFigure;
    }
}

