/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.SplitLayoutManager;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class Grid2x2LayoutManager
extends SplitLayoutManager {
    public static final String BOTTOM_LEFT = "BOTTOM_LEFT";
    public static final String BOTTOM_RIGHT = "BOTTOM_RIGHT";

    public Grid2x2LayoutManager() {
    }

    public Grid2x2LayoutManager(int orientation) {
        super(orientation);
    }

    public Object getConstraint(IFigure figure) {
        String result = (String)this.myConstraints.get(figure);
        if (result == null) {
            if (!this.myConstraints.containsValue(BOTTOM_LEFT)) {
                result = BOTTOM_LEFT;
            } else if (!this.myConstraints.containsValue(BOTTOM_RIGHT)) {
                result = BOTTOM_RIGHT;
            } else {
                return super.getConstraint(figure);
            }
            this.myConstraints.put(figure, result);
        }
        return result;
    }

    public void layout(IFigure container) {
        Dimension parentSize = container.getClientArea().getSize();
        parentSize.shrink(1, 1);
        Point offset = container.getClientArea().getLocation();
        if (this.mySashPoint.x == 0 && this.mySashPoint.y == 0) {
            this.mySashPoint = new Point(parentSize.width / 2, parentSize.height / 2);
        }
        Rectangle[] quarters = new Rectangle[]{new Rectangle(new Point(0, 0), this.mySashPoint), new Rectangle(new Point(this.mySashPoint.x, 0), new Point(parentSize.width, this.mySashPoint.y)), new Rectangle(this.mySashPoint, new Point(parentSize.width, parentSize.height)), new Rectangle(new Point(0, this.mySashPoint.y), new Point(this.mySashPoint.x, parentSize.height))};
        Iterator children = container.getChildren().iterator();
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            String constr = (String)this.getConstraint(f);
            Rectangle bounds = null;
            if ("LEFT".equals(constr)) {
                bounds = quarters[this.myOrientation];
            } else if ("RIGHT".equals(constr)) {
                bounds = quarters[(this.myOrientation + 1) % 4];
            } else if (BOTTOM_RIGHT.equals(constr)) {
                bounds = quarters[(this.myOrientation + 2) % 4];
            } else if (BOTTOM_LEFT.equals(constr)) {
                bounds = quarters[(this.myOrientation + 3) % 4];
            } else {
                System.err.println("Grid2x2LayoutManager<layout>: unknown constraint [" + constr + "]");
                continue;
            }
            bounds.translate(offset);
            f.setBounds(bounds);
        }
    }
}

