/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class GenericGridLayoutManager
implements LayoutManager {
    private HashMap myConstraints = new HashMap();
    private int[] myCols;
    private int[] myRows;

    public GenericGridLayoutManager(int numOfRows, int numOfCols) {
        this.myRows = new int[numOfRows];
        this.myCols = new int[numOfCols];
    }

    public void initGrid(int[] rowHeights, int[] colWidths) {
        int i = 0;
        while (i < rowHeights.length) {
            this.myRows[i] = rowHeights[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < colWidths.length) {
            this.myCols[i2] = colWidths[i2];
            ++i2;
        }
    }

    public int getNumOfRows() {
        return this.myRows.length;
    }

    public int getNumOfCols() {
        return this.myCols.length;
    }

    public int getRowHeight(int row) {
        return this.myRows[row];
    }

    public int getColWidth(int col) {
        return this.myCols[col];
    }

    public void adjustRowHeight(int row, int dh) {
        if (row != this.myRows.length - 1) {
            int n = row + 1;
            this.myRows[n] = this.myRows[n] - dh;
        }
        int n = row;
        this.myRows[n] = this.myRows[n] + dh;
    }

    public void setRowHeight(int row, int height) {
        this.adjustRowHeight(row, height - this.myRows[row]);
    }

    public void adjustColWidth(int col, int dw) {
        if (col != this.myCols.length - 1) {
            int n = col + 1;
            this.myCols[n] = this.myCols[n] - dw;
        }
        int n = col;
        this.myCols[n] = this.myCols[n] + dw;
    }

    public void setColWidth(int col, int width) {
        this.adjustColWidth(col, width - this.myCols[col]);
    }

    public Rectangle getSplitterCoordinates(int orientation, int xpos, int ypos, Dimension dim) {
        if (orientation == 1) {
            int yPosition = 0;
            int i = 0;
            while (i <= xpos) {
                yPosition += this.myRows[i];
                ++i;
            }
            return new Rectangle(0, yPosition, dim.width, 0);
        }
        if (orientation == 0) {
            int xPosition = 0;
            int i = 0;
            while (i <= xpos) {
                xPosition += this.myCols[i];
                ++i;
            }
            return new Rectangle(xPosition, 0, 0, dim.height);
        }
        int xPosition = 0;
        int i = 0;
        while (i <= xpos) {
            xPosition += this.myCols[i];
            ++i;
        }
        int yPosition = 0;
        int i2 = 0;
        while (i2 <= ypos) {
            yPosition += this.myRows[i2];
            ++i2;
        }
        return new Rectangle(xPosition, yPosition, 0, 0);
    }

    public Object getConstraint(IFigure figure) {
        Object result = this.myConstraints.get(figure);
        if (result instanceof Point) {
            return result;
        }
        Point p = new Point(0, 0);
        int y = 0;
        while (y < this.myRows.length) {
            int x = 0;
            while (x < this.myCols.length) {
                p.x = x++;
                p.y = y;
                if (this.myConstraints.containsValue(p)) continue;
                this.myConstraints.put(figure, p);
                return p;
            }
            ++y;
        }
        throw new IllegalStateException("No space for relocating figure - all cells occupied, current grid size: " + this.myCols.length + "," + this.myRows.length);
    }

    public Dimension getMinimumSize(IFigure parent) {
        return new Dimension(10, 10);
    }

    public Dimension getPreferredSize(IFigure parent) {
        return this.getMinimumSize(parent);
    }

    public Dimension getPreferredSize(IFigure parent, int wHint, int hHint) {
        return new Dimension(wHint, hHint);
    }

    public void invalidate() {
    }

    public void invalidate(IFigure child) {
    }

    public void layout(IFigure container) {
        Dimension parentSize = container.getClientArea().getSize();
        parentSize.shrink(1, 1);
        Point offset = container.getClientArea().getLocation();
        Iterator children = container.getChildren().iterator();
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            Point constr = (Point)this.getConstraint(f);
            int x = constr.x;
            int y = constr.y;
            int width = this.myCols[x];
            int height = this.myRows[y];
            int prevWidth = 0;
            int i = 0;
            while (i < x) {
                prevWidth += this.myCols[i];
                ++i;
            }
            int prevHeight = 0;
            int i2 = 0;
            while (i2 < y) {
                prevHeight += this.myRows[i2];
                ++i2;
            }
            if (x == this.myCols.length - 1) {
                width = Math.max(0, parentSize.width - prevWidth);
            }
            if (y == this.myRows.length - 1) {
                height = Math.max(0, parentSize.height - prevHeight);
            }
            Dimension cellDim = new Dimension(width + 1, height + 1);
            Rectangle bounds = new Rectangle(offset, cellDim);
            bounds.translate(prevWidth, prevHeight);
            f.setBounds(bounds);
        }
    }

    public void remove(IFigure figure) {
        this.myConstraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object constraint) {
        StringTokenizer tokenizer;
        if (constraint instanceof Point) {
            this.myConstraints.put(figure, constraint);
        }
        if (constraint instanceof String && ((String)constraint).startsWith("cell") && (tokenizer = new StringTokenizer((String)constraint, "[,]")).countTokens() == 3) {
            String cell = tokenizer.nextToken();
            String sy = tokenizer.nextToken();
            String sx = tokenizer.nextToken();
            int x = Integer.parseInt(sx) - 1;
            int y = Integer.parseInt(sy) - 1;
            if (x < this.myCols.length && y < this.myRows.length) {
                this.myConstraints.put(figure, new Point(x, y));
            }
        }
    }
}

