/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts;

import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.ExtendedGridLayoutConstraints;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ExtendedGridLayoutManager
implements LayoutManager {
    private IFigure mContainer;
    private Dimension[][] mCells = new Dimension[0][0];
    private Rectangle[][] mCellSizes = new Rectangle[0][0];
    private Point[][] mCellPoints = new Point[0][0];
    private int mNumOfCols = 0;
    private int mNumOfRows = 0;
    private Map mConstraints = new Hashtable();
    private Map mFigureForCell = new Hashtable();
    private Map mSpannedCells = new Hashtable();
    private Map mSpanningCells = new Hashtable();
    private Map mSplittersForCell = new Hashtable();
    private boolean mAreSplittersBuilt = false;
    private static final Dimension ZERO_DIMENSION = new Dimension();
    private static final List EMPTY_LIST = new Vector();
    public static final int MINIMAL_CELL_WIDTH = 10;
    public static final int MINIMAL_CELL_HEIGTH = 10;

    public ExtendedGridLayoutManager(int numOfRows, int numOfCols) {
        this.mNumOfCols = numOfCols;
        this.mNumOfRows = numOfRows;
        this.mCells = new Dimension[numOfRows][numOfCols];
        this.mCellPoints = new Point[numOfRows][numOfCols];
        this.mCellSizes = new Rectangle[numOfRows][numOfCols];
    }

    public void initGrid(Dimension[][] cellSizes) {
        this.mCells = cellSizes;
        int y = 0;
        while (y < this.mCellPoints.length) {
            int x = 0;
            while (x < this.mCellPoints[y].length) {
                this.mCellPoints[y][x] = new Point(x + 1, y + 1);
                if (this.mCells[y][x] == null) {
                    this.mCells[y][x] = new Dimension();
                }
                this.mCellSizes[y][x] = new Rectangle(Point.SINGLETON, this.mCells[y][x]);
                ++x;
            }
            ++y;
        }
    }

    public Object getConstraint(IFigure figure) {
        Object result = this.mConstraints.get(figure);
        if (result instanceof ExtendedGridLayoutConstraints) {
            return result;
        }
        return null;
    }

    public void layout(IFigure container) {
        this.mContainer = container;
        this.layoutCells(container);
    }

    public Dimension getMinimumSize(IFigure parent) {
        return new Dimension(50, 50);
    }

    public Dimension getPreferredSize(IFigure parent) {
        if (this.mContainer != null && this.mContainer.getBounds().getSize().equals(this.getMinimumSize((IFigure)parent).width, this.getMinimumSize((IFigure)parent).height)) {
            return this.mContainer.getBounds().getSize();
        }
        return this.getMinimumSize(parent);
    }

    public Dimension getPreferredSize(IFigure parent, int wHint, int hHint) {
        return new Dimension(wHint, hHint);
    }

    public void invalidate() {
    }

    public void invalidate(IFigure child) {
    }

    public void setConstraint(IFigure figure, Object constraint) {
        if (constraint instanceof ExtendedGridLayoutConstraints) {
            ExtendedGridLayoutConstraints constr = (ExtendedGridLayoutConstraints)constraint;
            this.mConstraints.put(figure, constraint);
            Point cellPoint = this.translateToCellPoint(((ExtendedGridLayoutConstraints)constraint).getCell());
            this.mFigureForCell.put(cellPoint, figure);
            this.mAreSplittersBuilt = false;
            this.buildSpanMaps(constr);
        }
    }

    public void remove(IFigure figure) {
        this.mConstraints.remove(figure);
    }

    public int getNumOfRows() {
        return this.mNumOfRows;
    }

    public int getNumOfCols() {
        return this.mNumOfCols;
    }

    public int getHeight(Point cell) {
        return this.mCells[cell.y - 1][cell.x - 1].height;
    }

    public int getWidth(Point cell) {
        return this.mCells[cell.y - 1][cell.x - 1].width;
    }

    public void setHeight(Point cell, int height, int orientation) {
        Point cellPt = this.translateToCellPoint(cell);
        Splitter splitter = this.getSplitter(cellPt, orientation);
        if (splitter != null) {
            Point[] cellsTopLeft = splitter.getAdjacentCellsTopLeft(1);
            Point[] cellsBottomRight = splitter.getAdjacentCellsBottomRight(1);
            int referenceHeight = this.mCells[splitter.getCell().y - 1][splitter.getCell().x - 1].height;
            this.adjustHeight(cell, cellsTopLeft, cellsBottomRight, referenceHeight - height);
        }
    }

    public void setWidth(Point cell, int width, int orientation) {
        Point cellPt = this.translateToCellPoint(cell);
        Splitter splitter = this.getSplitter(cellPt, orientation);
        if (splitter != null) {
            Point[] cellsTopLeft = splitter.getAdjacentCellsTopLeft(0);
            Point[] cellsBottomRight = splitter.getAdjacentCellsBottomRight(0);
            int referenceWidth = this.mCells[splitter.getCell().y - 1][splitter.getCell().x - 1].width;
            this.adjustWidth(cell, cellsTopLeft, cellsBottomRight, referenceWidth - width);
        }
    }

    private void adjustHeight(Point referenceCell, Point[] cellsTopLeft, Point[] cellsBottomRight, int dh) {
        Point cell;
        int i;
        if (dh == 0) {
            return;
        }
        if (dh > 0) {
            if (this.mCells[referenceCell.y - 1][referenceCell.x - 1].height - dh < 10) {
                return;
            }
        } else {
            i = 0;
            while (i < cellsBottomRight.length) {
                cell = cellsBottomRight[i];
                if (!this.isCellSpanned(cell) && this.mCells[cell.y - 1][cell.x - 1].height + dh < 10) {
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < cellsTopLeft.length) {
            cell = cellsTopLeft[i];
            this.mCells[cell.y - 1][cell.x - 1].height -= dh;
            ++i;
        }
        int i2 = 0;
        while (i2 < cellsBottomRight.length) {
            Point cell2 = cellsBottomRight[i2];
            this.mCells[cell2.y - 1][cell2.x - 1].height += dh;
            ++i2;
        }
    }

    private void adjustWidth(Point referenceCell, Point[] cellsTopLeft, Point[] cellsBottomRight, int dw) {
        Point cell;
        int i;
        if (dw == 0) {
            return;
        }
        if (dw > 0) {
            if (this.mCells[referenceCell.y - 1][referenceCell.x - 1].width - dw < 10) {
                return;
            }
        } else {
            i = 0;
            while (i < cellsBottomRight.length) {
                cell = cellsBottomRight[i];
                if (!this.isCellSpanned(cell) && this.mCells[cell.y - 1][cell.x - 1].width + dw < 10) {
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < cellsTopLeft.length) {
            cell = cellsTopLeft[i];
            this.mCells[cell.y - 1][cell.x - 1].width -= dw;
            ++i;
        }
        int i2 = 0;
        while (i2 < cellsBottomRight.length) {
            Point cell2 = cellsBottomRight[i2];
            this.mCells[cell2.y - 1][cell2.x - 1].width += dw;
            ++i2;
        }
    }

    public Rectangle getSplitterCoordinates(int orientation, Point cell) {
        int x = cell.x - 1;
        int y = cell.y - 1;
        Vector results = new Vector();
        List splitters = (List)this.mSplittersForCell.get(this.mCellPoints[y][x]);
        IFigure contentPane = (IFigure)this.mFigureForCell.values().iterator().next();
        Point parentLocation = contentPane.getParent().getClientArea().getLocation();
        Iterator iter = splitters.iterator();
        while (iter.hasNext()) {
            Splitter splitter = (Splitter)iter.next();
            if (splitter.getOrientation() != orientation) continue;
            int xPosition = 0;
            int yPosition = 0;
            int height = 0;
            int width = 0;
            int i = 0;
            while (i < y) {
                yPosition += this.mCells[i][x].height;
                ++i;
            }
            int i2 = 0;
            while (i2 < x) {
                xPosition += this.mCells[y][i2].width;
                ++i2;
            }
            if (splitter.getOrientation() == 1) {
                yPosition += this.mCells[y][x].height;
                width = this.mCells[y][x].width;
                if (splitter.getSpan() > 1) {
                    width += this.sumCellWidths(x + 1, x + splitter.getSpan() - 1, y);
                }
            } else if (splitter.getOrientation() == 0) {
                xPosition += this.mCells[y][x].width;
                height = this.mCells[y][x].height;
                if (splitter.getSpan() > 1) {
                    height += this.sumCellHeights(y + 1, y + splitter.getSpan() - 1, x);
                }
            } else if (splitter.getOrientation() == -1) {
                yPosition += this.mCells[y][x].height;
                xPosition += this.mCells[y][x].width;
            } else {
                throw new IllegalArgumentException("Wrong orientation for splitter: " + orientation);
            }
            Rectangle splitterBounds = new Rectangle(xPosition, yPosition, width, height).translate(parentLocation);
            if (TsmodelWebDynproPlugin.isDataViewDebugging()) {
                System.out.println("ExtendedGridLayoutManager.getSplitterCoordinates(): ");
                System.out.println("\tcreated splitter handle for cell (" + cell.x + ", " + cell.y + "): " + splitterBounds.getTopLeft() + ", " + splitterBounds.getBottomRight() + ", " + splitterBounds.getSize());
            }
            return splitterBounds;
        }
        return null;
    }

    public Splitter[] getSplitters() {
        Vector splitterList = new Vector();
        Iterator iter = this.mSplittersForCell.values().iterator();
        while (iter.hasNext()) {
            List splitters = (List)iter.next();
            splitterList.addAll(splitters);
        }
        return splitterList.toArray(new Splitter[splitterList.size()]);
    }

    public Point getCellForFigure(IFigure figure) {
        Iterator iter = this.mConstraints.keySet().iterator();
        while (iter.hasNext()) {
            Object figureObject = iter.next();
            if (!figure.equals(figureObject)) continue;
            ExtendedGridLayoutConstraints constr = (ExtendedGridLayoutConstraints)this.mConstraints.get(figureObject);
            return constr.getCell();
        }
        return null;
    }

    public boolean isCellSpanned(int x, int y) {
        return this.mSpannedCells.containsKey(this.mCellPoints[y][x]);
    }

    public boolean isCellSpanned(Point pt) {
        return this.mSpannedCells.containsKey(this.translateToCellPoint(pt));
    }

    public boolean isCellSpanned(int x, int y, int spanDirection) {
        Object constraintObject;
        Object figureObject;
        Object spanningCellObject = this.mSpannedCells.get(this.mCellPoints[y][x]);
        if (spanningCellObject != null && (figureObject = this.mFigureForCell.get(spanningCellObject)) != null && (constraintObject = this.mConstraints.get(figureObject)) != null) {
            ExtendedGridLayoutConstraints constr = (ExtendedGridLayoutConstraints)constraintObject;
            return constr.getSpanDirection() == spanDirection;
        }
        return false;
    }

    public boolean isSpanningCell(int x, int y) {
        Object constraintObject;
        Object figureObject = this.mFigureForCell.get(this.mCellPoints[y][x]);
        if (figureObject != null && (constraintObject = this.mConstraints.get(figureObject)) != null) {
            return ((ExtendedGridLayoutConstraints)constraintObject).getSpanCells() > 1;
        }
        return false;
    }

    public boolean isSpanningCell(Point cell) {
        return this.isSpanningCell(cell.x - 1, cell.y - 1);
    }

    public boolean isSpanningCell(Point cell, int spanDirection) {
        return this.isSpanningCell(cell.x - 1, cell.y - 1, spanDirection);
    }

    public boolean isSpanningCell(int x, int y, int spanDirection) {
        Object constraintObject;
        Object figureObject = this.mFigureForCell.get(this.mCellPoints[y][x]);
        if (figureObject != null && (constraintObject = this.mConstraints.get(figureObject)) != null) {
            ExtendedGridLayoutConstraints constr = (ExtendedGridLayoutConstraints)constraintObject;
            return constr.getSpanCells() > 1 && constr.getSpanDirection() == spanDirection;
        }
        return false;
    }

    private int getCellSpan(Point cell, int direction) {
        ExtendedGridLayoutConstraints constr;
        Object constraintObject;
        Object figureObject = this.mFigureForCell.get(this.translateToCellPoint(cell));
        if (figureObject != null && (constraintObject = this.mConstraints.get(figureObject)) != null && (constr = (ExtendedGridLayoutConstraints)constraintObject).getSpanDirection() == direction) {
            return constr.getSpanCells();
        }
        return -1;
    }

    private void layoutCells(IFigure container) {
        if (!this.mAreSplittersBuilt) {
            this.buildSplitterMaps();
            this.mAreSplittersBuilt = true;
        }
        Dimension parentSize = container.getClientArea().getSize();
        int y = 0;
        while (y < this.mCells.length) {
            int x = 0;
            while (x < this.mCells[y].length) {
                IFigure f;
                Object constraintObject;
                Object figureObject = this.mFigureForCell.get(this.mCellPoints[y][x]);
                if (figureObject != null && (constraintObject = this.getConstraint(f = (IFigure)figureObject)) instanceof ExtendedGridLayoutConstraints) {
                    ExtendedGridLayoutConstraints constr = (ExtendedGridLayoutConstraints)constraintObject;
                    int width = this.mCells[y][x].width;
                    int height = this.mCells[y][x].height;
                    int spanDirection = constr.getSpanDirection();
                    int spanCells = constr.getSpanCells();
                    Point lastCell = constr.getCell();
                    if (spanDirection > -1 && spanCells > 1) {
                        int i = 1;
                        while (i < spanCells) {
                            if (spanDirection == 1) {
                                height += this.mCells[y + i][x].height;
                                lastCell = this.mCellPoints[y + i][x];
                            } else if (spanDirection == 2) {
                                width += this.mCells[y][x + i].width;
                                lastCell = this.mCellPoints[y][x + i];
                            } else {
                                throw new IllegalArgumentException("Illegal argument for span direction constraint: " + spanDirection);
                            }
                            ++i;
                        }
                    }
                    this.adjustCellsAlongSplitter(this.mCellPoints[y][x]);
                    int prevWidth = 0;
                    int i = 0;
                    while (i < x) {
                        prevWidth += this.mCells[y][i].width;
                        ++i;
                    }
                    int prevHeight = 0;
                    int i2 = 0;
                    while (i2 < y) {
                        prevHeight += this.mCells[i2][x].height;
                        ++i2;
                    }
                    if (x == this.mNumOfCols - 1 || lastCell.x - 1 == this.mNumOfCols - 1) {
                        width = Math.max(0, parentSize.width - prevWidth);
                    }
                    if (y == this.mNumOfRows - 1 || lastCell.y - 1 == this.mNumOfRows - 1) {
                        height = Math.max(0, parentSize.height - prevHeight);
                    }
                    this.mCells[y][x] = new Dimension(width, height);
                    Point parentLocation = container.getClientArea().getLocation();
                    Point offset = new Point(prevWidth, prevHeight);
                    Rectangle bounds = new Rectangle(offset.x, offset.y, width + 1, height + 1);
                    bounds.translate(parentLocation);
                    f.setBounds(bounds);
                    this.mCellSizes[y][x] = new Rectangle(f.getBounds().getLocation(), this.mCells[y][x]);
                    if (TsmodelWebDynproPlugin.isDataViewDebugging()) {
                        System.out.println("ExtendedGridLayoutManager.layoutCells(): ");
                        System.out.println("\tsingle cell (" + constr.getCell().x + ", " + constr.getCell().y + "): " + f.getBounds().getTopLeft() + ", " + f.getBounds().getBottomRight() + ", " + f.getBounds().getSize());
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void adjustCellsAlongSplitter(Point cell) {
        List splitters = (List)this.mSplittersForCell.get(this.translateToCellPoint(cell));
        Iterator iter = splitters.iterator();
        while (iter.hasNext()) {
            Splitter splitter = (Splitter)iter.next();
            if (splitter.getSpan() <= 1) continue;
            int orientation = splitter.getOrientation();
            Point[] cells = splitter.getAdjacentCellsTopLeft(orientation);
            int i = 0;
            while (i < cells.length) {
                Point adjacentCell = cells[i];
                if (!adjacentCell.equals((Object)cell)) {
                    if (orientation == 1) {
                        this.mCells[adjacentCell.y - 1][adjacentCell.x - 1] = new Dimension(this.mCells[adjacentCell.y - 1][adjacentCell.x - 1].width, this.mCells[cell.y - 1][cell.x - 1].height);
                    } else if (orientation == 0) {
                        this.mCells[adjacentCell.y - 1][adjacentCell.x - 1] = new Dimension(this.mCells[cell.y - 1][cell.x - 1].width, this.mCells[adjacentCell.y - 1][adjacentCell.x - 1].height);
                    }
                }
                ++i;
            }
        }
    }

    private void buildSpanMaps(ExtendedGridLayoutConstraints constr) {
        int spanDirection = constr.getSpanDirection();
        int spanCells = constr.getSpanCells();
        int x = constr.getCell().x - 1;
        int y = constr.getCell().y - 1;
        if (spanDirection > -1 && spanCells > 1) {
            Vector<Point> spannedCells = new Vector<Point>();
            Point spanningCell = this.mCellPoints[y][x];
            int i = 1;
            while (i < spanCells) {
                Point spannedCell;
                if (spanDirection == 1) {
                    spannedCell = this.mCellPoints[y + i][x];
                } else if (spanDirection == 2) {
                    spannedCell = this.mCellPoints[y][x + i];
                } else {
                    throw new IllegalArgumentException("Illegal argument for span direction constraint: " + spanDirection);
                }
                this.mSpannedCells.put(spannedCell, spanningCell);
                spannedCells.add(spannedCell);
                ++i;
            }
            this.mSpanningCells.put(spanningCell, spannedCells);
        }
    }

    private void buildSplitterMaps() {
        Iterator iter = this.mConstraints.values().iterator();
        while (iter.hasNext()) {
            ExtendedGridLayoutConstraints constr = (ExtendedGridLayoutConstraints)iter.next();
            int spanDirection = constr.getSpanDirection();
            int spanCells = constr.getSpanCells();
            int x = constr.getCell().x - 1;
            int y = constr.getCell().y - 1;
            if (spanDirection > -1 && spanCells > 1) {
                Vector<Splitter> splitters;
                Vector spannedCells = new Vector();
                Point spanningCell = this.mCellPoints[y][x];
                Point spannedCell = null;
                int i = 1;
                while (i < spanCells) {
                    splitters = new Vector();
                    if (spanDirection == 1) {
                        spannedCell = this.mCellPoints[y + i][x];
                    } else if (spanDirection == 2) {
                        spannedCell = this.mCellPoints[y][x + i];
                    } else {
                        throw new IllegalArgumentException("Illegal argument for span direction constraint: " + spanDirection);
                    }
                    if (!(this.isEnclosedInSpan(spanningCell, constr, spannedCell) || this.isRightBorderCell(spannedCell) || this.isBottomBorderCell(spannedCell))) {
                        splitters.add(new Splitter(spannedCell, spanDirection == 1 ? 1 : 0, -1));
                    }
                    if (this.areAllNeighboursSpanned(spannedCell) || !this.isBorderCell(spanningCell)) {
                        // empty if block
                    }
                    this.mSplittersForCell.put(spannedCell, splitters);
                    ++i;
                }
                splitters = new Vector<Splitter>();
                if (!this.isRightBorderCell(spanningCell) && !this.isBottomBorderCell(spanningCell)) {
                    splitters.add(new Splitter(spanningCell, spanDirection == 1 ? 0 : 1, spanCells));
                }
                this.mSplittersForCell.put(spanningCell, splitters);
                continue;
            }
            Point cellPoint = this.mCellPoints[y][x];
            Vector<Splitter> splitters = new Vector<Splitter>();
            if (!this.isRightBorderCell(cellPoint) && !this.isCellSpanned(this.rightNeighbour(cellPoint))) {
                splitters.add(new Splitter(cellPoint, 0, this.getCellSpan(this.rightNeighbour(cellPoint), 1)));
            }
            if (!this.isBottomBorderCell(cellPoint) && !this.isCellSpanned(this.bottomNeighbour(cellPoint))) {
                splitters.add(new Splitter(cellPoint, 1, this.getCellSpan(this.bottomNeighbour(cellPoint), 2)));
            }
            if (this.areAllNeighboursSpanned(cellPoint) || !this.isBorderCell(cellPoint)) {
                // empty if block
            }
            this.mSplittersForCell.put(cellPoint, splitters);
        }
        Iterator iter2 = this.mSplittersForCell.values().iterator();
        while (iter2.hasNext()) {
            List splitterList = (List)iter2.next();
            Iterator iterator = splitterList.iterator();
            while (iterator.hasNext()) {
                Splitter splitter = (Splitter)iterator.next();
                this.setAdjacentCells(splitter);
            }
        }
    }

    private Point translateToCellPoint(Point pt) {
        return this.mCellPoints[pt.y - 1][pt.x - 1];
    }

    private boolean isRightBorderCell(Point pt) {
        return pt.x >= this.mNumOfCols;
    }

    private boolean isBottomBorderCell(Point pt) {
        return pt.y >= this.mNumOfRows;
    }

    private boolean isLeftBorderCell(Point pt) {
        return pt.x <= 1;
    }

    private boolean isTopBorderCell(Point pt) {
        return pt.y <= 1;
    }

    private boolean isBorderCell(Point cell) {
        return this.isRightBorderCell(cell) || this.isBottomBorderCell(cell) || this.isLeftBorderCell(cell) || this.isTopBorderCell(cell);
    }

    private Point rightNeighbour(Point pt) {
        if (!this.isRightBorderCell(pt)) {
            return this.mCellPoints[pt.y - 1][pt.x];
        }
        return null;
    }

    private List rightNeighbours(Point cell, int span) {
        Vector<Point> results = new Vector<Point>();
        if (!this.isRightBorderCell(cell)) {
            int i = cell.y - 1;
            while (i < cell.y + span - 1) {
                results.add(this.mCellPoints[i][cell.x]);
                ++i;
            }
        }
        return results;
    }

    private Point leftNeighbour(Point pt) {
        if (!this.isLeftBorderCell(pt)) {
            return this.mCellPoints[pt.y - 1][pt.x - 2];
        }
        return null;
    }

    private List leftNeighbours(Point cell, int span) {
        Vector<Point> results = new Vector<Point>();
        int i = cell.y - 1;
        while (i < cell.y + span - 1) {
            results.add(this.mCellPoints[i][cell.x - 1]);
            ++i;
        }
        return results;
    }

    private Point topNeighbour(Point pt) {
        if (!this.isTopBorderCell(pt)) {
            return this.mCellPoints[pt.y - 2][pt.x - 1];
        }
        return null;
    }

    private List topNeighbours(Point cell, int span) {
        Vector<Point> results = new Vector<Point>();
        int i = cell.x - 1;
        while (i < cell.x + span - 1) {
            results.add(this.mCellPoints[cell.y - 1][i]);
            ++i;
        }
        return results;
    }

    private Point bottomNeighbour(Point pt) {
        if (!this.isBottomBorderCell(pt)) {
            return this.mCellPoints[pt.y][pt.x - 1];
        }
        return null;
    }

    private List bottomNeighbours(Point cell, int span) {
        Vector<Point> results = new Vector<Point>();
        if (!this.isBottomBorderCell(cell)) {
            int i = cell.x - 1;
            while (i < cell.x + span - 1) {
                results.add(this.mCellPoints[cell.y][i]);
                ++i;
            }
        }
        return results;
    }

    private boolean isEnclosedInSpan(Point spanningCell, ExtendedGridLayoutConstraints constraint, Point spannedCell) {
        if (constraint.getSpanDirection() == 1) {
            return spannedCell.y < spanningCell.y + constraint.getSpanCells() - 1;
        }
        if (constraint.getSpanDirection() == 2) {
            return spannedCell.x < spanningCell.x + constraint.getSpanCells() - 1;
        }
        return false;
    }

    private boolean areAllNeighboursSpanned(Point cell) {
        Vector<Point> neighbours = new Vector<Point>();
        if (!this.isRightBorderCell(cell)) {
            neighbours.add(this.mCellPoints[cell.y - 1][cell.x]);
        }
        if (!this.isBottomBorderCell(cell)) {
            neighbours.add(this.mCellPoints[cell.y][cell.x - 1]);
        }
        if (!this.isRightBorderCell(cell) && !this.isBottomBorderCell(cell)) {
            neighbours.add(this.mCellPoints[cell.y][cell.x]);
        }
        boolean areNeighboursSpanned = true;
        Iterator iter = neighbours.iterator();
        while (iter.hasNext()) {
            Point cellPoint = (Point)iter.next();
            areNeighboursSpanned &= this.isCellSpanned(cellPoint);
        }
        return areNeighboursSpanned;
    }

    private void setAdjacentCells(Splitter splitter) {
        HashSet results = new HashSet();
        Point cellPoint = this.translateToCellPoint(splitter.getCell());
        int orientation = splitter.getOrientation();
        int span = splitter.getSpan();
        if (span == -1) {
            span = 1;
        }
        if (orientation == 0) {
            results.addAll(this.rightNeighbours(cellPoint, span));
            results.addAll(this.leftNeighbours(cellPoint, span));
        } else if (orientation == 1) {
            results.addAll(this.bottomNeighbours(cellPoint, span));
            results.addAll(this.topNeighbours(cellPoint, span));
        } else if (orientation == -1) {
            results.addAll(this.rightNeighbours(cellPoint, span));
            results.addAll(this.leftNeighbours(cellPoint, span));
            results.add(this.bottomNeighbours(cellPoint, span));
            results.add(this.topNeighbours(cellPoint, span));
        }
        results.add(cellPoint);
        splitter.setAdjacentCells(Arrays.asList(results.toArray()));
    }

    private List expandCellToSpan(Point cell, int direction) {
        Vector<Point> results = new Vector<Point>();
        if (this.isSpanningCell(cell, direction)) {
            results.addAll((List)this.mSpanningCells.get(this.translateToCellPoint(cell)));
        } else {
            results.add(cell);
        }
        return results;
    }

    private Splitter getSplitter(Point cellPoint, int orientation) {
        List splitters = (List)this.mSplittersForCell.get(cellPoint);
        Iterator iter = splitters.iterator();
        while (iter.hasNext()) {
            Splitter splitter = (Splitter)iter.next();
            if (splitter.getOrientation() != orientation) continue;
            return splitter;
        }
        return null;
    }

    private int sumCellWidths(int fromCol, int toCol, int row) {
        int sum = 0;
        int i = fromCol;
        while (i <= toCol) {
            sum += this.mCells[row][i].width;
            ++i;
        }
        return sum;
    }

    private int sumCellHeights(int fromRow, int toRow, int col) {
        int sum = 0;
        int i = fromRow;
        while (i <= toRow) {
            sum += this.mCells[i][col].height;
            ++i;
        }
        return sum;
    }

    public class Splitter {
        private Point mCell;
        private int mOrientation;
        private int mSpan;
        private List mAdjacentCells = new Vector();

        public Splitter(Point cell, int orientation, int span) {
            this.mCell = cell;
            this.mOrientation = orientation;
            this.mSpan = span;
        }

        public void setAdjacentCells(List adjacentCells) {
            this.mAdjacentCells = adjacentCells;
        }

        public Point getCell() {
            return this.mCell;
        }

        public int getOrientation() {
            return this.mOrientation;
        }

        public int getSpan() {
            return this.mSpan;
        }

        public Point[] getAdjacentCellsTopLeft(int orientation) {
            Vector<Point> result;
            block3: {
                block2: {
                    result = new Vector<Point>();
                    if (orientation != 0) break block2;
                    Iterator iter = this.mAdjacentCells.iterator();
                    while (iter.hasNext()) {
                        Point cell = (Point)iter.next();
                        if (cell.x != this.mCell.x) continue;
                        result.add(cell);
                    }
                    break block3;
                }
                if (orientation != 1) break block3;
                Iterator iter = this.mAdjacentCells.iterator();
                while (iter.hasNext()) {
                    Point cell = (Point)iter.next();
                    if (cell.y != this.mCell.y) continue;
                    result.add(cell);
                }
            }
            return result.toArray(new Point[result.size()]);
        }

        public Point[] getAdjacentCellsBottomRight(int orientation) {
            Vector<Point> result;
            block3: {
                block2: {
                    result = new Vector<Point>();
                    if (orientation != 0) break block2;
                    Iterator iter = this.mAdjacentCells.iterator();
                    while (iter.hasNext()) {
                        Point cell = (Point)iter.next();
                        if (cell.x != this.mCell.x + 1) continue;
                        result.add(cell);
                    }
                    break block3;
                }
                if (orientation != 1) break block3;
                Iterator iter = this.mAdjacentCells.iterator();
                while (iter.hasNext()) {
                    Point cell = (Point)iter.next();
                    if (cell.y != this.mCell.y + 1) continue;
                    result.add(cell);
                }
            }
            return result.toArray(new Point[result.size()]);
        }

        public String toString() {
            StringBuffer str = new StringBuffer("splitter for cell (" + this.mCell.x + ", " + this.mCell.y + "), orientation: " + this.mOrientation + "\n");
            Iterator iter = this.mAdjacentCells.iterator();
            while (iter.hasNext()) {
                str.append("\t");
                str.append(iter.next());
                str.append("\n");
            }
            return str.toString();
        }
    }
}

