/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts;

import org.eclipse.draw2d.geometry.Point;

public class ExtendedGridLayoutConstraints {
    protected Point mCell;
    protected int mSpanCells;
    protected int mSpanDirection;
    public static final int SPAN_DIRECTION_VERTICAL = 1;
    public static final int SPAN_DIRECTION_HORIZONTAL = 2;

    public ExtendedGridLayoutConstraints(Point cell) {
        this(cell, -1, -1);
    }

    public ExtendedGridLayoutConstraints(int cellX, int cellY) {
        this(new Point(cellX, cellY), -1, -1);
    }

    public ExtendedGridLayoutConstraints(int cellX, int cellY, int spanCells, int spanDirection) {
        this(new Point(cellX, cellY), spanCells, spanDirection);
    }

    public ExtendedGridLayoutConstraints(Point cell, int spanCells, int spanDirection) {
        this.mCell = cell;
        this.mSpanCells = spanCells;
        this.mSpanDirection = spanDirection;
    }

    public Point getCell() {
        return this.mCell;
    }

    public int getSpanDirection() {
        return this.mSpanDirection;
    }

    public int getSpanCells() {
        return this.mSpanCells;
    }

    public int getInvertedSpanDirection() {
        if (this.mSpanDirection == 2) {
            return 1;
        }
        if (this.mSpanDirection == 1) {
            return 2;
        }
        return -1;
    }

    public String toString() {
        String direction = "unknown";
        if (this.mSpanDirection == 2) {
            direction = "horizontal";
        } else if (this.mSpanDirection == 1) {
            direction = "vertical";
        }
        return "Cell (" + this.mCell.x + ", " + this.mCell.y + "), spanned cells: " + this.mSpanCells + ", span direction: " + direction;
    }
}

