/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.handles;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.handles.SplitterHandle;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.trackers.ExtendedGridSplitterTracker;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;

public class ExtendedGridSplitterHandle
extends SplitterHandle {
    private Point mCell;
    private int mOrientation;

    public ExtendedGridSplitterHandle(GraphicalEditPart owner, Locator loc, int orientation, Point cell) {
        super(owner, loc, ExtendedGridSplitterHandle.getDirection(orientation));
        this.mCell = cell;
        this.mOrientation = orientation;
    }

    public void paintFigure(Graphics g) {
        this.paintBorder(g);
    }

    protected void paintBorder(Graphics g) {
        Rectangle r = this.getBounds();
        r.shrink(1, 1);
        try {
            g.clipRect(this.getOwnerFigure().getBounds());
            g.setBackgroundColor(ColorConstants.black);
            g.fillRectangle(r);
            g.setForegroundColor(ColorConstants.white);
            g.drawRectangle(r);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            r.expand(1, 1);
            throw throwable;
        }
        r.expand(1, 1);
    }

    protected DragTracker createDragTracker() {
        return new ExtendedGridSplitterTracker(this.mOrientation, ExtendedGridSplitterHandle.getDirection(this.mOrientation), this.mCell);
    }

    private static int getDirection(int orientation) {
        if (orientation == 0) {
            return 24;
        }
        if (orientation == 1) {
            return 5;
        }
        if (orientation == -1) {
            return 0;
        }
        throw new IllegalArgumentException("Wrong orientation: " + orientation);
    }
}

