/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.figures;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.editpolicies.GenericGridEditPolicy;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.figures.AbstractFigureWithProperties;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.GenericGridLayoutManager;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.EntityEnumeration;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;

public class GenericGridFigure
extends AbstractFigureWithProperties {
    private static final String EDIT_POLICY = "GENERIC_GRID_EDIT_POLICY";
    private static final String DEFAULT_SIZE_PROPERTY = "40";

    public GenericGridFigure(EditPart parentEditPart) {
        this(parentEditPart, -1, -1);
    }

    public GenericGridFigure(EditPart parentEditPart, int cols, int rows) {
        super(parentEditPart, "");
        if (cols < 0 || rows < 0) {
            String numOfCols = this.getProperty("columns");
            cols = 0;
            cols = numOfCols == null || numOfCols.length() < 1 ? 1 : Integer.parseInt(numOfCols);
            String numOfRows = this.getProperty("rows");
            rows = 0;
            if (numOfRows == null || numOfRows.length() < 1) {
                EntityEnumeration entityEnumeration = ((Reference)parentEditPart.getModel()).getEntity().childEntities();
                while (entityEnumeration.hasMoreElements()) {
                    ++rows;
                    entityEnumeration.nextElement();
                }
                cols = 1;
            } else {
                rows = Integer.parseInt(numOfRows);
            }
            rows = Math.max(1, rows);
            cols = Math.max(1, cols);
        }
        GenericGridLayoutManager manager = new GenericGridLayoutManager(rows, cols);
        int[] rowHeights = new int[rows];
        int i = 0;
        while (i < rows) {
            String theRowHeight = this.getProperty("row" + i + "height");
            if (theRowHeight == null || theRowHeight.length() <= 1) {
                theRowHeight = DEFAULT_SIZE_PROPERTY;
            }
            rowHeights[i] = Integer.parseInt(theRowHeight);
            ++i;
        }
        int[] colWidths = new int[cols];
        int i2 = 0;
        while (i2 < cols) {
            String theColWidth = this.getProperty("col" + i2 + "width");
            if (theColWidth == null || theColWidth.length() <= 1) {
                theColWidth = DEFAULT_SIZE_PROPERTY;
            }
            colWidths[i2] = Integer.parseInt(theColWidth);
            ++i2;
        }
        manager.initGrid(rowHeights, colWidths);
        this.setLayoutManager(manager);
        parentEditPart.installEditPolicy((Object)EDIT_POLICY, (EditPolicy)new GenericGridEditPolicy(this));
    }
}

