/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;

public class CanFigure
extends Shape {
    private static final int DEFAULT_ELLIPSE_PROPORTION = 4;
    private int mProportion = 4;

    public CanFigure() {
        this(4);
    }

    public CanFigure(int ellipseProportion) {
        if (ellipseProportion > 0) {
            this.mProportion = ellipseProportion;
        }
    }

    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        Rectangle ell = this.getBounds().getCopy();
        ell.height /= this.mProportion;
        Rectangle topEll = ell;
        if (this.containsPoint(topEll, x, y)) {
            return true;
        }
        Rectangle bottomEll = ell.getCopy().translate(0, this.getHeight(ell));
        if (this.containsPoint(bottomEll, x, y)) {
            return true;
        }
        return new Rectangle(topEll.getLeft(), bottomEll.getRight()).contains(x, y);
    }

    protected void fillShape(Graphics g) {
        Rectangle arc1 = this.getBounds().getCopy();
        arc1.height /= this.mProportion;
        Rectangle arc2 = arc1.getCopy().translate(0, this.getHeight(arc1));
        g.fillRectangle(new Rectangle(arc1.getLeft(), arc2.getRight()));
        g.fillArc(new Rectangle(arc1.getLocation(), arc1.getBottomRight()).resize(0, -1), 0, 180);
        g.fillArc(new Rectangle(arc2.getLocation(), arc2.getBottomRight()).resize(0, 1), 180, 180);
    }

    protected void outlineShape(Graphics g) {
        Rectangle ell = this.getBounds().getCopy();
        ell.height /= this.mProportion;
        Rectangle eShrinked = ell.getCopy().translate(-1, 0).shrink((this.lineWidth - 1) / 2, (this.lineWidth - 1) / 2);
        g.drawOval(eShrinked);
        Rectangle arcBounds = ell.getCopy().translate(0, this.getHeight(ell));
        g.drawLine(ell.getLeft(), arcBounds.getLeft());
        g.drawLine(ell.getRight().translate(-1, 0), arcBounds.getRight().translate(-1, 0));
        g.drawArc(new Rectangle(arcBounds.getLocation(), arcBounds.getBottomRight().translate(-2, -1)), 180, 180);
    }

    private boolean containsPoint(Rectangle el, int x, int y) {
        long ux = x - el.x - el.width / 2;
        long uy = y - el.y - el.height / 2;
        return (ux * ux << 10) / (long)(el.width * el.width) + (uy * uy << 10) / (long)(el.height * el.height) <= 256L;
    }

    private int getHeight(Rectangle topEllipse) {
        return this.getBounds().height - topEllipse.height;
    }
}

