/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.editpolicies;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.commands.MoveSplitterCommand;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.figures.IFigureWithProperties;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.handles.SplitterHandle;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.SplitLayoutManager;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.locators.SplitterLocator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class SplitterEditPolicy
extends SelectionHandlesEditPolicy {
    protected boolean myRealTimeFeedback = true;
    private IFigure mySplitter;
    protected SplitLayoutManager myLayoutManager;
    protected IFigureWithProperties myContainer;
    private IFigure myFeedback = null;
    private Point mySash;

    public SplitterEditPolicy(IFigureWithProperties container) {
        LayoutManager manager = container.getLayoutManager();
        if (!(manager instanceof SplitLayoutManager)) {
            throw new IllegalArgumentException("SplitterEditPolicy could be installed only for components with SplitLayoutManager");
        }
        this.myLayoutManager = (SplitLayoutManager)manager;
        this.myContainer = container;
    }

    public void setRealTimeFeedback(boolean feedback) {
        this.myRealTimeFeedback = feedback;
    }

    protected List createSelectionHandles() {
        ArrayList<IFigure> list = new ArrayList<IFigure>();
        int orientation = this.myLayoutManager.getOrientation();
        int moveDirection = -1;
        if (orientation == 0 || orientation == 2) {
            moveDirection = 24;
        } else if (orientation == 3 || orientation == 1) {
            moveDirection = 5;
        }
        this.mySplitter = new SplitterHandle((GraphicalEditPart)this.getHost(), new SplitterLocator(this.myContainer, orientation), moveDirection);
        list.add(this.mySplitter);
        return list;
    }

    public boolean understandsRequest(Request request) {
        if ("move split".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public Command getCommand(Request request) {
        if ("move split".equals(request.getType())) {
            ChangeBoundsRequest req = (ChangeBoundsRequest)request;
            Point sashPoint = this.mySash.getTranslated(req.getMoveDelta());
            return new MoveSplitterCommand(this.getHost(), this.myContainer, this.myLayoutManager, sashPoint);
        }
        return null;
    }

    public void showSourceFeedback(Request request) {
        if ("move split".equals(request.getType())) {
            this.showMoveSashPointFeedback((ChangeBoundsRequest)request);
        }
    }

    public void eraseSourceFeedback(Request request) {
        if ("move split".equals(request.getType()) && this.myFeedback != null) {
            this.myLayoutManager.setSashPoint(this.mySash);
            this.revalidateFeedback();
            if (this.myRealTimeFeedback) {
                this.myContainer.revalidate();
            }
            this.myFeedback = null;
        }
        this.mySash = null;
    }

    protected void showMoveSashPointFeedback(ChangeBoundsRequest request) {
        if (this.myFeedback == null) {
            this.myFeedback = this.createFeedbackFigure();
        }
        Point sashPoint = this.mySash.getTranslated(request.getMoveDelta());
        this.myLayoutManager.setSashPoint(sashPoint);
        this.revalidateFeedback();
        if (this.myRealTimeFeedback) {
            this.myContainer.revalidate();
        }
    }

    protected void revalidateFeedback() {
        this.myFeedback.revalidate();
    }

    protected IFigure createFeedbackFigure() {
        this.mySash = this.myLayoutManager.getSashPoint();
        return this.mySplitter;
    }
}

