/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.editpolicies;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.commands.SetPlugConstraintCommand;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.handles.PlugMoveHandle;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.PlugLinearLayoutManager;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.locators.PlugLocator;
import com.tssap.selena.gde.ModelElementEditPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class PlugMoveEditPolicy
extends SelectionHandlesEditPolicy {
    private int myArrowDirection = 1;
    private int myNewPosition;
    private IFigure myTargetArea;
    private IFigure myFeedback;
    private Point myOffsetPoint;
    private ModelElementEditPart myElement;
    private ModelElementEditPart myParent;

    public PlugMoveEditPolicy(ModelElementEditPart element, ModelElementEditPart parent) {
        this.myElement = element;
        this.myParent = parent;
    }

    protected List createSelectionHandles() {
        ArrayList<PlugMoveHandle> handles = new ArrayList<PlugMoveHandle>();
        handles.add(new PlugMoveHandle((GraphicalEditPart)this.getHost(), (Locator)new PlugLocator(this.myElement.getOriginalFigure())));
        return handles;
    }

    public void showSourceFeedback(Request request) {
        if ("move plug".equals(request.getType())) {
            boolean upperthansecond;
            if (this.myFeedback == null) {
                this.myFeedback = this.createFeedbackFigure();
            }
            ChangeBoundsRequest cb = (ChangeBoundsRequest)request;
            Rectangle pbounds = null;
            IFigure central = this.myParent.getContentPane();
            central = central.getParent();
            central = central.getParent();
            pbounds = central.getBounds();
            float koeff = (float)(pbounds.getBottomRight().y - pbounds.getTopLeft().y) / (float)(pbounds.getBottomRight().x - pbounds.getTopLeft().x);
            Point newLocation = cb.getLocation();
            central.translateToRelative((Translatable)newLocation);
            boolean upperthanfirst = -koeff * (float)(newLocation.x - pbounds.getLeft().x) + (float)pbounds.getBottomLeft().y >= (float)newLocation.y;
            boolean bl = upperthansecond = koeff * (float)(newLocation.x - pbounds.getLeft().x) + (float)pbounds.getTopLeft().y >= (float)newLocation.y;
            if (upperthanfirst && upperthansecond) {
                this.myTargetArea = (IFigure)this.myParent.getOriginalFigure().getChildren().get(1);
                this.myArrowDirection = 1;
                this.myOffsetPoint = pbounds.getLocation();
                this.myOffsetPoint.translate(0, -15);
            } else if (!upperthanfirst && upperthansecond) {
                this.myTargetArea = (IFigure)this.myParent.getOriginalFigure().getChildren().get(5);
                this.myArrowDirection = 16;
                this.myOffsetPoint = pbounds.getTopRight();
            } else if (upperthanfirst && !upperthansecond) {
                this.myTargetArea = (IFigure)this.myParent.getOriginalFigure().getChildren().get(3);
                this.myArrowDirection = 8;
                this.myOffsetPoint = pbounds.getLocation();
                this.myOffsetPoint.translate(-15, 0);
            } else {
                this.myTargetArea = (IFigure)this.myParent.getOriginalFigure().getChildren().get(7);
                this.myArrowDirection = 4;
                this.myOffsetPoint = pbounds.getBottomLeft();
            }
            Point localPoint = cb.getLocation();
            Rectangle tarBounds = this.myTargetArea.getBounds();
            if (tarBounds.getSize().width != 0 && tarBounds.getSize().height != 0) {
                this.myOffsetPoint = this.myTargetArea.getBounds().getLocation();
            }
            int relativeX = Math.max(0, localPoint.x - this.myOffsetPoint.x);
            relativeX = Math.min(pbounds.width, relativeX);
            int relativeY = Math.max(0, localPoint.y - this.myOffsetPoint.y);
            relativeY = Math.min(pbounds.height, relativeY);
            this.revalidateFeedback(new Point(relativeX, relativeY));
        }
    }

    public void eraseSourceFeedback(Request request) {
        if ("move plug".equals(request.getType()) && this.myFeedback != null) {
            this.removeFeedback(this.myFeedback);
            this.myFeedback = null;
        }
    }

    public boolean understandsRequest(Request request) {
        if ("move plug".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public Command getCommand(Request request) {
        if ("move plug".equals(request.getType())) {
            if (this.myTargetArea.getLayoutManager() instanceof PlugLinearLayoutManager && ((PlugLinearLayoutManager)this.myTargetArea.getLayoutManager()).isOccupied(this.myNewPosition)) {
                return null;
            }
            return new SetPlugConstraintCommand((EditPart)this.myElement, (EditPart)this.myParent, this.myArrowDirection, this.myNewPosition, request);
        }
        return null;
    }

    protected IFigure createFeedbackFigure() {
        RectangleFigure fig = new RectangleFigure();
        fig.setOpaque(false);
        fig.setForegroundColor(ColorConstants.black);
        this.addFeedback((IFigure)fig);
        return fig;
    }

    protected void revalidateFeedback(Point newLocation) {
        LayoutManager lm = this.myTargetArea.getLayoutManager();
        if (lm instanceof PlugLinearLayoutManager) {
            PlugLinearLayoutManager plm = (PlugLinearLayoutManager)lm;
            this.myNewPosition = plm.calculateIndexFor(newLocation);
            this.myFeedback.setBounds(plm.calculateBoundsFor(this.myNewPosition).translate(this.myOffsetPoint));
            if (plm.isOccupied(this.myNewPosition)) {
                this.myFeedback.setBackgroundColor(ColorConstants.red);
            } else {
                this.myFeedback.setBackgroundColor(ColorConstants.yellow);
            }
        } else {
            System.err.println("Wrong layout manager for target area: " + this.myTargetArea);
        }
        this.myFeedback.revalidate();
    }
}

