/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.editpolicies;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.commands.ChangeGridColsCommand;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.commands.ChangeGridCommand;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.commands.ChangeGridRowsCommand;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.figures.IFigureWithProperties;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.handles.GridSplitterHandle;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.handles.SplitterHandle;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.GenericGridLayoutManager;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.locators.GridLocator;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.requests.MoveSplitterRequest;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;

public class GenericGridEditPolicy
extends SelectionHandlesEditPolicy {
    private IFigureWithProperties myContainer;
    private GenericGridLayoutManager myLayoutManager;
    private SplitterHandle[] myHorizontalSplitters;
    private SplitterHandle[] myVerticalSplitters;
    private SplitterHandle[] myPointSplitters;
    private IFigure myFeedback = null;
    private int myStartSize;
    private Point myStartDimension;
    protected boolean myRealTimeFeedback = true;

    public GenericGridEditPolicy(IFigureWithProperties container) {
        this.myContainer = container;
        if (!(this.myContainer.getLayoutManager() instanceof GenericGridLayoutManager)) {
            throw new IllegalArgumentException("GenericGridEditPolicy can be installed only over figure with GenericGridLayoutManager");
        }
        this.myLayoutManager = (GenericGridLayoutManager)this.myContainer.getLayoutManager();
    }

    protected List createSelectionHandles() {
        ArrayList<GridSplitterHandle> splitters = new ArrayList<GridSplitterHandle>();
        this.myHorizontalSplitters = new SplitterHandle[Math.max(0, this.myLayoutManager.getNumOfRows() - 1)];
        int i = 0;
        while (i < this.myLayoutManager.getNumOfRows() - 1) {
            GridSplitterHandle splitter = new GridSplitterHandle((GraphicalEditPart)this.getHost(), new GridLocator(this.myContainer, 1, i), 5, 1, i);
            splitters.add(splitter);
            this.myHorizontalSplitters[i] = splitter;
            ++i;
        }
        this.myVerticalSplitters = new SplitterHandle[Math.max(0, this.myLayoutManager.getNumOfCols() - 1)];
        int i2 = 0;
        while (i2 < this.myLayoutManager.getNumOfCols() - 1) {
            GridSplitterHandle splitter = new GridSplitterHandle((GraphicalEditPart)this.getHost(), new GridLocator(this.myContainer, 0, i2), 24, 0, i2);
            splitters.add(splitter);
            this.myVerticalSplitters[i2] = splitter;
            ++i2;
        }
        this.myPointSplitters = new SplitterHandle[this.myHorizontalSplitters.length * this.myVerticalSplitters.length];
        int y = 0;
        while (y < this.myHorizontalSplitters.length) {
            int x = 0;
            while (x < this.myVerticalSplitters.length) {
                GridSplitterHandle splitter = new GridSplitterHandle((GraphicalEditPart)this.getHost(), new GridLocator(this.myContainer, -1, x, y), 0, -1, x, y);
                splitters.add(splitter);
                this.myPointSplitters[x + y * this.myVerticalSplitters.length] = splitter;
                ++x;
            }
            ++y;
        }
        return splitters;
    }

    public boolean understandsRequest(Request request) {
        if ("move split".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public Command getCommand(Request request) {
        if ("move split".equals(request.getType()) && request instanceof MoveSplitterRequest) {
            MoveSplitterRequest req = (MoveSplitterRequest)request;
            if (req.getOrientation() == 1) {
                return new ChangeGridRowsCommand(this.getHost(), this.myContainer, this.myLayoutManager, req.getPosition(), this.myStartSize + req.getMoveDelta().y);
            }
            if (req.getOrientation() == 0) {
                return new ChangeGridColsCommand(this.getHost(), this.myContainer, this.myLayoutManager, req.getPosition(), this.myStartSize + req.getMoveDelta().x);
            }
            return new ChangeGridCommand(this.getHost(), this.myContainer, this.myLayoutManager, new Point(req.getPosition(), req.getOrtogonalPosition()), new Point(this.myStartDimension.getTranslated(req.getMoveDelta())));
        }
        return null;
    }

    public void showSourceFeedback(Request request) {
        if ("move split".equals(request.getType())) {
            if (request instanceof MoveSplitterRequest) {
                this.showMoveSplitterFeedback((MoveSplitterRequest)request);
            } else {
                System.err.println("Wrong request type");
            }
        }
    }

    public void eraseSourceFeedback(Request request) {
        if ("move split".equals(request.getType()) && request instanceof MoveSplitterRequest && this.myFeedback != null) {
            MoveSplitterRequest req = (MoveSplitterRequest)request;
            if (req.getOrientation() == 1) {
                this.myLayoutManager.setRowHeight(req.getPosition(), this.myStartSize);
            } else if (req.getOrientation() == 0) {
                this.myLayoutManager.setColWidth(req.getPosition(), this.myStartSize);
            } else {
                this.myLayoutManager.setColWidth(req.getPosition(), this.myStartDimension.x);
                this.myLayoutManager.setRowHeight(req.getOrtogonalPosition(), this.myStartDimension.y);
            }
            this.revalidateFeedback();
            if (this.myRealTimeFeedback) {
                this.myContainer.revalidate();
            }
            this.myFeedback = null;
        }
    }

    protected void showMoveSplitterFeedback(MoveSplitterRequest request) {
        if (this.myFeedback == null) {
            this.myFeedback = this.createFeedbackFigure(request);
        }
        Point deltaPoint = request.getMoveDelta();
        if (request.getOrientation() == 1) {
            this.myLayoutManager.setRowHeight(request.getPosition(), Math.max(this.myStartSize + deltaPoint.y, 0));
        } else if (request.getOrientation() == 0) {
            this.myLayoutManager.setColWidth(request.getPosition(), Math.max(this.myStartSize + deltaPoint.x, 0));
        } else {
            this.myLayoutManager.setColWidth(request.getPosition(), Math.max(this.myStartDimension.x + deltaPoint.x, 0));
            this.myLayoutManager.setRowHeight(request.getOrtogonalPosition(), Math.max(this.myStartDimension.y + deltaPoint.y, 0));
        }
        this.revalidateFeedback();
        if (this.myRealTimeFeedback) {
            this.myContainer.revalidate();
        }
    }

    protected void revalidateFeedback() {
        int x;
        int y = 0;
        while (y < this.myHorizontalSplitters.length) {
            this.myHorizontalSplitters[y].revalidate();
            x = 0;
            while (x < this.myVerticalSplitters.length) {
                this.myPointSplitters[x + y * this.myVerticalSplitters.length].revalidate();
                ++x;
            }
            ++y;
        }
        x = 0;
        while (x < this.myVerticalSplitters.length) {
            this.myVerticalSplitters[x].revalidate();
            ++x;
        }
    }

    protected IFigure createFeedbackFigure(MoveSplitterRequest request) {
        if (request.getOrientation() == 1) {
            this.myStartSize = this.myLayoutManager.getRowHeight(request.getPosition());
            return this.myHorizontalSplitters[request.getPosition()];
        }
        if (request.getOrientation() == 0) {
            this.myStartSize = this.myLayoutManager.getColWidth(request.getPosition());
            return this.myVerticalSplitters[request.getPosition()];
        }
        this.myStartDimension = new Point(this.myLayoutManager.getColWidth(request.getPosition()), this.myLayoutManager.getRowHeight(request.getOrtogonalPosition()));
        return this.myPointSplitters[request.getPosition() + request.getOrtogonalPosition() * this.myVerticalSplitters.length];
    }
}

