/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.editpolicies;

import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.commands.ExtendedChangeGridCommand;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.figures.IFigureWithProperties;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.handles.ExtendedGridSplitterHandle;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.ExtendedGridLayoutManager;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.locators.ExtendedGridLocator;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.requests.ExtendedMoveSplitterRequest;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;

public class ExtendedGridEditPolicy
extends SelectionHandlesEditPolicy {
    private IFigureWithProperties mContainer;
    private ExtendedGridLayoutManager mLayoutManager;
    private Map mSplittersVertical = new Hashtable();
    private Map mSplittersHorizontal = new Hashtable();
    private Map mSplittersPoint = new Hashtable();
    private IFigure mFeedback = null;
    private Dimension mStartDimension;
    protected boolean mRealTimeFeedback = true;

    public ExtendedGridEditPolicy(IFigureWithProperties container) {
        this.mContainer = container;
        if (!(this.mContainer.getLayoutManager() instanceof ExtendedGridLayoutManager)) {
            throw new IllegalArgumentException("ExtendedGridEditPolicy can be installed only over figure with ExtendedGridLayoutManager");
        }
        this.mLayoutManager = (ExtendedGridLayoutManager)this.mContainer.getLayoutManager();
    }

    protected List createSelectionHandles() {
        Vector<ExtendedGridSplitterHandle> splitters = new Vector<ExtendedGridSplitterHandle>();
        ExtendedGridLayoutManager.Splitter[] layoutSplitters = this.mLayoutManager.getSplitters();
        int i = 0;
        while (i < layoutSplitters.length) {
            ExtendedGridLayoutManager.Splitter splitter = layoutSplitters[i];
            ExtendedGridSplitterHandle splitterHandle = new ExtendedGridSplitterHandle((GraphicalEditPart)this.getHost(), new ExtendedGridLocator(this.mContainer, splitter.getOrientation(), splitter.getCell()), splitter.getOrientation(), splitter.getCell());
            if (splitter.getOrientation() == 1) {
                this.mSplittersHorizontal.put(splitter.getCell(), splitterHandle);
            } else if (splitter.getOrientation() == 0) {
                this.mSplittersVertical.put(splitter.getCell(), splitterHandle);
            } else if (splitter.getOrientation() == -1) {
                this.mSplittersPoint.put(splitter.getCell(), splitterHandle);
            }
            splitters.add(splitterHandle);
            ++i;
        }
        return splitters;
    }

    public boolean understandsRequest(Request request) {
        if ("move split".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public Command getCommand(Request request) {
        if ("move split".equals(request.getType()) && request instanceof ExtendedMoveSplitterRequest) {
            ExtendedMoveSplitterRequest req = (ExtendedMoveSplitterRequest)request;
            return new ExtendedChangeGridCommand(this.getHost(), this.mContainer, this.mLayoutManager, req.getCell());
        }
        return null;
    }

    public void showSourceFeedback(Request request) {
        if ("move split".equals(request.getType())) {
            if (request instanceof ExtendedMoveSplitterRequest) {
                this.showMoveSplitterFeedback((ExtendedMoveSplitterRequest)request);
            } else {
                throw new IllegalArgumentException("Wrong request type for policy: " + request);
            }
        }
    }

    public void eraseSourceFeedback(Request request) {
        if ("move split".equals(request.getType()) && request instanceof ExtendedMoveSplitterRequest && this.mFeedback != null) {
            this.revalidateFeedback();
            if (this.mRealTimeFeedback) {
                this.mContainer.revalidate();
            }
            this.mFeedback = null;
        }
    }

    protected void showMoveSplitterFeedback(ExtendedMoveSplitterRequest request) {
        if (this.mFeedback == null) {
            this.mFeedback = this.createFeedbackFigure(request);
        }
        Point deltaPoint = request.getMoveDelta();
        if (request.getOrientation() == 1) {
            this.mLayoutManager.setHeight(request.getCell(), Math.max(this.mStartDimension.height + deltaPoint.y, 0), request.getOrientation());
        } else if (request.getOrientation() == 0) {
            this.mLayoutManager.setWidth(request.getCell(), Math.max(this.mStartDimension.width + deltaPoint.x, 0), request.getOrientation());
        } else if (request.getOrientation() == -1) {
            this.mLayoutManager.setWidth(request.getCell(), Math.max(this.mStartDimension.width + deltaPoint.x, 0), request.getOrientation());
            this.mLayoutManager.setHeight(request.getCell(), Math.max(this.mStartDimension.height + deltaPoint.y, 0), request.getOrientation());
        } else {
            throw new IllegalArgumentException("Wrong orientation: " + request.getOrientation());
        }
        this.revalidateFeedback();
        if (this.mRealTimeFeedback) {
            this.mContainer.revalidate();
        }
    }

    protected void revalidateFeedback() {
        Iterator iter = this.mSplittersHorizontal.values().iterator();
        while (iter.hasNext()) {
            ExtendedGridSplitterHandle handle = (ExtendedGridSplitterHandle)((Object)iter.next());
            handle.revalidate();
        }
        Iterator iter2 = this.mSplittersVertical.values().iterator();
        while (iter2.hasNext()) {
            ExtendedGridSplitterHandle handle = (ExtendedGridSplitterHandle)((Object)iter2.next());
            handle.revalidate();
        }
        Iterator iter3 = this.mSplittersPoint.values().iterator();
        while (iter3.hasNext()) {
            ExtendedGridSplitterHandle handle = (ExtendedGridSplitterHandle)((Object)iter3.next());
            handle.revalidate();
        }
    }

    protected IFigure createFeedbackFigure(ExtendedMoveSplitterRequest request) {
        IFigure splitterFigure = null;
        this.mStartDimension = new Dimension(this.mLayoutManager.getWidth(request.getCell()), this.mLayoutManager.getHeight(request.getCell()));
        if (request.getOrientation() == 1) {
            splitterFigure = (IFigure)this.mSplittersHorizontal.get(request.getCell());
        } else if (request.getOrientation() == 0) {
            splitterFigure = (IFigure)this.mSplittersVertical.get(request.getCell());
        } else if (request.getOrientation() == -1) {
            splitterFigure = (IFigure)this.mSplittersPoint.get(request.getCell());
        }
        return splitterFigure;
    }
}

