/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.commands;

import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.figures.IFigureWithProperties;
import com.sap.ide.webdynpro.tsmodel.application.viewmaps.utils.layouts.ExtendedGridLayoutManager;
import com.tssap.selena.gde.ModelNodeEditPart;
import com.tssap.selena.gde.internal.DiagramImpl;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.AbstractCommand;

public class ExtendedChangeGridCommand
extends AbstractCommand {
    private ModelNodeEditPart myEditPart;
    private ExtendedGridLayoutManager myLayout;
    private IFigureWithProperties myFigure;
    private Point mCell;

    public ExtendedChangeGridCommand(EditPart nodeEditPart, IFigureWithProperties figure, ExtendedGridLayoutManager manager, Point cell) {
        this.myEditPart = (ModelNodeEditPart)nodeEditPart;
        this.myFigure = figure;
        this.myLayout = manager;
        this.mCell = cell;
    }

    public void execute() {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                int y = 0;
                while (y < ExtendedChangeGridCommand.this.myLayout.getNumOfRows()) {
                    int x = 0;
                    while (x < ExtendedChangeGridCommand.this.myLayout.getNumOfCols()) {
                        int col = x + 1;
                        int row = y + 1;
                        String propertyWidth = "col" + col + "row" + row + "width";
                        String propertyHeight = "col" + col + "row" + row + "height";
                        Point cell = new Point(col, row);
                        Dimension dim = new Dimension(ExtendedChangeGridCommand.this.myLayout.getWidth(cell), ExtendedChangeGridCommand.this.myLayout.getHeight(cell));
                        dim.width = Math.max(dim.width, 10);
                        dim.height = Math.max(dim.height, 10);
                        ExtendedChangeGridCommand.this.myFigure.setProperty(propertyWidth, String.valueOf(dim.width));
                        ExtendedChangeGridCommand.this.myFigure.setProperty(propertyHeight, String.valueOf(dim.height));
                        if (TsmodelWebDynproPlugin.isDataViewDebugging()) {
                            System.out.println("ExtendedChangeGridCommand.execute(): ");
                            System.out.println("\tSetting width for " + cell + ": " + dim.width + " as property " + propertyWidth);
                            System.out.println("\tSetting height for " + cell + ": " + dim.height + " as property " + propertyHeight);
                        }
                        ++x;
                    }
                    ++y;
                }
                DiagramImpl diagram = (DiagramImpl)ExtendedChangeGridCommand.this.myEditPart.getDiagram();
                diagram.addResizedObject((Object)((Reference)ExtendedChangeGridCommand.this.myEditPart.getModel()));
            }
        });
    }
}

