/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider.rc.dataview;

import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkUtils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.providers.rc.AllChildrenRule;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class DataViewEntiesRule
extends AllChildrenRule {
    public UniqueNameEnumeration childReferencedEntities(ReferenceContainer container) {
        UniqueNameEnumeration superRefEntities = super.childReferencedEntities(container);
        ArrayList<UniqueName> dataViewEntities = new ArrayList<UniqueName>();
        if (container instanceof Reference) {
            Reference refCont = (Reference)container;
            String parentsMetaClass = refCont.getEntity().getPropertyValue("$metaclass");
            if (parentsMetaClass.equals("WDCustomControllers")) {
                dataViewEntities.add(DataViewEntiesRule.findComponentControllerUIN(refCont));
            }
            while (superRefEntities.hasMoreElements()) {
                UniqueName uin = superRefEntities.next();
                Entity entity = ((Reference)container).getModel().findEntity(uin);
                String metaClass = entity.getPropertyValue("$metaclass");
                if (!DataViewEntiesRule.shouldBeAdded(metaClass, parentsMetaClass)) continue;
                dataViewEntities.add(uin);
            }
        } else if (container instanceof ReferenceCollection) {
            ReferenceCollection rc = (ReferenceCollection)container;
            if (!rc.isDeleted()) {
                dataViewEntities.add(rc.getParent().getUniqueName());
            }
        } else {
            return superRefEntities;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(dataViewEntities));
    }

    private static boolean shouldBeAdded(String metaClass, String parentsMetaClass) {
        if (metaClass != null && parentsMetaClass != null && DataLinkUtils.isValidDataViewEntityMetaClass(metaClass)) {
            if (parentsMetaClass.equals("WDComponent")) {
                if (!metaClass.equals("WDComponentController")) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static UniqueName findComponentControllerUIN(Reference custControllersRef) {
        Entity component = custControllersRef.getEntity().getParent();
        EntityEnumeration children = component.children();
        while (children.hasMoreElements()) {
            Entity child = children.next();
            String metaClass = child.getPropertyValue("$metaclass");
            if (!metaClass.equals("WDComponentController")) continue;
            return child.getUniqueName();
        }
        return null;
    }

    public ModelDeltaNode getReferencedEntitiesDelta(ReferenceCollection collection, ModelDeltaNode rootDelta) {
        ModelDeltaNode resultWithSubSubDeltas = super.getReferencedEntitiesDelta(collection, rootDelta);
        return resultWithSubSubDeltas == null ? null : new OnlyTopLevelDeltaAdapter(resultWithSubSubDeltas);
    }

    private static class CustomControllersEntityChangedAdapter
    extends EntityBasedDeltaAdapter {
        private ModelDeltaNode mChangedCompController;

        public CustomControllersEntityChangedAdapter(Entity rootEntity, ModelDeltaNode changedCompController) {
            super(rootEntity);
            this.mChangedCompController = changedCompController;
        }

        public Enumeration changedChildren() {
            ArrayList<ModelDeltaNode> results = new ArrayList<ModelDeltaNode>();
            if (this.mChangedCompController != null) {
                results.add(this.mChangedCompController);
            }
            return Collections.enumeration(results);
        }
    }

    private static class EntityBasedDeltaAdapter
    implements ModelDeltaNode {
        private Entity mEntity;

        public EntityBasedDeltaAdapter(Entity rootEntity) {
            this.mEntity = rootEntity;
        }

        public Enumeration changedChildren() {
            return Collections.enumeration(this.changedChildrenList());
        }

        public final Element getElement() {
            return this.mEntity;
        }

        public final UniqueName getElementUniqueName() {
            return this.mEntity.getUniqueName();
        }

        public final UniqueName getOriginalElementUniqueName() {
            return this.getElementUniqueName();
        }

        public final boolean isChanged() {
            return true;
        }

        public final boolean isDeleted() {
            return this.mEntity.isDeleted();
        }

        public final boolean isEmpty() {
            return false;
        }

        public final boolean isNew() {
            return false;
        }

        public final boolean isTotallyChanged() {
            return false;
        }

        protected Entity getEntity() {
            return this.mEntity;
        }

        protected List changedChildrenList() {
            ArrayList<EntityBasedDeltaAdapter> results = new ArrayList<EntityBasedDeltaAdapter>();
            EntityEnumeration children = this.mEntity.childEntities();
            while (children.hasMoreElements()) {
                Entity child = (Entity)children.nextElement();
                if (!DataLinkUtils.isValidDataViewEntityMetaClass(child.getPropertyValue("$metaclass"))) continue;
                results.add(new EntityBasedDeltaAdapter(child));
            }
            return results;
        }
    }

    private static class CustomControllersChangedAdapter
    extends DataViewEntitesDeltaAdapter {
        private ModelDeltaNode mChangedCompController;

        public CustomControllersChangedAdapter(ModelDeltaNode delegate, ModelDeltaNode changedCompController) {
            super(delegate);
            this.mChangedCompController = changedCompController;
        }

        public Enumeration changedChildren() {
            ArrayList<ModelDeltaNode> result = new ArrayList<ModelDeltaNode>();
            ModelDeltaNode delegate = this.getDelegate();
            Enumeration subdeltas = delegate.changedChildren();
            while (subdeltas.hasMoreElements()) {
                ModelDeltaNode mdn = (ModelDeltaNode)subdeltas.nextElement();
                result.add(mdn);
            }
            if (this.mChangedCompController != null) {
                result.add(this.mChangedCompController);
            }
            return Collections.enumeration(result);
        }
    }

    private static class OnlyTopLevelDeltaAdapter
    extends DataViewEntitesDeltaAdapter {
        public OnlyTopLevelDeltaAdapter(ModelDeltaNode delegate) {
            super(delegate);
        }

        public Enumeration changedChildren() {
            ArrayList<DataViewEntitesDeltaAdapter> result = new ArrayList<DataViewEntitesDeltaAdapter>();
            ModelDeltaNode delegate = this.getDelegate();
            if (delegate == null) {
                return super.changedChildren();
            }
            result.add(new DataViewEntitesDeltaAdapter(delegate));
            return Collections.enumeration(result);
        }
    }

    private static class DataViewEntitesDeltaAdapter
    extends DeltaAdapter
    implements ModelDeltaNode {
        private ModelDeltaNode mChangedComponentController;
        private ModelDeltaNode mChangedCustControllers;

        public DataViewEntitesDeltaAdapter(ModelDeltaNode delegate) {
            super(delegate);
        }

        public Enumeration changedChildren() {
            ArrayList<Object> result = new ArrayList<Object>();
            ModelDeltaNode delegate = this.getDelegate();
            String parentsMetaClass = delegate.getElement().getPropertyValue("$metaclass");
            Enumeration subdeltas = delegate.changedChildren();
            while (subdeltas.hasMoreElements()) {
                ModelDeltaNode mdn = (ModelDeltaNode)subdeltas.nextElement();
                Entity entity = (Entity)mdn.getElement();
                if (entity == null) continue;
                String metaClass = entity.getPropertyValue("$metaclass");
                if (DataViewEntiesRule.shouldBeAdded(metaClass, parentsMetaClass)) {
                    result.add(new DataViewEntitesDeltaAdapter(mdn));
                }
                if (metaClass.equals("WDComponentController")) {
                    this.mChangedComponentController = mdn;
                    continue;
                }
                if (!metaClass.equals("WDCustomControllers")) continue;
                this.mChangedCustControllers = mdn;
            }
            if (parentsMetaClass.equals("WDComponent")) {
                if (this.mChangedCustControllers != null) {
                    result.add(new CustomControllersChangedAdapter(this.mChangedCustControllers, this.mChangedComponentController));
                } else {
                    result.add(new CustomControllersEntityChangedAdapter(this.findEntity((Entity)delegate.getElement(), "WDCustomControllers"), this.mChangedComponentController));
                }
            }
            return Collections.enumeration(result);
        }

        private Entity findEntity(Entity rootEntity, String metaClass) {
            if (metaClass.equals(rootEntity.getPropertyValue("$metaclass"))) {
                return rootEntity;
            }
            EntityEnumeration children = rootEntity.children();
            while (children.hasMoreElements()) {
                Entity child = (Entity)children.nextElement();
                Entity foundEntity = this.findEntity(child, metaClass);
                if (foundEntity == null) continue;
                return foundEntity;
            }
            return null;
        }
    }

    private static abstract class DeltaAdapter
    implements ModelDeltaNode {
        private ModelDeltaNode myDelegate;

        public DeltaAdapter(ModelDeltaNode delegate) {
            this.myDelegate = delegate;
        }

        public abstract Enumeration changedChildren();

        public final Element getElement() {
            return this.myDelegate.getElement();
        }

        public final UniqueName getElementUniqueName() {
            return this.myDelegate.getElementUniqueName();
        }

        public final UniqueName getOriginalElementUniqueName() {
            return this.myDelegate.getOriginalElementUniqueName();
        }

        public final boolean isChanged() {
            return this.myDelegate.isChanged();
        }

        public final boolean isDeleted() {
            return this.myDelegate.isDeleted();
        }

        public final boolean isEmpty() {
            return this.myDelegate.isEmpty();
        }

        public final boolean isNew() {
            return this.myDelegate.isNew();
        }

        public final boolean isTotallyChanged() {
            return this.myDelegate.isTotallyChanged();
        }

        protected final ModelDeltaNode getDelegate() {
            return this.myDelegate;
        }
    }
}

