/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider.datalink;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLink;
import com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkSourceManager;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;

public class DataLinkUtils
extends Utils {
    public static boolean exists(UniqueName uniqueName, String subDomain) {
        return DataLinkUtils.hasValidDomain(uniqueName) && subDomain != null && subDomain.equals(uniqueName.getSubDomain());
    }

    public static boolean linkExists(DataLinkSourceManager dataSourceManager, UniqueName uniqueName, String subDomain) {
        return DataLinkUtils.exists(uniqueName, subDomain) && dataSourceManager.getDataLinkManager().findDataLink(uniqueName) != null;
    }

    public static boolean hasValidDomain(UniqueName uniqueName) {
        return "WebDynpro".equals(uniqueName.getDomain());
    }

    public static boolean linkHasValidSubdomain(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        return DataLinkUtils.hasValidDomain(uniqueName) && "DataLink".equals(uniqueName.getSubDomain());
    }

    public static boolean isValidSourceParticipantMetaClass(String metaClass) {
        return metaClass.equals("WDCustomController") || metaClass.equals("WDComponentController") || metaClass.equals("WDInterfaceController") || metaClass.equals("WDCIDInterfaceController") || metaClass.equals("WDView") || metaClass.equals("WDComponentUsageInterfaceController");
    }

    public static boolean isValidTargetParticipantMetaClass(String metaClass) {
        if (metaClass.equals("WDModelUsage")) {
            return true;
        }
        if (metaClass.equals("WDView")) {
            return false;
        }
        return DataLinkUtils.isValidSourceParticipantMetaClass(metaClass);
    }

    public static boolean isValidParticipantMetaClass(String metaClass) {
        return DataLinkUtils.isValidSourceParticipantMetaClass(metaClass) || DataLinkUtils.isValidTargetParticipantMetaClass(metaClass);
    }

    public static boolean isValidParticipantsCombination(DevelopmentObject source, DevelopmentObject target, DataLinkSourceManager linkManager) {
        if (source instanceof View) {
            source = ((View)source).getViewController();
        }
        if (target instanceof ComponentControllerUsage) {
            ComponentControllerUsage targetUsage = (ComponentControllerUsage)target;
            target = targetUsage.getUsedComponentController();
        }
        if (source instanceof Controller && target instanceof Controller) {
            return ControllerUsageService.isRequiredControllerRelationshipAllowed((Controller)((Controller)source), (Controller)((Controller)target));
        }
        if (source instanceof ComponentControllerUsage && target instanceof Controller) {
            return ControllerUsageService.isRequiredControllerRelationshipAllowed((ComponentControllerUsage)((ComponentControllerUsage)source), (Controller)((Controller)target));
        }
        if (target instanceof Model && !(source instanceof ComponentControllerUsage)) {
            DataLink[] links = linkManager.getDataLinkManager().getOutgoingDataLinks(source);
            int i = 0;
            while (i < links.length) {
                if (links[i].getTarget() == target) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidDataViewEntityMetaClass(String metaClass) {
        return DataLinkUtils.isValidParticipantMetaClass(metaClass) || metaClass.equals("WDCustomControllers") || metaClass.equals("WDViews") || metaClass.equals("WDModelUsages") || metaClass.equals("WDModelClass") || metaClass.equals("WDComponentInterface") || metaClass.equals("WDComponentUsages") || metaClass.equals("WDComponentUsage") || metaClass.equals("WDComponent") || metaClass.equals("WDDataLink");
    }

    public static boolean isValidParticipantObjectType(DevelopmentObject participantObject) {
        return participantObject instanceof Controller || participantObject instanceof View || participantObject instanceof Model || participantObject instanceof ComponentControllerUsage;
    }

    public static String mapObjectTypeToSubDomain(DevelopmentObject object) {
        String subDomain = null;
        if (object instanceof ControllerUsage) {
            object = ((ControllerUsage)object).getUsedController();
        }
        if (object instanceof Controller) {
            Controller controller = (Controller)object;
            if (controller.getType() == ControllerTypeEnum.COMPONENT) {
                subDomain = "ComponentController";
            } else if (controller.getType() == ControllerTypeEnum.COMPONENT_INTERFACE) {
                if (controller.getParent() instanceof ComponentInterfaceImplementation) {
                    subDomain = "InterfaceController";
                } else if (controller.getParent() instanceof ComponentInterfaceDefinition) {
                    subDomain = "CIDInterfaceController";
                }
            } else if (controller.getType() == ControllerTypeEnum.CUSTOM) {
                subDomain = "CustomController";
            }
        } else if (object instanceof ComponentUsage) {
            subDomain = "ComponentUsage";
        } else if (object instanceof View) {
            subDomain = "View";
        } else if (object instanceof Model) {
            subDomain = "ModelUsage";
        }
        return subDomain;
    }

    public static UniqueName createUINForComponentUsageController(DataLinkSourceManager manager, ComponentControllerUsage usage) {
        Controller usedCompController = usage.getUsedComponentController();
        return DataLinkUtils.createUINForComponentUsageController(manager, usage.getComponentUsage(), usedCompController);
    }

    public static UniqueName createUINForComponentUsageController(DataLinkSourceManager manager, ControllerUsage usage) {
        if (usage.hasComponentUsage()) {
            return DataLinkUtils.createUINForComponentUsageController(manager, usage.getComponentUsage(), usage.getUsedController());
        }
        return null;
    }

    private static UniqueName createUINForComponentUsageController(DataLinkSourceManager manager, ComponentUsage usage, Controller usedCompController) {
        String subDomain = null;
        ComponentInterface compInterface = usage.getUsedComponent();
        if (usedCompController != compInterface.getInterfaceController()) {
            return null;
        }
        subDomain = "ComponentUsageInterfaceController";
        return manager.createUniqueName((DevelopmentObject)usage, subDomain, (DevelopmentObject)usedCompController);
    }

    public static UniqueName createUINForModelUsage(DataLinkSourceManager manager, Model model, DevelopmentObject source) {
        Component component = null;
        DevelopmentObject parent = source.getParent();
        if (parent instanceof Component) {
            component = (Component)parent;
        } else if (parent instanceof ComponentInterfaceImplementation) {
            component = (Component)((ComponentInterfaceImplementation)parent).getParent();
        } else {
            return null;
        }
        return manager.createUniqueName((DevelopmentObject)component, "ModelUsage", (DevelopmentObject)model);
    }

    public static UniqueName createUniqueNameForSourceObject(DevelopmentObject sourceObject, DataLinkSourceManager manager) {
        if (sourceObject instanceof ComponentControllerUsage) {
            return DataLinkUtils.createUINForComponentUsageController(manager, (ComponentControllerUsage)sourceObject);
        }
        return manager.createUniqueName(sourceObject);
    }

    public static DevelopmentObject getSourceParticipantObject(Entity sourceEntity, DataSourceManager manager) {
        Object sourceObject = null;
        String targetMetaClass = sourceEntity.getPropertyValue("$metaclass");
        sourceObject = targetMetaClass.equals("WDComponentUsageInterfaceController") ? DataLinkUtils.getComponentControllerUsageByUsedController(sourceEntity, manager) : manager.findDevelopmentObject(sourceEntity.getUniqueName());
        return sourceObject;
    }

    public static DevelopmentObject getTargetParticipantObject(Entity targetEntity, DataSourceManager manager) {
        Object targetObject = null;
        String targetMetaClass = targetEntity.getPropertyValue("$metaclass");
        targetObject = targetMetaClass.equals("WDModelUsage") ? manager.findDevelopmentObject(targetEntity.getUniqueName().getLocation()) : (targetMetaClass.equals("WDComponentUsageInterfaceController") ? DataLinkUtils.getComponentControllerUsageByUsedController(targetEntity, manager) : manager.findDevelopmentObject(targetEntity.getUniqueName()));
        return targetObject;
    }

    private static ComponentControllerUsage getComponentControllerUsageByUsedController(Entity usedControllerEntity, DataSourceManager manager) {
        Controller usedController = (Controller)manager.findDevelopmentObject(usedControllerEntity.getUniqueName().getLocation());
        Entity compUsageEntity = usedControllerEntity.getParent();
        ComponentUsage componentUsage = (ComponentUsage)manager.findDevelopmentObject(compUsageEntity.getUniqueName());
        ComponentControllerUsage[] compControllerUsages = componentUsage.getComponentControllerUsages();
        int i = 0;
        while (i < compControllerUsages.length) {
            if (compControllerUsages[i].getUsedComponentController() == usedController) {
                return compControllerUsages[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean checkWriteability(DevelopmentObject sourceObject) {
        MMRepositoryObject[] repositoryObjects = new MMRepositoryObject[]{};
        if (sourceObject instanceof Controller) {
            Controller sourceController = (Controller)sourceObject;
            repositoryObjects = ControllerUsageService.getRepositoryObjectsAffectedByControllerUsageCreation((Controller)sourceController);
        } else {
            if (sourceObject instanceof ControllerUsage) {
                return DataLinkUtils.checkWriteability((DevelopmentObject)((ControllerUsage)sourceObject).getUsedController());
            }
            if (sourceObject instanceof View) {
                return DataLinkUtils.checkWriteability((DevelopmentObject)((View)sourceObject).getViewController());
            }
            if (sourceObject instanceof ComponentControllerUsage) {
                ComponentControllerUsage sourceUsage = (ComponentControllerUsage)sourceObject;
                repositoryObjects = ControllerUsageService.getRepositoryObjectsAffectedByControllerUsageCreation((ComponentControllerUsage)sourceUsage);
            } else {
                throw new IllegalArgumentException("Unsupported object type: " + sourceObject);
            }
        }
        return RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects);
    }
}

