/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider.datalink;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.exception.InvalidKeyException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager;
import com.sap.ide.metamodel.webdynpro.services.ServicesEclipse;
import com.sap.ide.metamodelsupplement.webdynpro.DataLinkManager;
import com.sap.ide.metamodelsupplement.webdynpro.events.DataLinkObserver;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLink;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.UpdateDescription;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkDeltaProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkUtils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class DataLinkSourceManager
implements DataLinkObserver {
    private static Map mInstanceMap = new HashMap();
    private DataLinkManager mLinkManager;
    private String mProjectName;
    private DataLinkDeltaProvider mDeltaProvider;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$tsmodel$application$provider$datalink$DataLinkSourceManager;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$tsmodel$application$provider$DataSourceManager;

    private DataLinkSourceManager(String projectName) {
        this.mProjectName = projectName;
        this.mLinkManager = DataLinkManager.getDataLinkManager((String)projectName);
        if (this.mLinkManager == null) {
            String message = "Fatal Error: DataLinkManager not existing. projectName = " + projectName;
            TsmodelWebDynproPlugin.internalError(class$com$sap$ide$webdynpro$tsmodel$application$provider$datalink$DataLinkSourceManager == null ? (class$com$sap$ide$webdynpro$tsmodel$application$provider$datalink$DataLinkSourceManager = DataLinkSourceManager.class$("com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkSourceManager")) : class$com$sap$ide$webdynpro$tsmodel$application$provider$datalink$DataLinkSourceManager, "DataLinkSourceManager", message, null, false);
            return;
        }
        this.mLinkManager.addDataLinkObserver((DataLinkObserver)this);
    }

    public static DataLinkSourceManager getDataSourceManager(String projectName) {
        DataLinkSourceManager manager = (DataLinkSourceManager)mInstanceMap.get(projectName);
        if (manager == null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!ProjectService.projectExists((String)projectName)) {
                String message = "Fatal Error: project is not exisiting. projectName = " + projectName;
                TsmodelWebDynproPlugin.internalError(class$com$sap$ide$webdynpro$tsmodel$application$provider$DataSourceManager == null ? (class$com$sap$ide$webdynpro$tsmodel$application$provider$DataSourceManager = DataLinkSourceManager.class$("com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager")) : class$com$sap$ide$webdynpro$tsmodel$application$provider$DataSourceManager, "getDataSourceManager", message, null, false);
                return null;
            }
            if (!ServicesEclipse.projectHasWebDynproNature((String)projectName)) {
                String message = "Fatal Error: project does not have WebDynpro nature. projectName = " + projectName;
                TsmodelWebDynproPlugin.internalError(class$com$sap$ide$webdynpro$tsmodel$application$provider$DataSourceManager == null ? (class$com$sap$ide$webdynpro$tsmodel$application$provider$DataSourceManager = DataLinkSourceManager.class$("com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager")) : class$com$sap$ide$webdynpro$tsmodel$application$provider$DataSourceManager, "getDataSourceManager", message, null, false);
                return null;
            }
            manager = new DataLinkSourceManager(projectName);
            mInstanceMap.put(projectName, manager);
        }
        return manager;
    }

    public DevelopmentObject getDevelopmentObject(UniqueName uniqueName) {
        DevelopmentObject developmentObject = this.findDevelopmentObject(uniqueName);
        if (developmentObject == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "getDevelopmentObject", "Object is not existing: " + uniqueName.toString(), null, true);
        }
        return developmentObject;
    }

    public DevelopmentObject findDevelopmentObject(UniqueName uniqueName) {
        String key = uniqueName.getName();
        return this.findDevelopmentObject(key);
    }

    public DevelopmentObject findDevelopmentObject(String key) {
        key = key.replace('#', ':');
        DevelopmentObjectKey keyObject = null;
        try {
            keyObject = this.getMetamodel().createDevelopmentObjectKeyFromString(key);
        }
        catch (InvalidKeyException e) {
            return null;
        }
        if (!this.getMetamodel().objectExists(keyObject)) {
            return null;
        }
        return this.getMetamodel().getObjectFromKey(keyObject);
    }

    public UniqueName createUniqueName(DevelopmentObject object) {
        String subDomain = DataLinkUtils.mapObjectTypeToSubDomain(object);
        return this.createUniqueName(object, subDomain, null);
    }

    public UniqueName createUniqueName(DevelopmentObject object, String subDomain, DevelopmentObject objectForLocation) {
        String name = DataSourceManager.adaptKey(object.getKey().toString());
        String location = null;
        if (objectForLocation != null) {
            location = DataSourceManager.adaptKey(objectForLocation.getKey().toString());
        }
        return ModelAccess.createUniqueName((String)"WebDynpro", (String)subDomain, (String)location, (String)name, null);
    }

    public static void removeDataSourceManager(String projectName) {
        DataLinkSourceManager manager = (DataLinkSourceManager)mInstanceMap.get(projectName);
        if (manager == null) {
            return;
        }
        mInstanceMap.remove(projectName);
        manager.destructor();
    }

    private void destructor() {
        this.mLinkManager.removeDataLinkObserver((DataLinkObserver)this);
        this.mLinkManager = null;
        this.mProjectName = null;
        this.mDeltaProvider = null;
    }

    public DataLinkManager getDataLinkManager() {
        return this.mLinkManager;
    }

    public Metamodel getMetamodel() {
        Metamodel metamodel = MetamodelManager.getMetamodel((String)this.mProjectName);
        return metamodel;
    }

    public WebDynproRoot getWebDynproRoot() {
        Metamodel metamodel = this.getMetamodel();
        WebDynproRoot webDynproRoot = metamodel != null ? WebDynproRootManager.getWebDynproRoot((Metamodel)metamodel) : null;
        return webDynproRoot;
    }

    public void setDeltaProvider(DataLinkDeltaProvider provider) {
        this.mDeltaProvider = provider;
    }

    public void removeDeltaProvider() {
        this.mDeltaProvider = null;
    }

    public void dataLinkCreated(DataLink dataLink) {
        boolean deltasExist;
        if (this.mDeltaProvider != null && (deltasExist = this.updateOnCreation(dataLink))) {
            this.updateModel(this.mDeltaProvider.getModel());
        }
    }

    public void dataLinkDeleted(DataLink dataLink) {
        boolean deltasExist;
        if (this.mDeltaProvider != null && (deltasExist = this.updateOnDeletion(dataLink))) {
            this.updateModel(this.mDeltaProvider.getModel());
        }
    }

    private void updateModel(Model model) {
        model.getExtensionManager().modelContentsChanged();
    }

    private boolean updateOnCreation(DataLink dataLink) {
        if (dataLink != null && dataLink.getSource() != null && dataLink.getTarget() != null) {
            UniqueName parentUIN;
            DevelopmentObject source = dataLink.getSource();
            if (source instanceof ComponentControllerUsage) {
                ComponentControllerUsage usage = (ComponentControllerUsage)source;
                parentUIN = DataLinkUtils.createUINForComponentUsageController(this, usage);
            } else {
                parentUIN = this.createUniqueName(source);
            }
            UpdateDescription updateDescription = new UpdateDescription(parentUIN, ModelDeltaNodeKind.CHANGED);
            this.mDeltaProvider.update(updateDescription);
            return true;
        }
        return false;
    }

    private boolean updateOnDeletion(DataLink dataLink) {
        if (dataLink != null) {
            UniqueName dataLinkUIN = dataLink.getUniqueName();
            Element element = this.mDeltaProvider.getModel().findElement(dataLinkUIN);
            UpdateDescription updateDescription = new UpdateDescription(element.getParent().getUniqueName(), ModelDeltaNodeKind.CHANGED);
            this.mDeltaProvider.update(updateDescription);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

