/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider.datalink;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLink;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkUtils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.enum.ArrayEnumeration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class DataLinkProvider
extends DataLinkModelAware
implements LinkProvider {
    public static final String SOURCE_ROLE = "Client";
    public static final String TARGET_ROLE = "Supplier";
    public static final String[] ROLES = new String[]{"Client", "Supplier"};

    public boolean isLinkProviderApplicable(Entity link) {
        return DataLinkUtils.linkHasValidSubdomain((Element)link);
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        Vector<UniqueName> participantsList = new Vector<UniqueName>();
        DataLink dataLink = this.mDataSourceManager.getDataLinkManager().findDataLink(link.getUniqueName());
        if (dataLink != null) {
            if (role == SOURCE_ROLE) {
                DevelopmentObject sourceObject = dataLink.getSource();
                if (sourceObject == null) {
                    TsmodelWebDynproPlugin.internalError(this.getClass(), "participants", "Data link has no source object", null, false);
                } else if (sourceObject instanceof ComponentControllerUsage) {
                    ComponentControllerUsage usage = (ComponentControllerUsage)sourceObject;
                    participantsList.add(DataLinkUtils.createUINForComponentUsageController(this.mDataSourceManager, usage));
                } else {
                    participantsList.add(this.mDataSourceManager.createUniqueName(sourceObject));
                }
            } else if (role == TARGET_ROLE) {
                DevelopmentObject targetObject = dataLink.getTarget();
                if (targetObject == null) {
                    TsmodelWebDynproPlugin.internalError(this.getClass(), "participants", "Data link has no target object", null, false);
                } else if (targetObject instanceof Model) {
                    UniqueName modelUsageUIN = DataLinkUtils.createUINForModelUsage(this.mDataSourceManager, (Model)targetObject, dataLink.getSource());
                    if (modelUsageUIN != null) {
                        participantsList.add(modelUsageUIN);
                    }
                } else if (targetObject instanceof ComponentControllerUsage) {
                    ComponentControllerUsage usage = (ComponentControllerUsage)targetObject;
                    participantsList.add(DataLinkUtils.createUINForComponentUsageController(this.mDataSourceManager, usage));
                } else if (targetObject instanceof ControllerUsage) {
                    ControllerUsage usage = (ControllerUsage)targetObject;
                    participantsList.add(DataLinkUtils.createUINForComponentUsageController(this.mDataSourceManager, usage));
                } else {
                    participantsList.add(this.mDataSourceManager.createUniqueName(targetObject));
                }
            }
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(participantsList));
    }

    public StringEnumeration participantRoles(Entity link) {
        return EnumerationConverter.toStringEnumeration((Enumeration)new ArrayEnumeration((Object[])ROLES));
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        DataLink dataLink = this.mDataSourceManager.getDataLinkManager().findDataLink(link.getUniqueName());
        if (dataLink == null) {
            return;
        }
        DevelopmentObject newObject = this.mDataSourceManager.getDevelopmentObject(newParticipant.getUniqueName());
        if (!DataLinkUtils.isValidParticipantObjectType(newObject)) {
            return;
        }
        if (role == SOURCE_ROLE || role == TARGET_ROLE) {
            // empty if block
        }
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        return true;
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return true;
    }
}

