/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider.datalink;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLink;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkBasePropertyProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkUtils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.Collections;
import java.util.Vector;

public class DataLinkPropertyProvider
extends DataLinkBasePropertyProvider
implements PropertySetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return DataLinkUtils.linkHasValidSubdomain(element);
    }

    public PropertyEnumeration properties(Element element) {
        Vector<Property> list = new Vector<Property>();
        list.add(this.getProperty(element, "$name"));
        list.add(this.getProperty(element, "$metaclass"));
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(list));
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (propertyName.equals("$metaclass")) {
            return "WDDataLink";
        }
        DataLink dataLink = this.mDataSourceManager.getDataLinkManager().findDataLink(element.getUniqueName());
        if (dataLink != null) {
            if (propertyName.equals("$name")) {
                return this.getNameProperty(dataLink);
            }
            if (propertyName.equals("sourceObject")) {
                return this.getObjectForSourceProperty(dataLink).getName();
            }
            if (propertyName.equals("sourceObjectType")) {
                return this.getObjectTypeName(this.getObjectForSourceProperty(dataLink));
            }
            if (propertyName.equals("targetObject")) {
                return this.getObjectForTargetProperty(dataLink).getName();
            }
            if (propertyName.equals("targetObjectType")) {
                return this.getObjectTypeName(this.getObjectForTargetProperty(dataLink));
            }
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    private String getObjectTypeName(DevelopmentObject object) {
        if (object instanceof Controller) {
            Controller controller = (Controller)object;
            return controller.getType().getDescriptiveText() + " controller";
        }
        String lTypeName = object.getClass().getName();
        lTypeName = lTypeName.substring(0, lTypeName.indexOf("Proxy"));
        lTypeName = lTypeName.substring(lTypeName.lastIndexOf(46) + 1);
        return lTypeName;
    }

    private String getNameProperty(DataLink link) {
        DevelopmentObject target = link.getTarget();
        DevelopmentObject source = link.getSource();
        StringBuffer name = new StringBuffer();
        if (target instanceof ControllerUsage && ((ControllerUsage)target).hasComponentUsage()) {
            ControllerUsage controllerUsage = (ControllerUsage)target;
            ComponentUsage componentUsage = controllerUsage.getComponentUsage();
            name.append(componentUsage.getName());
            name.append(" ");
            ComponentInterface compIf = componentUsage.getUsedComponent();
            if (compIf.getConfigurationController().equals(controllerUsage.getUsedController())) {
                name.append(TextPool.getInstance().getText(463));
            } else if (compIf.getInterfaceController().equals(controllerUsage.getUsedController())) {
                name.append(TextPool.getInstance().getText(464));
            }
        } else {
            name.append(target.getName());
        }
        return name.toString();
    }

    private DevelopmentObject getObjectForSourceProperty(DataLink link) {
        DevelopmentObject source = link.getSource();
        if (source instanceof ComponentControllerUsage) {
            ComponentControllerUsage usage = (ComponentControllerUsage)source;
            return usage.getUsedComponentController();
        }
        return source;
    }

    private DevelopmentObject getObjectForTargetProperty(DataLink link) {
        DevelopmentObject target = link.getTarget();
        if (target instanceof ComponentControllerUsage) {
            ComponentControllerUsage usage = (ComponentControllerUsage)target;
            return usage.getUsedComponentController();
        }
        return target;
    }
}

