/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider.datalink;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElementMapping;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodelsupplement.webdynpro.DataLinkManager;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLink;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesDeletion;
import com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.tsmodel.application.actions.datalink.EditDataLinkAction;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkUtils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;

public class DataLinkNodeProvider
extends DataLinkModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        boolean canCreate;
        if (parent == null || template == null || shapeType == null) {
            return false;
        }
        if (!DataLinkUtils.hasValidDomain(parent.getUniqueName())) {
            return false;
        }
        String projectName = parent.getModel().getUniqueName().getName();
        DataSourceManager sourceManager = DataSourceManager.getDataSourceManager(projectName);
        DataLinkSourceManager linkManager = DataLinkSourceManager.getDataSourceManager(projectName);
        if (sourceManager == null || linkManager == null) {
            return false;
        }
        String sourceMetaClass = parent.getPropertyValue("$metaclass");
        String targetMetaClass = null;
        Entity target = null;
        ElementEnumeration targetParticipants = template.participants("Supplier");
        if (targetParticipants.hasMoreElements()) {
            target = (Entity)targetParticipants.nextElement();
            targetMetaClass = target.getPropertyValue("$metaclass");
        }
        boolean bl = canCreate = shapeType.equals("WDDataLink") && sourceMetaClass != null && DataLinkUtils.isValidSourceParticipantMetaClass(sourceMetaClass);
        if (target != null) {
            DevelopmentObject sourceObject = DataLinkUtils.getSourceParticipantObject(parent, sourceManager);
            DevelopmentObject targetObject = DataLinkUtils.getTargetParticipantObject(target, sourceManager);
            canCreate &= DataLinkUtils.isValidParticipantsCombination(sourceObject, targetObject, linkManager);
        }
        return canCreate;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        String projectName = parent.getModel().getUniqueName().getName();
        DataSourceManager sourceManager = DataSourceManager.getDataSourceManager(projectName);
        DataLinkSourceManager linkManager = DataLinkSourceManager.getDataSourceManager(projectName);
        if (sourceManager == null || linkManager == null) {
            return null;
        }
        DevelopmentObject sourceObject = DataLinkUtils.getSourceParticipantObject(parent, sourceManager);
        DevelopmentObject targetObject = null;
        ElementEnumeration targetParticipants = template.participants("Supplier");
        if (targetParticipants.hasMoreElements()) {
            Entity participant = (Entity)targetParticipants.nextElement();
            targetObject = DataLinkUtils.getTargetParticipantObject(participant, sourceManager);
        }
        if (sourceObject == null || targetObject == null || !DataLinkUtils.isValidParticipantObjectType(sourceObject) || !DataLinkUtils.isValidParticipantObjectType(targetObject)) {
            return null;
        }
        if (this.isNewLink(sourceObject, targetObject, linkManager) && !DataLinkUtils.checkWriteability(sourceObject)) {
            return null;
        }
        EditDataLinkAction action = new EditDataLinkAction();
        action.run(sourceObject, targetObject);
        return DataLinkManager.createUniqueName((DevelopmentObject)sourceObject, (DevelopmentObject)targetObject);
    }

    public boolean exists(UniqueName uniqueName) {
        return DataLinkUtils.linkExists(this.mDataSourceManager, uniqueName, "DataLink");
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        String metaClass = parent.getPropertyValue("$metaclass");
        return DataLinkUtils.hasValidDomain(parent.getUniqueName()) && DataLinkUtils.isValidParticipantMetaClass(metaClass);
    }

    public UniqueNameEnumeration children(Entity parent) {
        Vector<UniqueName> uniqueNamesList = new Vector<UniqueName>();
        DevelopmentObject parentObject = this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        if (parentObject == null) {
            return null;
        }
        if (parentObject instanceof ComponentUsage) {
            ComponentUsage usage = (ComponentUsage)parentObject;
            Controller compController = (Controller)this.mDataSourceManager.findDevelopmentObject(parent.getUniqueName().getLocation());
            ComponentControllerUsage[] contrUsages = usage.getComponentControllerUsages();
            int i = 0;
            while (i < contrUsages.length) {
                ComponentControllerUsage contrUsage = contrUsages[i];
                if (contrUsage.getUsedComponentController() == compController) {
                    parentObject = contrUsage;
                    break;
                }
                ++i;
            }
        }
        DataLink[] links = this.mDataSourceManager.getDataLinkManager().getOutgoingDataLinks(parentObject);
        int j = 0;
        while (j < links.length) {
            DataLink link = links[j];
            uniqueNamesList.add(link.getUniqueName());
            ++j;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(uniqueNamesList));
    }

    public UniqueName getParentUniqueName(Element child) {
        DataLink link;
        if (this.exists(child.getUniqueName()) && (link = this.mDataSourceManager.getDataLinkManager().findDataLink(child.getUniqueName())) != null) {
            return DataLinkUtils.createUniqueNameForSourceObject(link.getSource(), this.mDataSourceManager);
        }
        return null;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        if (element instanceof Entity) {
            Entity entity = (Entity)element;
            ElementEnumeration targetParticipants = entity.participants("Supplier");
            if (targetParticipants.hasMoreElements()) {
                Entity participant = (Entity)targetParticipants.nextElement();
                String targetMetaClass = participant.getPropertyValue("$metaclass");
                if (!targetMetaClass.equals("WDModelUsage")) {
                    return true;
                }
            }
        }
        return false;
    }

    public void delete(Element element) {
        if (element instanceof Entity) {
            Entity entity = (Entity)element;
            String projectName = element.getModel().getUniqueName().getName();
            DataSourceManager sourceManager = DataSourceManager.getDataSourceManager(projectName);
            if (sourceManager == null) {
                return;
            }
            DevelopmentObject sourceObject = null;
            DevelopmentObject targetObject = null;
            ElementEnumeration sourceParticipants = entity.participants("Client");
            if (sourceParticipants.hasMoreElements()) {
                Entity participant = (Entity)sourceParticipants.nextElement();
                sourceObject = DataLinkUtils.getTargetParticipantObject(participant, sourceManager);
            }
            ElementEnumeration targetParticipants = entity.participants("Supplier");
            if (targetParticipants.hasMoreElements()) {
                Entity participant = (Entity)targetParticipants.nextElement();
                targetObject = DataLinkUtils.getTargetParticipantObject(participant, sourceManager);
            }
            ControllerUsage usage = this.findControllerUsage(sourceObject, targetObject);
            boolean isReverseMapping = this.isReverseMapping(sourceObject, targetObject);
            if (usage != null) {
                int userDecision = this.raiseDialogForDeletion();
                switch (userDecision) {
                    case 0: {
                        if (!DataLinkUtils.checkWriteability(sourceObject)) break;
                        this.deleteControllerUsage(usage, isReverseMapping);
                        break;
                    }
                    case 1: {
                        if (!DataLinkUtils.checkWriteability(sourceObject)) break;
                        this.deleteMappings(usage, isReverseMapping);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    public boolean isDeleted(Element element) {
        if (element instanceof Entity && element.getUniqueName().getDomain().equals("WebDynpro") && element.getUniqueName().getSubDomain().equals("DataLink")) {
            return false;
        }
        return !this.exists(element.getUniqueName());
    }

    private int raiseDialogForDeletion() {
        String message;
        String title = TextPool.getInstance().getText(314);
        MessageDialog dialog = UIHelper.createMessageDialogToDecide((String)title, (String)(message = TextPool.getInstance().getText(219)), (int)3, (int)0);
        if (dialog.open() == 0) {
            return 0;
        }
        return -1;
    }

    private void deleteMappings(ControllerUsage usage, boolean isReverseMapping) {
        ContextElementMapping[] mappings = usage.getContextMappings();
        int i = 0;
        while (i < mappings.length) {
            ContextElementMapping mapping = mappings[i];
            ServicesDeletion.deleteMapping((ContextElement)mapping.getOwnElement(), (ControllerUsage[])new ControllerUsage[]{usage}, (!isReverseMapping ? 1 : 0) != 0, (boolean)false);
            ++i;
        }
    }

    private void deleteControllerUsage(ControllerUsage usage, boolean isReverseMapping) {
        ControllerUsageService.deleteControllerUsage((ControllerUsage)usage);
    }

    private ControllerUsage findControllerUsage(DevelopmentObject sourceObject, DevelopmentObject targetObject) {
        if (sourceObject instanceof ControllerUsage) {
            return (ControllerUsage)sourceObject;
        }
        ControllerUsage[] usages = new ControllerUsage[]{};
        if (sourceObject instanceof View) {
            sourceObject = ((View)sourceObject).getViewController();
        }
        if (sourceObject instanceof Controller) {
            Controller sourceController = (Controller)sourceObject;
            usages = sourceController.getOutgoingControllerUsages();
        } else if (sourceObject instanceof ComponentControllerUsage) {
            ComponentControllerUsage sourceCompContrUsage = (ComponentControllerUsage)sourceObject;
            usages = sourceCompContrUsage.getOutgoingControllerUsages();
        }
        if (targetObject instanceof ComponentControllerUsage) {
            ComponentControllerUsage targetCompContrUsage = (ComponentControllerUsage)targetObject;
            targetObject = targetCompContrUsage.getUsedComponentController();
        }
        int i = 0;
        while (i < usages.length) {
            ControllerUsage usage = usages[i];
            if (usage.hasUsedController() && usage.getUsedController() == targetObject) {
                return usage;
            }
            ++i;
        }
        return null;
    }

    private boolean isReverseMapping(DevelopmentObject sourceObject, DevelopmentObject targetObject) {
        return sourceObject instanceof ComponentControllerUsage;
    }

    private boolean isNewLink(DevelopmentObject sourceObject, DevelopmentObject targetObject, DataLinkSourceManager manager) {
        DataLink[] links = manager.getDataLinkManager().getOutgoingDataLinks(sourceObject);
        int i = 0;
        while (i < links.length) {
            DataLink link = links[i];
            if (link.getTarget() == targetObject) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

