/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.tsmodel.application.provider.BasePropertyProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class WindowPropertyProvider
extends BasePropertyProvider
implements PropertySetProvider {
    private static final String DIAGRAM_SUFFIX = "Diagram";
    public static final String WINDOW_DIAGRAM_FILE_EXTENSION = "txvWDWindowDiagram";

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return Utils.uniqueNameHasSubdomain(element, "Window");
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.getProperty(element, "$name"));
        list.add(this.getProperty(element, "$metaclass"));
        list.add(this.getProperty(element, "default"));
        list.add(this.getProperty(element, "$diagram_folder"));
        list.add(this.getProperty(element, "$meta:child:referenceCollection"));
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(list));
    }

    public boolean hasProperty(Element element, String propertyName) {
        Window window = (Window)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (window == null) {
            return false;
        }
        return super.hasProperty(element, propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (propertyName.equals("$metaclass")) {
            return "WDWindow";
        }
        Window window = (Window)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (window == null) {
            return null;
        }
        if (propertyName.equals("$name")) {
            return window.getName();
        }
        if (propertyName.equals("title")) {
            return window.getTitle();
        }
        if (propertyName.equals("$diagram_folder")) {
            return Utils.getDiagramFolder(this.mProjectName, (MainDevelopmentObject)window);
        }
        if (propertyName.equals("$meta:child:referenceCollection")) {
            return "WDWindowDiagram";
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyName.equals("default") || propertyName.equals("title");
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        Window window = (Window)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (window == null) {
            return;
        }
        MMRepositoryObject[] repositoryObjects = ServicesDeletion.getRepositoryObjectsAffectedByWindowModification((DevelopmentObject)window);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        if (propertyName.equals("title")) {
            window.setTitle(propertyValue);
            this.mDataSourceManager.commitPropertySet();
        }
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }
}

