/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.webdynpro.service.applicationmodeler.CreationWithUI;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.sap.ide.webdynpro.tsmodel.application.provider.WindowsNodeProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class WindowNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Windows") && shapeType.equals("WDWindow");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Component application = (Component)this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        Window window = CreationWithUI.createWindow((Component)application);
        if (window != null) {
            this.mDataSourceManager.commitChanges();
            return DataSourceManager.createUniqueName((DevelopmentObject)window, "Window");
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return Utils.exists(this.mDataSourceManager, uniqueName, "Window");
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        Window window = (Window)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        Utils.storeDiagram((MainDevelopmentObject)window);
        ServicesDeletion.deleteWindow((Window)window, (boolean)true);
        this.mDataSourceManager.commitChanges();
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Windows");
    }

    public UniqueNameEnumeration children(Entity parent) {
        Component application = (Component)this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        Window[] windows = application.getWindows();
        int i = 0;
        while (i < windows.length) {
            UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)windows[i], "Window");
            list.add(uniqueName);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public UniqueName getParentUniqueName(Element child) {
        if (!this.exists(child.getUniqueName())) {
            return null;
        }
        Window window = (Window)this.mDataSourceManager.getDevelopmentObject(child.getUniqueName());
        if (window == null) {
            return null;
        }
        Component application = (Component)window.getParent();
        if (application == null) {
            return null;
        }
        UniqueName uniqueName = WindowsNodeProvider.createUniqueName(application);
        return uniqueName;
    }
}

