/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.viewset.Viewset;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewsetHierarchyNode;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.tsmodel.application.provider.BasePropertyProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class ViewsetPropertyProvider
extends BasePropertyProvider
implements PropertySetProvider {
    public static String PROPERTY_TYPE = "type";

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return Utils.uniqueNameHasSubdomain(element, "Viewset");
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getProperty(element, "$name"));
        list.add(this.getProperty(element, "$metaclass"));
        list.add(this.getProperty(element, "default"));
        list.add(PROPERTY_TYPE);
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(list));
    }

    public boolean hasProperty(Element element, String propertyName) {
        Viewset viewset = (Viewset)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (viewset == null) {
            return false;
        }
        if (propertyName.equals("default")) {
            boolean isDefault = Utils.isDefaultNode((ViewsetHierarchyNode)viewset);
            return isDefault;
        }
        return super.hasProperty(element, propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (propertyName.equals("$metaclass")) {
            return "WDViewset";
        }
        Viewset viewset = (Viewset)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (viewset == null) {
            return null;
        }
        if (propertyName.equals("$name")) {
            return viewset.getName();
        }
        if (propertyName.equals(PROPERTY_TYPE)) {
            if (viewset.getViewsetDefinition() == null) {
                return "Error: ViewsetDefinition is missing";
            }
            return viewset.getViewsetDefinition().getName();
        }
        if (viewset.hasViewsetProperty(propertyName)) {
            return viewset.getViewsetProperty(propertyName).getValue();
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return true;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        Viewset viewset = (Viewset)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (viewset == null) {
            return;
        }
        MMRepositoryObject[] repositoryObjects = ServicesDeletion.getRepositoryObjectsAffectedByWindowModification((DevelopmentObject)viewset);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        if (propertyName.equals("default")) {
            boolean isDefault = propertyValue != null;
            Utils.setAsDefaultNode((ViewsetHierarchyNode)viewset, isDefault);
            this.mDataSourceManager.commitPropertySet();
        }
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }
}

