/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.component.view.EmptyView;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewUsage;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewsetHierarchyNode;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesVSH;
import com.sap.ide.webdynpro.service.applicationmodeler.TextPool;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.tsmodel.application.provider.BasePropertyProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.sap.ide.webdynpro.ui.service.ServicesUI;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class ViewUsagePropertyProvider
extends BasePropertyProvider
implements PropertySetProvider {
    public static final String EMBEDDED_VIEW_TYPE_INTERFACE_VIEW = "InterfaceView";
    public static final String EMBEDDED_VIEW_TYPE_EMPTY_VIEW = "EmptyView";
    public static final String EMBEDDED_VIEW_TYPE_VIEW = "View";

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return Utils.uniqueNameHasSubdomain(element, "ViewUsage");
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.getProperty(element, "$name"));
        list.add(this.getProperty(element, "$metaclass"));
        list.add(this.getProperty(element, "default"));
        list.add(this.getProperty(element, "id"));
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(list));
    }

    public boolean hasProperty(Element element, String propertyName) {
        ViewUsage viewUsage = (ViewUsage)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (viewUsage == null) {
            return false;
        }
        if (propertyName.equals("default")) {
            boolean isDefault = Utils.isDefaultNode((ViewsetHierarchyNode)viewUsage);
            return isDefault;
        }
        return super.hasProperty(element, propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (propertyName.equals("$metaclass")) {
            return "WDViewUsage";
        }
        ViewUsage viewUsage = (ViewUsage)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (viewUsage == null) {
            return null;
        }
        AbstractView abstractView = viewUsage.getView();
        if (propertyName.equals("embeddedViewName") || propertyName.equals("$name")) {
            if (abstractView != null) {
                if (abstractView instanceof InterfaceView) {
                    if (viewUsage.getComponentUsage() != null) {
                        String componentInstanceName = viewUsage.getComponentUsage().getName();
                        return componentInstanceName + "." + abstractView.getName();
                    }
                    return "Error: Component Instance is missing";
                }
                return abstractView.getName();
            }
            return "Error: View is missing";
        }
        if (propertyName.equals("embeddedViewPackage")) {
            if (abstractView != null && abstractView instanceof MainDevelopmentObject) {
                return ((MainDevelopmentObject)abstractView).getPackage();
            }
        } else if (propertyName.equals("embeddedViewPath")) {
            if (abstractView != null && abstractView instanceof MainDevelopmentObject) {
                return ((MainDevelopmentObject)abstractView).getAbsolutePath();
            }
        } else {
            if (propertyName.equals("internalName")) {
                return viewUsage.getName();
            }
            if (propertyName.equals("embeddedViewType")) {
                if (abstractView != null) {
                    if (abstractView instanceof InterfaceView) {
                        return EMBEDDED_VIEW_TYPE_INTERFACE_VIEW;
                    }
                    if (abstractView instanceof EmptyView) {
                        return EMBEDDED_VIEW_TYPE_EMPTY_VIEW;
                    }
                    if (abstractView instanceof View) {
                        return EMBEDDED_VIEW_TYPE_VIEW;
                    }
                }
            } else if (propertyName.equals("id")) {
                return viewUsage.getId();
            }
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return true;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        ViewUsage viewUsage = (ViewUsage)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (viewUsage == null) {
            return;
        }
        MMRepositoryObject[] repositoryObjects = ServicesDeletion.getRepositoryObjectsAffectedByWindowModification((DevelopmentObject)viewUsage);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        if (propertyName.equals("default")) {
            boolean isDefault = propertyValue != null;
            Utils.setAsDefaultNode((ViewsetHierarchyNode)viewUsage, isDefault);
            this.mDataSourceManager.commitPropertySet();
        } else if (propertyName.equals("id")) {
            String id = propertyValue;
            if (!CheckServices.isValidIdentifier((String)id)) {
                TextPool textPool = TextPool.getInstance();
                ServicesUI.displayErrorMessage((String)textPool.getText(600), (String)textPool.getText(42));
                return;
            }
            if (!this.isUniqueId(viewUsage, id)) {
                TextPool textPool = TextPool.getInstance();
                ServicesUI.displayErrorMessage((String)textPool.getText(600), (String)textPool.getText(41));
                return;
            }
            viewUsage.setId(id);
            this.mDataSourceManager.commitPropertySet();
        }
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    private boolean isUniqueId(ViewUsage viewUsage, String id) {
        Window window = (Window)viewUsage.getMDO();
        if (window == null) {
            return false;
        }
        ViewUsage[] viewUsages = ServicesVSH.getAllViewUsages((Window)window);
        int i = 0;
        while (i < viewUsages.length) {
            String lId = viewUsages[i].getId();
            if (lId != null && lId.equalsIgnoreCase(id)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

