/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.viewdesigner.ServiceWithUI;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.sap.ide.webdynpro.tsmodel.application.provider.ViewsNodeProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class ViewNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Views") && shapeType.equals("WDView");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Component component = (Component)this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        Utils.storeDiagram((MainDevelopmentObject)component);
        View view = ServiceWithUI.createView((Component)component);
        if (view != null) {
            this.mDataSourceManager.commitChanges();
            MetamodelManager.saveAllMetaData((String)this.mProjectName);
            return DataSourceManager.createUniqueName((DevelopmentObject)view, "View");
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return Utils.exists(this.mDataSourceManager, uniqueName, "View");
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        View view = (View)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        Utils.storeDiagram((MainDevelopmentObject)view.getComponent());
        ServicesDeletion.deleteView((View)view);
        this.mDataSourceManager.commitChanges();
        MetamodelManager.saveAllMetaData((String)this.mProjectName);
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Views");
    }

    public UniqueNameEnumeration children(Entity parent) {
        Component application = (Component)this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        View[] views = application.getViews();
        int i = 0;
        while (i < views.length) {
            UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)views[i], "View");
            list.add(uniqueName);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public UniqueName getParentUniqueName(Element child) {
        if (!this.exists(child.getUniqueName())) {
            return null;
        }
        View view = (View)this.mDataSourceManager.getDevelopmentObject(child.getUniqueName());
        if (view == null) {
            return null;
        }
        Component application = MetamodelServices.getComponent((DevelopmentObject)view);
        if (application == null) {
            return null;
        }
        UniqueName uniqueName = ViewsNodeProvider.createUniqueName(application);
        return uniqueName;
    }
}

