/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.viewset.Placeholder;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewArea;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewContainerAssignment;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewsetHierarchyNode;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class Utils {
    static /* synthetic */ Class class$com$sap$ide$webdynpro$tsmodel$application$provider$Utils;

    public static boolean exists(DataSourceManager dataSourceManager, UniqueName uniqueName, String subDomain) {
        return uniqueName.getDomain().equals("WebDynpro") && uniqueName.getSubDomain().equals(subDomain) && dataSourceManager.developmentObjectExists(uniqueName);
    }

    public static boolean uniqueNameHasSubdomain(Element element, String subDomain) {
        UniqueName uniqueName = element.getUniqueName();
        return uniqueName.getDomain().equals("WebDynpro") && uniqueName.getSubDomain().equals(subDomain);
    }

    public static UniqueName getParent(DataSourceManager dataSourceManager, Element viewSetHierarchyNodeElement) {
        ViewsetHierarchyNode node = (ViewsetHierarchyNode)dataSourceManager.getDevelopmentObject(viewSetHierarchyNodeElement.getUniqueName());
        if (node == null) {
            return null;
        }
        DevelopmentObject developmentObject = node.getParent();
        String subDomain = developmentObject instanceof Window ? "Window" : (developmentObject instanceof ViewArea ? "ViewArea" : (developmentObject instanceof ViewContainerAssignment ? "ViewContainerAssignment" : null));
        if (subDomain == null) {
            TsmodelWebDynproPlugin.internalError(class$com$sap$ide$webdynpro$tsmodel$application$provider$Utils == null ? (class$com$sap$ide$webdynpro$tsmodel$application$provider$Utils = Utils.class$("com.sap.ide.webdynpro.tsmodel.application.provider.Utils")) : class$com$sap$ide$webdynpro$tsmodel$application$provider$Utils, "getParent", "parent has wrong type", null, false);
            return null;
        }
        UniqueName uniqueName = DataSourceManager.createUniqueName(developmentObject, subDomain);
        return uniqueName;
    }

    public static void setAsDefaultNode(ViewsetHierarchyNode node, boolean isDefault) {
        if (node.getWindow() != null) {
            Window window = node.getWindow();
            if (isDefault) {
                if (window.getDefaultViewsetHierarchyRootNode() != node) {
                    window.setDefaultViewsetHierarchyRootNode(node);
                }
            } else if (window.getDefaultViewsetHierarchyRootNode() == node) {
                window.setDefaultViewsetHierarchyRootNode(null);
            }
        } else {
            Placeholder placeholder = node.getPlaceholder();
            if (isDefault) {
                if (placeholder.getDefaultNode() != node) {
                    placeholder.setDefaultNode(node);
                }
            } else if (placeholder.getDefaultNode() == node) {
                placeholder.setDefaultNode(null);
            }
        }
    }

    public static boolean isDefaultNode(ViewsetHierarchyNode node) {
        if (node.getWindow() != null) {
            Window window = node.getWindow();
            return window.getDefaultViewsetHierarchyRootNode() == node;
        }
        Placeholder placeholder = node.getPlaceholder();
        return placeholder.getDefaultNode() == node;
    }

    public static String getDiagramFolder(String projectName, MainDevelopmentObject mdo) {
        IPath path = ServicesEclipse.getRelativePath((String)projectName, (String)mdo.getAbsolutePath());
        String pathString = path.removeLastSegments(1).toString();
        String deviceString = path.getDevice();
        if (deviceString != null) {
            pathString = pathString.substring(deviceString.length());
        }
        return pathString;
    }

    public static IPath getDiagramFilePath(MainDevelopmentObject mdo) {
        if (!(mdo instanceof Window) && !(mdo instanceof Component)) {
            return null;
        }
        String subDomain = mdo instanceof Window ? "Window" : "Component";
        String projectName = mdo.getRoot().getMetamodel().getName();
        DataSourceManager dataSourceManager = DataSourceManager.getDataSourceManager(projectName);
        if (dataSourceManager == null) {
            return null;
        }
        UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)mdo, subDomain);
        Model model = ModelAccess.getModel((UniqueName)ModelAccess.createModelUniqueName((String)projectName));
        if (model == null) {
            return null;
        }
        Element element = model.findElement(uniqueName);
        if (element == null) {
            return null;
        }
        ReferenceCollection referenceCollection = Utils.getDiagram(element);
        if (referenceCollection == null) {
            return null;
        }
        String path = referenceCollection.getPropertyValue("$file");
        if (path != null) {
            return new Path(path);
        }
        return null;
    }

    public static void deleteDiagram(MainDevelopmentObject mdo) {
        if (!(mdo instanceof Window) && !(mdo instanceof Component)) {
            return;
        }
        if (mdo instanceof Window) {
            Utils.closeWindowDiagram((Window)mdo);
        } else {
            Utils.closeComponentDiagram((Component)mdo);
        }
        IPath path = Utils.getDiagramFilePath(mdo);
        String projectName = mdo.getRoot().getMetamodel().getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile file = project.getFile(path);
        if (!file.exists()) {
            return;
        }
        ArrayList<IFile> filesToDelete = new ArrayList<IFile>();
        filesToDelete.add(file);
        DtrHelper.deleteFiles((IProject)project, filesToDelete, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void openDiagram(Element element) {
        ReferenceCollection diagramToOpen = Utils.getDiagram(element);
        if (diagramToOpen != null) {
            GdePlugin.openDiagram((ReferenceCollection)diagramToOpen, (boolean)true);
        }
    }

    public static void closeDiagram(Element element) {
        ReferenceCollection diagramToClose = Utils.getDiagram(element);
        if (diagramToClose == null) {
            return;
        }
        Model model = element.getModel();
        if (model == null) {
            return;
        }
        ViewManager viewManager = ViewAccess.getViewManager((UniqueName)model.getUniqueName());
        Enumeration views = viewManager.views();
        while (views.hasMoreElements()) {
            View view = (View)views.nextElement();
            if (view.getReferenceCollection() != diagramToClose) continue;
            view.dispose();
            return;
        }
    }

    public static void openWindowDiagram(Window window) {
        Entity windowEntity = Utils.getEntity((DevelopmentObject)window, "Window");
        if (windowEntity != null) {
            Utils.openDiagram((Element)windowEntity);
        }
    }

    public static void closeWindowDiagram(Window window) {
        Entity windowEntity = Utils.getEntity((DevelopmentObject)window, "Window");
        if (windowEntity != null) {
            Utils.closeDiagram((Element)windowEntity);
        }
    }

    public static void closeComponentDiagram(Component component) {
        Entity componentEntity = Utils.getEntity((DevelopmentObject)component, "Component");
        if (componentEntity != null) {
            Utils.closeDiagram((Element)componentEntity);
        }
    }

    public static Entity getEntity(DevelopmentObject developmentObject, String subdomain) {
        UniqueName uniqueName = DataSourceManager.createUniqueName(developmentObject, subdomain);
        String projectName = developmentObject.getRoot().getMetamodel().getName();
        UniqueName modelUIN = ModelAccess.createModelUniqueName((String)projectName);
        Model model = ModelAccess.getModel((UniqueName)modelUIN);
        if (model == null) {
            return null;
        }
        Entity entity = model.findEntity(uniqueName);
        return entity;
    }

    public static ReferenceCollection getDiagram(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ReferenceCollection) {
            return (ReferenceCollection)element;
        }
        String diagramUinAsString = element.getPropertyValue("DiagramUIN");
        if (diagramUinAsString != null) {
            UniqueName diagramUin = ModelAccess.createUniqueName((String)diagramUinAsString);
            return element.getModel().findReferenceCollection(diagramUin);
        }
        return null;
    }

    public static void storeDiagram(MainDevelopmentObject mdo) {
        if (!(mdo instanceof Window) && !(mdo instanceof Component)) {
            return;
        }
        IPath path = Utils.getDiagramFilePath(mdo);
        String projectName = mdo.getRoot().getMetamodel().getName();
        MetamodelManager metamodelManager = MetamodelManager.getMetamodelManager((String)projectName);
        metamodelManager.getStoredFilesManager().addStoredFile((DevelopmentObject)mdo, path);
    }

    public static void forceDiagramFileCreation(Entity entity) {
        entity.childReferenceCollections();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

