/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ServiceWithUI;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class TargetRoleNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!Utils.uniqueNameHasSubdomain((Element)parent, "ModelClass") || !shapeType.equals("WDTargetRole")) {
            return false;
        }
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        if (!(developmentObject instanceof ModelClass)) {
            return false;
        }
        ModelClass modelClass = (ModelClass)developmentObject;
        if (modelClass == null) {
            return false;
        }
        boolean result = MetamodelServices.canCreateModelRelation((ModelClass)modelClass);
        return result;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        ModelRelation modelRelation = null;
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        if (!(developmentObject instanceof ModelClass)) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "createUniqueName", "parent has wrong type", null, false);
            return null;
        }
        ModelClass parentModelClass = (ModelClass)developmentObject;
        modelRelation = ServiceWithUI.createModelRelation((ModelClass)parentModelClass);
        if (modelRelation == null) {
            return null;
        }
        this.mDataSourceManager.commitChanges();
        ModelRelationRole[] roles = modelRelation.getModelRelationRoles();
        if (roles.length != 2) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "createUniqueName", "roles.length != 2", null, false);
            return null;
        }
        ModelRelationRole targetRole = roles[0].getModelClass() == parentModelClass ? roles[1] : roles[0];
        return DataSourceManager.createUniqueName((DevelopmentObject)targetRole, "TargetRole");
    }

    public boolean exists(UniqueName uniqueName) {
        return Utils.exists(this.mDataSourceManager, uniqueName, "TargetRole");
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (!(developmentObject instanceof ModelRelationRole)) {
            return false;
        }
        ModelRelationRole role = (ModelRelationRole)developmentObject;
        ModelRelation modelRelation = role.getModelRelation();
        if (modelRelation == null) {
            return false;
        }
        boolean deletable = MetamodelServices.isModelRelationDeletable((ModelRelation)modelRelation);
        return deletable;
    }

    public void delete(Element element) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (!(developmentObject instanceof ModelRelationRole)) {
            return;
        }
        ModelRelationRole role = (ModelRelationRole)developmentObject;
        ModelRelation modelRelation = role.getModelRelation();
        if (modelRelation == null) {
            return;
        }
        ServiceWithUI.deleteModelRelation((ModelRelation)modelRelation);
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "ModelClass");
    }

    public UniqueNameEnumeration children(Entity parent) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        if (!(developmentObject instanceof ModelClass)) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "children", "parent has wrong type", null, false);
            return null;
        }
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        ModelClass modelClass = (ModelClass)developmentObject;
        ModelRelationRole[] targetRoles = ModelClassHelper.getNavigableTargetModelRelationRoles((ModelClass)modelClass);
        int i = 0;
        while (i < targetRoles.length) {
            ModelRelationRole targetRole = targetRoles[i];
            if (targetRole != null && targetRole.getNavigable()) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)targetRole, "TargetRole");
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    static ModelRelationRole getOppositeRole(ModelRelationRole role) {
        ModelRelation modelRelation = role.getModelRelation();
        if (modelRelation == null) {
            return null;
        }
        ModelRelationRole[] roles = modelRelation.getModelRelationRoles();
        if (roles.length == 2) {
            if (roles[0] == role) {
                return roles[1];
            }
            if (roles[1] == role) {
                return roles[0];
            }
            return null;
        }
        return null;
    }

    public UniqueName getParentUniqueName(Element child) {
        return null;
    }
}

