/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.navigation.NavigationLink;
import com.sap.ide.metamodel.webdynpro.component.navigation.NavigationTargetReference;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewUsage;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.InboundPlugUsage;
import com.sap.ide.webdynpro.tsmodel.application.provider.InboundPlugUsageNodeProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.OutboundPlugUsageNodeProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.enum.ArrayEnumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class NavigationLinkProvider
extends GenericModelAware
implements LinkProvider {
    public static final String SOURCE_ROLE = "Client";
    public static final String TARGET_ROLE = "Supplier";
    private static final String[] ROLES = new String[]{"Client", "Supplier"};

    public boolean isLinkProviderApplicable(Entity link) {
        return Utils.uniqueNameHasSubdomain((Element)link, "NavigationLink");
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        InboundPlug inboundPlug;
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        NavigationTargetReference targetReference = (NavigationTargetReference)this.mDataSourceManager.getDevelopmentObject(link.getUniqueName());
        NavigationLink navigationLink = targetReference.getNavigationLink();
        if (link == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "participants", "link == null", null, false);
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        if (role.equals(SOURCE_ROLE)) {
            OutboundPlug plug = navigationLink.getSource();
            if (plug == null) {
                TsmodelWebDynproPlugin.internalError(this.getClass(), "participants", "navigationLink has no source plug", null, false);
            } else {
                ViewUsage viewUsage = navigationLink.getSourceViewUsage();
                UniqueName uniqueName = OutboundPlugUsageNodeProvider.createOutboundPlugUsageUniqueName(viewUsage, plug);
                list.add(uniqueName);
            }
        } else if (role.equals(TARGET_ROLE) && (inboundPlug = targetReference.getTarget()) != null) {
            ViewUsage viewUsage = targetReference.getTargetViewUsage();
            UniqueName uniqueName = InboundPlugUsageNodeProvider.createInboundPlugUsageUniqueName(viewUsage, inboundPlug);
            list.add(uniqueName);
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public StringEnumeration participantRoles(Entity link) {
        return EnumerationConverter.toStringEnumeration((Enumeration)new ArrayEnumeration((Object[])ROLES));
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        InboundPlugUsage inboundPlugUsage;
        NavigationTargetReference targetReference = (NavigationTargetReference)this.mDataSourceManager.getDevelopmentObject(link.getUniqueName());
        if (!role.equals(SOURCE_ROLE) && role.equals(TARGET_ROLE) && (inboundPlugUsage = InboundPlugUsageNodeProvider.getInboundPlugUsage(this.mDataSourceManager, newParticipant)) != null) {
            targetReference.setTarget(inboundPlugUsage.getInboundPlug());
            targetReference.setTargetViewUsage(inboundPlugUsage.getViewUsage());
        }
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        if (role.equals(TARGET_ROLE)) {
            if (oldParticipant != null && !Utils.uniqueNameHasSubdomain(oldParticipant, "InboundPlugUsage")) {
                return false;
            }
            return newParticipant != null && Utils.uniqueNameHasSubdomain(newParticipant, "InboundPlugUsage");
        }
        if (role.equals(SOURCE_ROLE)) {
            return false;
        }
        return false;
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }
}

