/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ServiceWithUI;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.StructureNodeProviderBase;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class ModelNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Models") && shapeType.equals("WDModel");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Model model = ServiceWithUI.createModel((WebDynproRoot)this.mDataSourceManager.getWebDynproRoot(), (DtDictionaryRoot)this.mDataSourceManager.getDictionaryRoot());
        if (model != null) {
            this.mDataSourceManager.commitChanges();
            return DataSourceManager.createUniqueName((DevelopmentObject)model, "Component");
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return Utils.exists(this.mDataSourceManager, uniqueName, "Model");
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Models");
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        String projectName = parent.getUniqueName().getName();
        Model[] models = null;
        try {
            models = this.mDataSourceManager.getWebDynproRoot().getModels();
        }
        catch (LoadException e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "children", "LoadException", e, false);
            return null;
        }
        int i = 0;
        while (i < models.length) {
            if (!models[i].originatesInArchive()) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)models[i], "Model");
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (!(developmentObject instanceof Model)) {
            return false;
        }
        Model model = (Model)developmentObject;
        boolean deletable = MetamodelServices.isModelDeletable((Model)model);
        return deletable;
    }

    public void delete(Element element) {
        Model model = (Model)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (model != null) {
            ServiceWithUI.deleteModel((Model)model);
            this.mDataSourceManager.commitChanges();
        } else {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "delete", "Model is not existing", null, false);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public UniqueName getParentUniqueName(Element child) {
        if (this.exists(child.getUniqueName())) {
            return StructureNodeProviderBase.createUniqueName("Models");
        }
        return null;
    }
}

